/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.canvas.controls.actions;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.kie.workbench.common.dmn.api.definition.model.DRGElement;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.api.qualifiers.DMNEditor;
import org.kie.workbench.common.dmn.client.commands.factory.DefaultCanvasCommandFactory;
import org.kie.workbench.common.dmn.client.editors.expressions.util.NameUtils;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.controls.actions.TextPropertyProvider;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommand;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandManager;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;

@ApplicationScoped
public class DRGElementTextPropertyProviderImpl
implements TextPropertyProvider {
    private DefaultCanvasCommandFactory canvasCommandFactory;
    private DefinitionUtils definitionUtils;

    public DRGElementTextPropertyProviderImpl() {
    }

    @Inject
    public DRGElementTextPropertyProviderImpl(@DMNEditor DefaultCanvasCommandFactory canvasCommandFactory, DefinitionUtils definitionUtils) {
        this.canvasCommandFactory = canvasCommandFactory;
        this.definitionUtils = definitionUtils;
    }

    public int getPriority() {
        return 1;
    }

    public boolean supports(Element<? extends Definition> element) {
        return DefinitionUtils.getElementDefinition(element) instanceof DRGElement;
    }

    public String getText(Element<? extends Definition> element) {
        DRGElement drgElement = (DRGElement)DefinitionUtils.getElementDefinition(element);
        return drgElement.getNameHolder().getValue().getValue();
    }

    public void setText(AbstractCanvasHandler canvasHandler, CanvasCommandManager<AbstractCanvasHandler> commandManager, Element<? extends Definition> element, String text) {
        Object definition = DefinitionUtils.getElementDefinition(element);
        CanvasCommand command = this.canvasCommandFactory.updatePropertyValue(element, this.definitionUtils.getNameIdentifier(definition), new Name(NameUtils.normaliseName(text)));
        commandManager.execute((Object)canvasHandler, (Command)command);
    }
}

