/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.commands.clone;

import com.google.gwt.regexp.shared.MatchResult;
import com.google.gwt.regexp.shared.RegExp;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.enterprise.inject.Alternative;
import javax.inject.Inject;
import org.kie.workbench.common.dmn.api.definition.HasText;
import org.kie.workbench.common.dmn.api.definition.HasVariable;
import org.kie.workbench.common.dmn.api.definition.model.BusinessKnowledgeModel;
import org.kie.workbench.common.dmn.api.definition.model.DRGElement;
import org.kie.workbench.common.dmn.api.definition.model.Decision;
import org.kie.workbench.common.dmn.api.definition.model.Expression;
import org.kie.workbench.common.dmn.api.definition.model.InformationItemPrimary;
import org.kie.workbench.common.dmn.api.definition.model.IsInformationItem;
import org.kie.workbench.common.dmn.api.definition.model.NamedElement;
import org.kie.workbench.common.dmn.api.property.dmn.DMNExternalLink;
import org.kie.workbench.common.dmn.api.property.dmn.Id;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.api.property.dmn.NameHolder;
import org.kie.workbench.common.dmn.api.property.dmn.Text;
import org.kie.workbench.common.dmn.client.property.dmn.DefaultValueUtilities;
import org.kie.workbench.common.stunner.core.api.FactoryManager;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.definition.adapter.AdapterManager;
import org.kie.workbench.common.stunner.core.definition.clone.DeepCloneProcess;
import org.kie.workbench.common.stunner.core.definition.clone.IDeepCloneProcess;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.util.ClassUtils;

@Alternative
public class DMNDeepCloneProcess
extends DeepCloneProcess
implements IDeepCloneProcess {
    private static final RegExp NAME_SUFFIX_REGEX = RegExp.compile((String)"[?!-]\\d+$");
    private static final String HYPHEN = "-";
    private final SessionManager sessionManager;

    protected DMNDeepCloneProcess() {
        this(null, null, null, null);
    }

    @Inject
    public DMNDeepCloneProcess(FactoryManager factoryManager, AdapterManager adapterManager, ClassUtils classUtils, SessionManager sessionManager) {
        super(factoryManager, adapterManager, classUtils);
        this.sessionManager = sessionManager;
    }

    public <S, T> T clone(S source, T target) {
        super.clone(source, target);
        if (source instanceof DRGElement) {
            this.cloneDRGElementBasicInfo((DRGElement)source, (DRGElement)target);
        }
        if (source instanceof HasText) {
            this.cloneTextElementBasicInfo((HasText)source, (HasText)target);
        }
        if (source instanceof HasVariable) {
            IsInformationItem sourceVariable = ((HasVariable)source).getVariable();
            IsInformationItem targetVariable = ((HasVariable)target).getVariable();
            this.cloneTypeRefInfo(sourceVariable, targetVariable);
        }
        if (source instanceof Decision) {
            this.cloneDecision((Decision)source, (Decision)target);
        }
        if (source instanceof BusinessKnowledgeModel) {
            this.cloneBusinessKnowledgeModel((BusinessKnowledgeModel)source, (BusinessKnowledgeModel)target);
        }
        return target;
    }

    private void cloneDRGElementBasicInfo(DRGElement source, DRGElement target) {
        String uniqueNodeName = this.composeUniqueNodeName(source.getName().getValue());
        target.setId(new Id());
        target.setNameHolder(new NameHolder(new Name(uniqueNodeName)));
        target.setDescription(source.getDescription().copy());
        target.setParent(source.getParent());
        target.getLinksHolder().getValue().getLinks().addAll(this.cloneExternalLinkList(source));
    }

    private void cloneTextElementBasicInfo(HasText source, HasText target) {
        String uniqueNodeName = this.composeUniqueNodeName(source.getText().getValue());
        target.setText(new Text(uniqueNodeName));
    }

    protected String composeUniqueNodeName(String name) {
        String originalName = Optional.ofNullable(name).orElse("");
        MatchResult nameSuffixMatcher = NAME_SUFFIX_REGEX.exec(originalName);
        if (nameSuffixMatcher != null) {
            return this.buildNameWithIncrementedSuffixIndex(originalName, nameSuffixMatcher);
        }
        return this.joinPrefixWithIndexedSuffix(originalName);
    }

    private String buildNameWithIncrementedSuffixIndex(String nameValue, MatchResult matchResult) {
        String suffix = matchResult.getGroup(0);
        String prefix = Optional.ofNullable(nameValue.split(suffix)[0]).orElse("");
        return this.joinPrefixWithIndexedSuffix(prefix);
    }

    private String joinPrefixWithIndexedSuffix(String originalName) {
        String originalNameWithHyphen = originalName + HYPHEN;
        return originalNameWithHyphen + this.getMaxUnusedIndexByNamePrefix(originalNameWithHyphen);
    }

    private int getMaxUnusedIndexByNamePrefix(String namePrefix) {
        List<String> nodeNameList = StreamSupport.stream(this.getGraphNodes().spliterator(), true).map(this::nodeNamesMapper).filter(Objects::nonNull).collect(Collectors.toList());
        return DefaultValueUtilities.getMaxUnusedIndex(nodeNameList, namePrefix);
    }

    private Iterable<Node<View, Edge>> getGraphNodes() {
        return this.sessionManager.getCurrentSession().getCanvasHandler().getDiagram().getGraph().nodes();
    }

    private String nodeNamesMapper(Node<View, Edge> node) {
        if (((View)node.getContent()).getDefinition() instanceof NamedElement) {
            NamedElement namedElement = (NamedElement)((View)node.getContent()).getDefinition();
            return namedElement.getName().getValue();
        }
        if (((View)node.getContent()).getDefinition() instanceof HasText) {
            HasText textWrapper = (HasText)((View)node.getContent()).getDefinition();
            return textWrapper.getText().getValue();
        }
        return null;
    }

    private void cloneTypeRefInfo(IsInformationItem srcInformationItem, IsInformationItem targetInformationItem) {
        if (srcInformationItem instanceof InformationItemPrimary) {
            InformationItemPrimary srcInformationItemPrimary = (InformationItemPrimary)srcInformationItem;
            InformationItemPrimary targetInformationItemPrimary = (InformationItemPrimary)targetInformationItem;
            targetInformationItemPrimary.setTypeRefHolder(srcInformationItemPrimary.getTypeRefHolder().copy());
            targetInformationItemPrimary.setTypeRef(srcInformationItemPrimary.getTypeRefHolder().getValue().copy());
        }
    }

    private List<DMNExternalLink> cloneExternalLinkList(DRGElement sourceDefinition) {
        return sourceDefinition.getLinksHolder().getValue().getLinks().stream().map(srcLink -> new DMNExternalLink(srcLink.getUrl(), srcLink.getDescription())).collect(Collectors.toList());
    }

    private void cloneDecision(Decision source, Decision target) {
        target.setQuestion(source.getQuestion().copy());
        target.setAllowedAnswers(source.getAllowedAnswers().copy());
        target.setExpression((Expression)Optional.ofNullable(source.getExpression()).map(Expression::copy).orElse(null));
    }

    private void cloneBusinessKnowledgeModel(BusinessKnowledgeModel source, BusinessKnowledgeModel target) {
        target.setEncapsulatedLogic(source.getEncapsulatedLogic().copy());
    }
}

