/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.commands.factory.graph;

import java.util.Optional;
import org.kie.workbench.common.dmn.client.commands.util.ContentDefinitionIdUtils;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.diagram.GraphsProvider;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.impl.SetConnectionSourceNodeCommand;
import org.kie.workbench.common.stunner.core.graph.content.view.Connection;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;

public class DMNSetConnectionSourceNodeCommand
extends SetConnectionSourceNodeCommand {
    private final GraphsProvider graphsProvider;
    private final Optional<String> diagramId;

    public DMNSetConnectionSourceNodeCommand(Node<? extends View<?>, Edge> sourceNode, Edge<? extends View, Node> edge, Connection connection, GraphsProvider graphsProvider) {
        super(sourceNode, edge, connection);
        this.graphsProvider = graphsProvider;
        this.diagramId = ContentDefinitionIdUtils.getDiagramId(edge);
    }

    public Node<? extends View<?>, Edge> getSourceNode(GraphCommandExecutionContext context) {
        if (this.commandBelongsToAnotherGraph()) {
            return this.getEdgesGraph().getNode(this.getSourceNodeUUID());
        }
        return this.superGetSourceNode(context);
    }

    Node<? extends View<?>, Edge> superGetSourceNode(GraphCommandExecutionContext context) {
        return super.getSourceNode(context);
    }

    public CommandResult<RuleViolation> undo(GraphCommandExecutionContext context) {
        DMNSetConnectionSourceNodeCommand undoCommand = new DMNSetConnectionSourceNodeCommand(this.getNode(context, this.getLastSourceNodeUUID()), (Edge<? extends View, Node>)this.getEdge(context), this.getLastConnection(), this.graphsProvider);
        return undoCommand.execute(context);
    }

    public Optional<String> getDiagramId() {
        return this.diagramId;
    }

    protected Node<?, Edge> getNode(GraphCommandExecutionContext context, String uuid) {
        if (this.commandBelongsToAnotherGraph()) {
            return this.getEdgesGraph().getNode(uuid);
        }
        return this.superGetNode(context, uuid);
    }

    Node<?, Edge> superGetNode(GraphCommandExecutionContext context, String uuid) {
        return super.getNode(context, uuid);
    }

    boolean commandBelongsToAnotherGraph() {
        return this.getDiagramId().isPresent() && !ContentDefinitionIdUtils.isTheCurrentDiagram(this.getDiagramId(), this.getGraphsProvider());
    }

    Graph getEdgesGraph() {
        Optional<String> id = this.getDiagramId();
        if (id.isPresent()) {
            return this.getGraphsProvider().getDiagram(id.get()).getGraph();
        }
        throw new IllegalStateException("Unable to get the edges graph. The diagramId is not set.");
    }

    public GraphsProvider getGraphsProvider() {
        return this.graphsProvider;
    }
}

