/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.commands.general;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Style;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.Objects;
import java.util.Optional;
import javax.enterprise.event.Event;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.ui.ElementWrapperWidget;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.HasName;
import org.kie.workbench.common.dmn.client.commands.general.NavigateToDRGEditorCommand;
import org.kie.workbench.common.dmn.client.commands.general.NavigateToExpressionEditorCommand;
import org.kie.workbench.common.dmn.client.commands.general.NoOperationGraphCommand;
import org.kie.workbench.common.dmn.client.editors.expressions.ExpressionEditorView;
import org.kie.workbench.common.stunner.client.lienzo.canvas.LienzoCanvas;
import org.kie.workbench.common.stunner.client.widgets.presenters.session.SessionPresenter;
import org.kie.workbench.common.stunner.client.widgets.presenters.session.impl.AbstractSessionPresenter;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasGraphCommand;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.forms.client.event.RefreshFormPropertiesEvent;
import org.uberfire.client.workbench.widgets.listbar.ResizeFlowPanel;

public abstract class BaseNavigateCommand
extends AbstractCanvasGraphCommand {
    static final NoOperationGraphCommand NOP_GRAPH_COMMAND = new NoOperationGraphCommand();
    protected final ExpressionEditorView.Presenter editor;
    protected final SessionPresenter<? extends ClientSession, ?, Diagram> presenter;
    protected final SessionManager sessionManager;
    protected final SessionCommandManager<AbstractCanvasHandler> sessionCommandManager;
    protected final Event<RefreshFormPropertiesEvent> refreshFormPropertiesEvent;
    protected final String nodeUUID;
    protected final HasExpression hasExpression;
    protected final Optional<HasName> hasName;
    protected final boolean isOnlyVisualChangeAllowed;

    public BaseNavigateCommand(ExpressionEditorView.Presenter editor, SessionPresenter<? extends ClientSession, ?, Diagram> presenter, SessionManager sessionManager, SessionCommandManager<AbstractCanvasHandler> sessionCommandManager, Event<RefreshFormPropertiesEvent> refreshFormPropertiesEvent, String nodeUUID, HasExpression hasExpression, Optional<HasName> hasName, boolean isOnlyVisualChangeAllowed) {
        this.editor = editor;
        this.presenter = presenter;
        this.sessionManager = sessionManager;
        this.sessionCommandManager = sessionCommandManager;
        this.refreshFormPropertiesEvent = refreshFormPropertiesEvent;
        this.nodeUUID = nodeUUID;
        this.hasExpression = hasExpression;
        this.hasName = hasName;
        this.isOnlyVisualChangeAllowed = isOnlyVisualChangeAllowed;
    }

    protected void navigateToExpressionEditor(HasExpression hasExpression, Optional<HasName> hasName) {
        this.sessionCommandManager.execute((Object)((AbstractCanvasHandler)this.sessionManager.getCurrentSession().getCanvasHandler()), (Command)new NavigateToExpressionEditorCommand(this.editor, this.presenter, this.sessionManager, this.sessionCommandManager, this.refreshFormPropertiesEvent, this.nodeUUID, hasExpression, hasName, this.isOnlyVisualChangeAllowed));
    }

    protected void navigateToDRGEditor(HasExpression hasExpression, Optional<HasName> hasName) {
        this.sessionCommandManager.execute((Object)((AbstractCanvasHandler)this.sessionManager.getCurrentSession().getCanvasHandler()), (Command)new NavigateToDRGEditorCommand(this.editor, this.presenter, this.sessionManager, this.sessionCommandManager, this.refreshFormPropertiesEvent, this.nodeUUID, hasExpression, hasName, this.isOnlyVisualChangeAllowed));
    }

    protected void enableHandlers(boolean enabled) {
        CanvasHandler handler = this.getCanvasHandler();
        if (handler == null) {
            return;
        }
        LienzoCanvas canvas = (LienzoCanvas)handler.getCanvas();
        if (enabled) {
            canvas.enableHandlers();
        } else {
            canvas.disableHandlers();
        }
    }

    protected void addExpressionEditorToCanvasWidget() {
        ResizeFlowPanel container = this.wrapElementForErrai1090();
        ((SessionPresenter.View)this.presenter.getView()).setCanvasWidget((IsWidget)container);
        this.presenter.lostFocus();
        this.editor.getView().setFocus();
        Scheduler.get().scheduleDeferred(() -> ((ResizeFlowPanel)container).onResize());
    }

    protected ResizeFlowPanel wrapElementForErrai1090() {
        ElementWrapperWidget w = ElementWrapperWidget.getWidget((HTMLElement)this.editor.getElement());
        ResizeFlowPanel container = new ResizeFlowPanel(){

            public void onResize() {
                super.onResize();
                BaseNavigateCommand.this.editor.getView().onResize();
            }
        };
        container.getElement().setId("dmn-expression-editor-container");
        container.getElement().getStyle().setDisplay(Style.Display.FLEX);
        container.getElement().getStyle().setWidth(100.0, Style.Unit.PCT);
        container.getElement().getStyle().setHeight(100.0, Style.Unit.PCT);
        container.add((Widget)w);
        return container;
    }

    protected void addDRGEditorToCanvasWidget() {
        ((SessionPresenter.View)this.presenter.getView()).setCanvasWidget(((AbstractSessionPresenter)this.presenter).getDisplayer().getView());
        this.presenter.focus();
    }

    protected void hidePaletteWidget(boolean hidden) {
        if (!Objects.isNull(this.presenter.getPalette())) {
            this.presenter.getPalette().setVisible(!hidden);
        }
    }

    private CanvasHandler getCanvasHandler() {
        return null != this.sessionManager.getCurrentSession() ? this.sessionManager.getCurrentSession().getCanvasHandler() : null;
    }
}

