/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.commands.general;

import java.util.Objects;
import java.util.Optional;
import org.kie.workbench.common.dmn.api.definition.HasValue;
import org.kie.workbench.common.dmn.client.commands.VetoExecutionCommand;
import org.kie.workbench.common.dmn.client.commands.VetoUndoCommand;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasGraphCommand;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandResultBuilder;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandResultBuilder;
import org.kie.workbench.common.stunner.core.graph.command.impl.AbstractGraphCommand;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;
import org.uberfire.mvp.Command;

public class SetHasValueCommand<V, HV extends HasValue<V>>
extends AbstractCanvasGraphCommand
implements VetoExecutionCommand,
VetoUndoCommand {
    private final HV hasValue;
    private final V value;
    private final Command canvasOperation;
    private final Optional<V> oldValue;

    public SetHasValueCommand(HV hasValue, V value, Command canvasOperation) {
        this.hasValue = (HasValue)Objects.requireNonNull(hasValue);
        this.value = Objects.requireNonNull(value);
        this.canvasOperation = Objects.requireNonNull(canvasOperation);
        this.oldValue = Optional.ofNullable(hasValue.getValue());
    }

    protected org.kie.workbench.common.stunner.core.command.Command<GraphCommandExecutionContext, RuleViolation> newGraphCommand(AbstractCanvasHandler handler) {
        return new AbstractGraphCommand(){

            protected CommandResult<RuleViolation> check(GraphCommandExecutionContext gce) {
                return GraphCommandResultBuilder.SUCCESS;
            }

            public CommandResult<RuleViolation> execute(GraphCommandExecutionContext gce) {
                SetHasValueCommand.this.hasValue.setValue(SetHasValueCommand.this.value);
                return GraphCommandResultBuilder.SUCCESS;
            }

            public CommandResult<RuleViolation> undo(GraphCommandExecutionContext gce) {
                SetHasValueCommand.this.hasValue.setValue(SetHasValueCommand.this.oldValue.orElse(null));
                return GraphCommandResultBuilder.SUCCESS;
            }
        };
    }

    protected org.kie.workbench.common.stunner.core.command.Command<AbstractCanvasHandler, CanvasViolation> newCanvasCommand(AbstractCanvasHandler handler) {
        return new AbstractCanvasCommand(){

            public CommandResult<CanvasViolation> execute(AbstractCanvasHandler handler) {
                SetHasValueCommand.this.canvasOperation.execute();
                return CanvasCommandResultBuilder.SUCCESS;
            }

            public CommandResult<CanvasViolation> undo(AbstractCanvasHandler handler) {
                SetHasValueCommand.this.canvasOperation.execute();
                return CanvasCommandResultBuilder.SUCCESS;
            }
        };
    }
}

