/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.docks.navigator;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.dmn.client.docks.navigator.DecisionNavigatorPresenter;
import org.kie.workbench.common.stunner.kogito.api.docks.DiagramEditorDock;
import org.uberfire.client.workbench.docks.UberfireDock;
import org.uberfire.client.workbench.docks.UberfireDockPosition;
import org.uberfire.client.workbench.docks.UberfireDocks;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;

@ApplicationScoped
public class DecisionNavigatorDock
implements DiagramEditorDock {
    protected static final double DOCK_SIZE = 400.0;
    protected UberfireDocks uberfireDocks;
    protected DecisionNavigatorPresenter decisionNavigatorPresenter;
    protected TranslationService translationService;
    protected UberfireDock uberfireDock;
    protected boolean isOpened = false;
    protected String perspective;

    public DecisionNavigatorDock() {
    }

    @Inject
    public DecisionNavigatorDock(UberfireDocks uberfireDocks, DecisionNavigatorPresenter decisionNavigatorPresenter, TranslationService translationService) {
        this.uberfireDocks = uberfireDocks;
        this.decisionNavigatorPresenter = decisionNavigatorPresenter;
        this.translationService = translationService;
    }

    public void init(String perspective) {
        this.perspective = perspective;
        this.uberfireDock = this.makeUberfireDock();
    }

    public void destroy() {
        this.uberfireDocks.remove(new UberfireDock[]{this.getUberfireDock()});
    }

    public void reload() {
        this.decisionNavigatorPresenter.refresh();
    }

    public void resetContent() {
        this.decisionNavigatorPresenter.removeAllElements();
    }

    public void open() {
        if (this.isOpened()) {
            return;
        }
        this.isOpened = true;
        this.uberfireDocks.add(new UberfireDock[]{this.getUberfireDock()});
        this.uberfireDocks.show(this.position(), this.perspective());
        this.uberfireDocks.open(this.getUberfireDock());
    }

    public void close() {
        if (!this.isOpened()) {
            return;
        }
        this.isOpened = false;
        this.uberfireDocks.close(this.getUberfireDock());
        this.destroy();
    }

    protected boolean isOpened() {
        return this.isOpened;
    }

    protected void setOpened(boolean opened) {
        this.isOpened = opened;
    }

    protected UberfireDock makeUberfireDock() {
        UberfireDock uberfireDock = new UberfireDock(this.position(), this.icon(), (PlaceRequest)this.placeRequest(), this.perspective());
        return uberfireDock.withSize(400.0).withLabel(this.dockLabel());
    }

    protected String perspective() {
        return this.perspective;
    }

    protected UberfireDock getUberfireDock() {
        return this.uberfireDock;
    }

    protected UberfireDockPosition position() {
        return UberfireDockPosition.WEST;
    }

    protected String icon() {
        return IconType.MAP.toString();
    }

    protected String dockLabel() {
        return this.translationService.format("DecisionNavigatorPresenter.DecisionNavigator", new Object[0]);
    }

    protected DefaultPlaceRequest placeRequest() {
        return new DefaultPlaceRequest("org.kie.dmn.decision.navigator");
    }
}

