/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.docks.navigator;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.kie.workbench.common.dmn.api.definition.model.DRGElement;
import org.kie.workbench.common.dmn.api.definition.model.TextAnnotation;
import org.kie.workbench.common.dmn.api.graph.DMNDiagramUtils;
import org.kie.workbench.common.dmn.client.docks.navigator.DecisionNavigatorItem;
import org.kie.workbench.common.dmn.client.docks.navigator.drds.DMNDiagramTuple;
import org.kie.workbench.common.dmn.client.docks.navigator.drds.DMNDiagramsSession;
import org.kie.workbench.common.dmn.client.docks.navigator.factories.DecisionNavigatorItemFactory;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.graph.content.view.View;

@ApplicationScoped
public class DecisionNavigatorItemsProvider {
    static final String DRG = "DRG";
    static final String DRDs = "DRDs";
    private final DecisionNavigatorItemFactory itemFactory;
    private final DMNDiagramsSession dmnDiagramsSession;
    private final DMNDiagramUtils dmnDiagramUtils;

    @Inject
    public DecisionNavigatorItemsProvider(DecisionNavigatorItemFactory itemFactory, DMNDiagramsSession dmnDiagramsSession, DMNDiagramUtils dmnDiagramUtils) {
        this.itemFactory = itemFactory;
        this.dmnDiagramsSession = dmnDiagramsSession;
        this.dmnDiagramUtils = dmnDiagramUtils;
    }

    public List<DecisionNavigatorItem> getItems() {
        ArrayList<DecisionNavigatorItem> items = new ArrayList<DecisionNavigatorItem>();
        this.dmnDiagramsSession.getDMNDiagrams().stream().sorted((e1, e2) -> {
            String dmnElementName1 = e1.getDMNDiagram().getName().getValue();
            String dmnElementName2 = e2.getDMNDiagram().getName().getValue();
            return DRG.equals(dmnElementName1) ? -1 : (DRG.equals(dmnElementName2) ? 1 : 0);
        }).forEach(diagramTuple -> {
            Diagram stunner = diagramTuple.getStunnerDiagram();
            DecisionNavigatorItem root = this.makeRoot((DMNDiagramTuple)diagramTuple);
            items.add(root);
            this.getNodes(stunner).forEach(node -> this.makeItem(root, (Node)node));
        });
        if (items.size() > 1) {
            items.add(0, this.itemFactory.makeSeparator(DRG));
            items.add(2, this.itemFactory.makeSeparator(DRDs));
        }
        return items;
    }

    private List<Node> getNodes(Diagram stunner) {
        return this.dmnDiagramUtils.getNodeStream(stunner).filter(this::allowedNode).collect(Collectors.toList());
    }

    private boolean allowedNode(Node node) {
        Object content = node.getContent();
        if (!(content instanceof Definition)) {
            return false;
        }
        Object definition = ((Definition)content).getDefinition();
        return definition instanceof DRGElement || definition instanceof TextAnnotation;
    }

    private void makeItem(DecisionNavigatorItem root, Node node) {
        DecisionNavigatorItem item = this.itemFactory.makeItem((Node<View, Edge>)node);
        root.addChild(item);
    }

    private DecisionNavigatorItem makeRoot(DMNDiagramTuple diagramTuple) {
        return this.itemFactory.makeRoot(diagramTuple);
    }
}

