/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.docks.navigator;

import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.model.Expression;
import org.kie.workbench.common.dmn.client.docks.navigator.DecisionNavigatorItem;
import org.kie.workbench.common.dmn.client.docks.navigator.DecisionNavigatorPresenter;
import org.kie.workbench.common.dmn.client.docks.navigator.drds.DMNDiagramSelected;
import org.kie.workbench.common.dmn.client.docks.navigator.tree.DecisionNavigatorTreePresenter;
import org.kie.workbench.common.dmn.client.events.EditExpressionEvent;
import org.kie.workbench.common.dmn.client.widgets.grid.model.ExpressionEditorChanged;
import org.kie.workbench.common.stunner.core.client.canvas.event.CanvasClearEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.registration.CanvasElementAddedEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.registration.CanvasElementRemovedEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.registration.CanvasElementUpdatedEvent;

@ApplicationScoped
public class DecisionNavigatorObserver {
    private DecisionNavigatorPresenter presenter;

    public void init(DecisionNavigatorPresenter presenter) {
        this.presenter = presenter;
    }

    void onCanvasClear(@Observes CanvasClearEvent event) {
        this.getOptionalPresenter().ifPresent(DecisionNavigatorPresenter::refresh);
    }

    void onCanvasElementAdded(@Observes CanvasElementAddedEvent event) {
        this.getOptionalPresenter().ifPresent(DecisionNavigatorPresenter::refresh);
    }

    void onCanvasElementUpdated(@Observes CanvasElementUpdatedEvent event) {
        this.getOptionalPresenter().ifPresent(DecisionNavigatorPresenter::refresh);
    }

    void onCanvasElementRemoved(@Observes CanvasElementRemovedEvent event) {
        this.getOptionalPresenter().ifPresent(DecisionNavigatorPresenter::refresh);
    }

    void onNestedElementSelected(@Observes EditExpressionEvent event) {
        this.getOptionalPresenter().ifPresent(DecisionNavigatorPresenter::refresh);
    }

    void onNestedElementAdded(@Observes ExpressionEditorChanged event) {
        this.getOptionalPresenter().ifPresent(DecisionNavigatorPresenter::refresh);
    }

    void onDMNDiagramSelected(@Observes DMNDiagramSelected event) {
        this.getOptionalPresenter().ifPresent(DecisionNavigatorPresenter::refresh);
    }

    void selectItem(HasExpression hasExpression) {
        Optional<Expression> optionalExpression = Optional.ofNullable(hasExpression.getExpression());
        optionalExpression.ifPresent(expression -> {
            String value = expression.getId().getValue();
            this.getTreePresenter().selectItem(value);
        });
    }

    Optional<DecisionNavigatorItem> getActiveParent() {
        return Optional.ofNullable(this.getTreePresenter().getActiveParent());
    }

    void setActiveParent(EditExpressionEvent event) {
        this.getTreePresenter().setActiveParentUUID(event.getNodeUUID());
    }

    private DecisionNavigatorTreePresenter getTreePresenter() {
        return this.presenter.getTreePresenter();
    }

    private Optional<DecisionNavigatorPresenter> getOptionalPresenter() {
        return Optional.ofNullable(this.presenter);
    }
}

