/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.docks.navigator;

import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.ui.client.local.api.elemental2.IsElement;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.dmn.client.docks.navigator.DecisionNavigatorItem;
import org.kie.workbench.common.dmn.client.docks.navigator.DecisionNavigatorItemsProvider;
import org.kie.workbench.common.dmn.client.docks.navigator.DecisionNavigatorObserver;
import org.kie.workbench.common.dmn.client.docks.navigator.drds.DMNDiagramsSession;
import org.kie.workbench.common.dmn.client.docks.navigator.events.RefreshDecisionComponents;
import org.kie.workbench.common.dmn.client.docks.navigator.included.components.DecisionComponents;
import org.kie.workbench.common.dmn.client.docks.navigator.tree.DecisionNavigatorTreePresenter;
import org.kie.workbench.common.dmn.client.editors.included.common.IncludedModelsContext;
import org.kie.workbench.common.stunner.core.client.canvas.event.registration.CanvasElementAddedEvent;
import org.uberfire.client.annotations.DefaultPosition;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.UberElemental;
import org.uberfire.workbench.model.CompassPosition;
import org.uberfire.workbench.model.Position;

@ApplicationScoped
@WorkbenchScreen(identifier="org.kie.dmn.decision.navigator")
public class DecisionNavigatorPresenter {
    public static final String IDENTIFIER = "org.kie.dmn.decision.navigator";
    private View view;
    private DecisionNavigatorTreePresenter treePresenter;
    private DecisionComponents decisionComponents;
    private DecisionNavigatorObserver decisionNavigatorObserver;
    private TranslationService translationService;
    private IncludedModelsContext includedModelContext;
    private DecisionNavigatorItemsProvider navigatorItemsProvider;
    private DMNDiagramsSession dmnDiagramsSession;
    private boolean isRefreshHandlersEnabled = false;

    @Inject
    public DecisionNavigatorPresenter(View view, DecisionNavigatorTreePresenter treePresenter, DecisionComponents decisionComponents, DecisionNavigatorObserver decisionNavigatorObserver, TranslationService translationService, IncludedModelsContext includedModelContext, DecisionNavigatorItemsProvider navigatorItemsProvider, DMNDiagramsSession dmnDiagramsSession) {
        this.view = view;
        this.treePresenter = treePresenter;
        this.decisionComponents = decisionComponents;
        this.decisionNavigatorObserver = decisionNavigatorObserver;
        this.translationService = translationService;
        this.includedModelContext = includedModelContext;
        this.navigatorItemsProvider = navigatorItemsProvider;
        this.dmnDiagramsSession = dmnDiagramsSession;
    }

    @WorkbenchPartView
    public View getView() {
        return this.view;
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return this.translationService.format("DecisionNavigatorPresenter.DecisionNavigator", new Object[0]);
    }

    @DefaultPosition
    public Position getDefaultPosition() {
        return CompassPosition.WEST;
    }

    @PostConstruct
    void setup() {
        this.initialize();
        this.setupView();
        this.enableRefreshHandlers();
        this.refreshComponentsView();
    }

    public void onRefreshDecisionComponents(@Observes RefreshDecisionComponents events) {
        this.refreshComponentsView();
    }

    public void onElementAdded(@Observes CanvasElementAddedEvent event) {
        this.refreshComponentsView();
    }

    public DecisionNavigatorTreePresenter getTreePresenter() {
        return this.treePresenter;
    }

    public void removeAllElements() {
        this.treePresenter.removeAllItems();
        this.decisionComponents.removeAllItems();
    }

    void initialize() {
        this.view.init(this);
        this.decisionNavigatorObserver.init(this);
    }

    void setupView() {
        this.view.setupMainTree(this.treePresenter.getView());
        if (this.includedModelContext.isIncludedModelChannel()) {
            this.view.showDecisionComponentsContainer();
            this.view.setupDecisionComponents(this.decisionComponents.getView());
        } else {
            this.view.hideDecisionComponentsContainer();
        }
    }

    public void refresh() {
        if (this.dmnDiagramsSession.isSessionStatePresent()) {
            this.refreshTreeView();
            this.refreshComponentsView();
        }
    }

    public void refreshTreeView() {
        if (this.isRefreshHandlersEnabled()) {
            this.treePresenter.setupItems(this.getItems());
        }
    }

    void refreshComponentsView() {
        if (this.isRefreshHandlersEnabled()) {
            this.decisionComponents.refresh();
        }
    }

    public void enableRefreshHandlers() {
        this.isRefreshHandlersEnabled = true;
    }

    public void disableRefreshHandlers() {
        this.isRefreshHandlersEnabled = false;
    }

    private boolean isRefreshHandlersEnabled() {
        return this.isRefreshHandlersEnabled;
    }

    List<DecisionNavigatorItem> getItems() {
        return this.navigatorItemsProvider.getItems();
    }

    public void clearSelections() {
        this.getTreePresenter().deselectItem();
    }

    public static interface View
    extends UberElemental<DecisionNavigatorPresenter>,
    IsElement {
        public void setupMainTree(DecisionNavigatorTreePresenter.View var1);

        public void setupDecisionComponents(DecisionComponents.View var1);

        public void showDecisionComponentsContainer();

        public void hideDecisionComponentsContainer();
    }
}

