/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.docks.navigator.factories;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.dmn.client.docks.navigator.DecisionNavigatorItem;
import org.kie.workbench.common.dmn.client.docks.navigator.DecisionNavigatorItemBuilder;
import org.kie.workbench.common.dmn.client.docks.navigator.common.CanvasFocusUtils;
import org.kie.workbench.common.dmn.client.docks.navigator.common.LazyCanvasFocusUtils;
import org.kie.workbench.common.dmn.client.docks.navigator.drds.DMNDiagramSelected;
import org.kie.workbench.common.dmn.client.docks.navigator.drds.DMNDiagramsSession;
import org.kie.workbench.common.dmn.client.docks.navigator.factories.DecisionNavigatorNestedItemFactory;
import org.kie.workbench.common.stunner.core.client.canvas.controls.actions.TextPropertyProvider;
import org.kie.workbench.common.stunner.core.client.canvas.controls.actions.TextPropertyProviderFactory;
import org.kie.workbench.common.stunner.core.definition.adapter.AdapterManager;
import org.kie.workbench.common.stunner.core.definition.adapter.DefinitionAdapter;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.HasContentDefinitionId;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;
import org.uberfire.mvp.Command;

@Dependent
public class DecisionNavigatorBaseItemFactory {
    private final DecisionNavigatorNestedItemFactory nestedItemFactory;
    private final TextPropertyProviderFactory textPropertyProviderFactory;
    private final CanvasFocusUtils canvasFocusUtils;
    private final DefinitionUtils definitionUtils;
    private final TranslationService translationService;
    private final DMNDiagramsSession dmnDiagramsSession;
    private final LazyCanvasFocusUtils lazyCanvasFocusUtils;
    private final Event<DMNDiagramSelected> selectedEvent;

    @Inject
    public DecisionNavigatorBaseItemFactory(DecisionNavigatorNestedItemFactory nestedItemFactory, TextPropertyProviderFactory textPropertyProviderFactory, CanvasFocusUtils canvasFocusUtils, DefinitionUtils definitionUtils, TranslationService translationService, DMNDiagramsSession dmnDiagramsSession, LazyCanvasFocusUtils lazyCanvasFocusUtils, Event<DMNDiagramSelected> selectedEvent) {
        this.nestedItemFactory = nestedItemFactory;
        this.textPropertyProviderFactory = textPropertyProviderFactory;
        this.canvasFocusUtils = canvasFocusUtils;
        this.definitionUtils = definitionUtils;
        this.translationService = translationService;
        this.dmnDiagramsSession = dmnDiagramsSession;
        this.lazyCanvasFocusUtils = lazyCanvasFocusUtils;
        this.selectedEvent = selectedEvent;
    }

    public DecisionNavigatorItem makeItem(Node<View, Edge> node, DecisionNavigatorItem.Type type) {
        String uuid = node.getUUID();
        String label = this.getLabel((Element<View>)node);
        Command onClick = this.makeOnClickCommand(node);
        List<DecisionNavigatorItem> nestedItems = this.makeNestedItems(node);
        DecisionNavigatorItem item = this.navigatorItemBuilder().withUUID(uuid).withLabel(label).withType(type).withOnClick(onClick).build();
        nestedItems.forEach(item::addChild);
        return item;
    }

    Command makeOnClickCommand(Node<View, Edge> node) {
        return () -> {
            String nodeDiagramId = this.getDiagramId(node);
            String nodeUUID = node.getUUID();
            if (this.isCurrentDiagram(nodeDiagramId).booleanValue()) {
                this.canvasFocusUtils.focus(nodeUUID);
            } else {
                this.lazyCanvasFocusUtils.lazyFocus(nodeUUID);
                this.selectedEvent.fire((Object)new DMNDiagramSelected(this.dmnDiagramsSession.getDMNDiagramElement(nodeDiagramId)));
            }
        };
    }

    private Boolean isCurrentDiagram(String nodeDiagramId) {
        return this.dmnDiagramsSession.getCurrentDMNDiagramElement().map(dmnDiagramElement -> {
            String diagramId = dmnDiagramElement.getId().getValue();
            return Objects.equals(diagramId, nodeDiagramId);
        }).orElse(false);
    }

    private String getDiagramId(Node<View, Edge> node) {
        View content = (View)node.getContent();
        Object definition = content.getDefinition();
        if (definition instanceof HasContentDefinitionId) {
            return ((HasContentDefinitionId)definition).getDiagramId();
        }
        return "";
    }

    String getLabel(Element<View> element) {
        String name = this.getName(element);
        String title = this.getTitle(element);
        if (this.isNil(name) && !this.isNil(title)) {
            return title;
        }
        return name != null ? name : this.getDefaultName();
    }

    String getName(Element<? extends Definition> element) {
        TextPropertyProvider provider = this.textPropertyProviderFactory.getProvider(element);
        return provider.getText(element);
    }

    String getTitle(Element<View> element) {
        AdapterManager adapters = this.definitionUtils.getDefinitionManager().adapters();
        DefinitionAdapter objectDefinitionAdapter = adapters.forDefinition();
        return objectDefinitionAdapter.getTitle(DefinitionUtils.getElementDefinition(element));
    }

    List<DecisionNavigatorItem> makeNestedItems(Node<View, Edge> node) {
        ArrayList<DecisionNavigatorItem> nestedItems = new ArrayList<DecisionNavigatorItem>();
        if (this.hasNestedElement(node)) {
            nestedItems.add(this.nestedItemFactory.makeItem(node));
        }
        return nestedItems;
    }

    private String getDefaultName() {
        return this.translationService.format("DecisionNavigatorBaseItemFactory.NoName", new Object[0]);
    }

    private boolean hasNestedElement(Node<View, Edge> node) {
        return this.nestedItemFactory.hasNestedElement(node);
    }

    private boolean isNil(String s) {
        return s == null || s.trim().isEmpty();
    }

    private DecisionNavigatorItemBuilder navigatorItemBuilder() {
        return new DecisionNavigatorItemBuilder();
    }
}

