/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.docks.navigator.included.components;

import elemental2.dom.HTMLElement;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.ui.client.local.api.elemental2.IsElement;
import org.kie.workbench.common.dmn.api.definition.model.DRGElement;
import org.kie.workbench.common.dmn.api.definition.model.Import;
import org.kie.workbench.common.dmn.api.editors.included.DMNImportTypes;
import org.kie.workbench.common.dmn.api.editors.included.DMNIncludedModel;
import org.kie.workbench.common.dmn.api.editors.included.DMNIncludedNode;
import org.kie.workbench.common.dmn.client.api.included.legacy.DMNIncludeModelsClient;
import org.kie.workbench.common.dmn.client.docks.navigator.drds.DMNDiagramsSession;
import org.kie.workbench.common.dmn.client.docks.navigator.included.components.DecisionComponent;
import org.kie.workbench.common.dmn.client.docks.navigator.included.components.DecisionComponentFilter;
import org.kie.workbench.common.dmn.client.docks.navigator.included.components.DecisionComponentsItem;
import org.kie.workbench.common.dmn.client.graph.DMNGraphUtils;
import org.kie.workbench.common.stunner.core.util.FileUtils;
import org.uberfire.client.mvp.UberElemental;

@Dependent
public class DecisionComponents {
    private final View view;
    private final DMNIncludeModelsClient client;
    private final ManagedInstance<DecisionComponentsItem> itemManagedInstance;
    private final DecisionComponentFilter filter;
    private final DMNDiagramsSession dmnDiagramsSession;
    private final DMNGraphUtils dmnGraphUtils;
    private final List<DecisionComponentsItem> decisionComponentsItems = new ArrayList<DecisionComponentsItem>();
    private final List<DMNIncludedModel> latestIncludedModelsLoaded = new ArrayList<DMNIncludedModel>();
    private final List<DecisionComponent> includedDRGElements = new ArrayList<DecisionComponent>();
    private final List<DecisionComponent> modelDRGElements = new ArrayList<DecisionComponent>();

    public DecisionComponents() {
        this(null, null, null, null, null, null);
    }

    @Inject
    public DecisionComponents(View view, DMNIncludeModelsClient client, ManagedInstance<DecisionComponentsItem> itemManagedInstance, DecisionComponentFilter filter, DMNDiagramsSession dmnDiagramsSession, DMNGraphUtils dmnGraphUtils) {
        this.view = view;
        this.client = client;
        this.itemManagedInstance = itemManagedInstance;
        this.filter = filter;
        this.dmnDiagramsSession = dmnDiagramsSession;
        this.dmnGraphUtils = dmnGraphUtils;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
    }

    public View getView() {
        return this.view;
    }

    public void refresh() {
        if (!this.dmnDiagramsSession.isSessionStatePresent()) {
            return;
        }
        if (!this.isIncludedNodeListsUpdated()) {
            this.refreshIncludedNodesList();
        }
        this.loadModelComponents();
    }

    private boolean isIncludedNodeListsUpdated() {
        List<String> currentIncludedNamespaces = this.getNamespaces(this.getDMNIncludedModels());
        List<String> latestLoadedNamespaces = this.getNamespaces(this.getLatestIncludedModelsLoaded());
        return Objects.equals(currentIncludedNamespaces, latestLoadedNamespaces);
    }

    void refreshIncludedNodesList() {
        List<DMNIncludedModel> dmnIncludedModels = this.getDMNIncludedModels();
        this.startLoading();
        this.getLatestIncludedModelsLoaded().clear();
        this.getLatestIncludedModelsLoaded().addAll(dmnIncludedModels);
        this.client.loadNodesFromImports(dmnIncludedModels, this.getNodesConsumer());
    }

    void loadModelComponents() {
        String dmnModelName = this.dmnGraphUtils.getModelDefinitions().getName().getValue();
        List<DRGElement> dmnModelDRGElements = this.dmnDiagramsSession.getModelDRGElements();
        this.getModelDRGElements().clear();
        dmnModelDRGElements.forEach(drgElement -> this.getModelDRGElements().add(this.makeDecisionComponent(dmnModelName, (DRGElement)drgElement)));
        this.refreshView();
    }

    void refreshView() {
        this.clearDecisionComponents();
        this.createDecisionComponentItems(this.getIncludedDRGElements());
        this.createDecisionComponentItems(this.getModelDRGElements());
        this.setComponentsCounter(this.getDecisionComponentsItems().size());
        if (this.getDecisionComponentsItems().isEmpty()) {
            this.view.disableFilterInputs();
            this.view.showEmptyState();
        } else {
            this.view.enableFilterInputs();
        }
    }

    private void setComponentsCounter(int numberOfDecisionComponents) {
        this.view.setComponentsCounter(numberOfDecisionComponents);
    }

    void createDecisionComponentItems(List<DecisionComponent> decisionComponents) {
        for (DecisionComponent component : decisionComponents) {
            if (this.isDRGElementAdded(component)) continue;
            this.createDecisionComponentItem(component);
        }
    }

    private boolean isDRGElementAdded(DecisionComponent decisionComponent) {
        return this.getDecisionComponentsItems().stream().anyMatch(item -> {
            String decisionComponentItemId = item.getDecisionComponent().getDrgElement().getId().getValue();
            String decisionComponentId = decisionComponent.getDrgElement().getId().getValue();
            return Objects.equals(decisionComponentItemId, decisionComponentId);
        });
    }

    void createDecisionComponentItem(DecisionComponent component) {
        DecisionComponentsItem item = (DecisionComponentsItem)this.itemManagedInstance.get();
        item.setDecisionComponent(component);
        this.getDecisionComponentsItems().add(item);
        this.view.addListItem(item.getView().getElement());
    }

    Consumer<List<DMNIncludedNode>> getNodesConsumer() {
        return nodes -> {
            this.view.hideLoading();
            if (nodes != null) {
                this.getIncludedDRGElements().clear();
                nodes.forEach(node -> this.getIncludedDRGElements().add(this.makeDecisionComponent((DMNIncludedNode)node)));
                this.refreshView();
            }
        };
    }

    void startLoading() {
        this.view.showLoading();
        this.view.disableFilterInputs();
    }

    void clearDecisionComponents() {
        this.getDecisionComponentsItems().clear();
        this.view.clear();
    }

    void applyFilter() {
        this.hideAllItems();
        this.showFilteredItems();
    }

    void applyTermFilter(String value) {
        this.getFilter().setTerm(value);
        this.applyFilter();
    }

    void applyDrgElementFilterFilter(String value) {
        this.getFilter().setDrgElement(value);
        this.applyFilter();
    }

    private void showFilteredItems() {
        this.getFilter().query(this.getDecisionComponentsItems().stream()).sorted(Comparator.comparing(item -> item.getDecisionComponent().getName())).forEach(DecisionComponentsItem::show);
    }

    private void hideAllItems() {
        this.getDecisionComponentsItems().forEach(DecisionComponentsItem::hide);
    }

    DecisionComponent makeDecisionComponent(DMNIncludedNode node) {
        return new DecisionComponent(node.getFileName(), node.getDrgElement(), true);
    }

    DecisionComponent makeDecisionComponent(String id, DRGElement drgElement) {
        return new DecisionComponent(id, drgElement, false);
    }

    List<DMNIncludedModel> getDMNIncludedModels() {
        return this.dmnDiagramsSession.getModelImports().stream().filter(anImport -> Objects.equals(DMNImportTypes.DMN, DMNImportTypes.determineImportType((String)anImport.getImportType()))).map(this::asDMNIncludedModel).collect(Collectors.toList());
    }

    DMNIncludedModel asDMNIncludedModel(Import anImport) {
        String modelName = anImport.getName().getValue();
        String namespace = anImport.getNamespace();
        String importType = anImport.getImportType();
        String path = FileUtils.getFileName((String)anImport.getLocationURI().getValue());
        return new DMNIncludedModel(modelName, "", path, namespace, importType, Integer.valueOf(0), Integer.valueOf(0));
    }

    DecisionComponentFilter getFilter() {
        return this.filter;
    }

    public void removeAllItems() {
        this.clearDecisionComponents();
    }

    List<DecisionComponentsItem> getDecisionComponentsItems() {
        return this.decisionComponentsItems;
    }

    List<DecisionComponent> getModelDRGElements() {
        return this.modelDRGElements;
    }

    List<DecisionComponent> getIncludedDRGElements() {
        return this.includedDRGElements;
    }

    List<DMNIncludedModel> getLatestIncludedModelsLoaded() {
        return this.latestIncludedModelsLoaded;
    }

    private List<String> getNamespaces(List<DMNIncludedModel> dmnIncludedModels) {
        return dmnIncludedModels.stream().map(DMNIncludedModel::getNamespace).collect(Collectors.toList());
    }

    public static interface View
    extends UberElemental<DecisionComponents>,
    IsElement {
        public void clear();

        public void addListItem(HTMLElement var1);

        public void showEmptyState();

        public void showLoading();

        public void hideLoading();

        public void disableFilterInputs();

        public void enableFilterInputs();

        public void setComponentsCounter(Integer var1);
    }
}

