/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.contextmenu;

import elemental2.dom.DomGlobal;
import elemental2.dom.Element;
import elemental2.dom.Event;
import elemental2.dom.EventListener;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.dmn.client.editors.contextmenu.ContextMenu;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.HasListSelectorControl;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.ListSelector;

@Templated
public class ContextMenuView
implements ContextMenu.View,
HasListSelectorControl {
    private ContextMenu presenter;
    @DataField(value="list-selector")
    private ListSelector listSelector;
    private final EventListener hideContextMenuHandler = event -> {
        if (!Arrays.asList(this.getEventPath(event)).contains(this.getElement())) {
            this.listSelector.hide();
        }
    };

    @Inject
    public ContextMenuView(ListSelector listSelector) {
        this.listSelector = listSelector;
    }

    public void init(ContextMenu presenter) {
        this.presenter = presenter;
    }

    @PreDestroy
    private void removeDOMEventListeners() {
        DomGlobal.document.removeEventListener("mousedown", this.hideContextMenuHandler, false);
        DomGlobal.document.removeEventListener("mousewheel", this.hideContextMenuHandler, false);
    }

    @Override
    public void show() {
        this.listSelector.bind(this, 0, 0);
        this.listSelector.show();
        DomGlobal.document.addEventListener("mousedown", this.hideContextMenuHandler, false);
        DomGlobal.document.addEventListener("mousewheel", this.hideContextMenuHandler, false);
    }

    @Override
    public void hide() {
        this.listSelector.hide();
        this.removeDOMEventListeners();
    }

    Element[] getEventPath(Event event) {
        return Optional.ofNullable(event.path).orElseGet(() -> (Element[])Stream.of(event.composedPath()).filter(Event.ComposedPathArrayUnionType::isElement).map(Event.ComposedPathArrayUnionType::asElement).toArray(Element[]::new));
    }

    @Override
    public List<HasListSelectorControl.ListSelectorItem> getItems(int uiRowIndex, int uiColumnIndex) {
        return this.presenter.getItems();
    }

    @Override
    public void onItemSelected(HasListSelectorControl.ListSelectorItem item) {
        ((HasListSelectorControl.ListSelectorTextItem)item).getCommand().execute();
        this.hide();
    }
}

