/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.documentation;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasEnabled;
import com.google.gwt.user.client.ui.HasValue;
import elemental2.dom.Element;
import elemental2.dom.HTMLAnchorElement;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLElement;
import elemental2.dom.Node;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.dmn.api.definition.model.DRGElement;
import org.kie.workbench.common.dmn.api.property.dmn.DMNExternalLink;
import org.kie.workbench.common.dmn.api.property.dmn.DocumentationLinks;
import org.kie.workbench.common.dmn.api.qualifiers.DMNEditor;
import org.kie.workbench.common.dmn.client.editors.common.RemoveHelper;
import org.kie.workbench.common.dmn.client.editors.documentation.DocumentationLinkItem;
import org.kie.workbench.common.dmn.client.editors.documentation.links.NameAndUrlPopoverView;
import org.kie.workbench.common.dmn.client.editors.types.common.HiddenHelper;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.container.CellEditorControlsView;
import org.kie.workbench.common.stunner.core.client.ReadOnlyProvider;
import org.uberfire.client.mvp.LockRequiredEvent;

@Dependent
@Templated
public class DocumentationLinksWidget
extends Composite
implements HasValue<DocumentationLinks>,
HasEnabled {
    @DataField(value="documentation-links-container")
    private final HTMLDivElement linksContainer;
    @DataField(value="none-container")
    private final HTMLDivElement noneContainer;
    @DataField(value="add-button")
    private final HTMLAnchorElement addButton;
    @DataField(value="add-link")
    private final HTMLElement addLink;
    @DataField(value="no-link")
    private final HTMLElement noLink;
    private final CellEditorControlsView cellEditor;
    private final ManagedInstance<DocumentationLinkItem> listItems;
    private final NameAndUrlPopoverView.Presenter nameAndUrlPopover;
    private final TranslationService translationService;
    private final Event<LockRequiredEvent> locker;
    private final ReadOnlyProvider readOnlyProvider;
    static final String READ_ONLY_CSS_CLASS = "read-only";
    private boolean enabled;
    private DocumentationLinks value;

    @Inject
    public DocumentationLinksWidget(ManagedInstance<DocumentationLinkItem> listItems, TranslationService translationService, HTMLDivElement linksContainer, HTMLDivElement noneContainer, HTMLAnchorElement addButton, NameAndUrlPopoverView.Presenter nameAndUrlPopover, CellEditorControlsView cellEditor, @Named(value="span") HTMLElement addLink, @Named(value="span") HTMLElement noLink, Event<LockRequiredEvent> locker, @DMNEditor ReadOnlyProvider readOnlyProvider) {
        this.listItems = listItems;
        this.linksContainer = linksContainer;
        this.noneContainer = noneContainer;
        this.addButton = addButton;
        this.nameAndUrlPopover = nameAndUrlPopover;
        this.cellEditor = cellEditor;
        this.addLink = addLink;
        this.noLink = noLink;
        this.value = new DocumentationLinks();
        this.enabled = true;
        this.translationService = translationService;
        this.locker = locker;
        this.readOnlyProvider = readOnlyProvider;
    }

    @PostConstruct
    public void init() {
        this.nameAndUrlPopover.setOnExternalLinkCreated(this::onDMNExternalLinkCreated);
        this.addLink.textContent = this.translationService.getTranslation("DMNDocumentationI18n.Add");
        this.noLink.textContent = this.translationService.getTranslation("DMNDocumentationI18n.None");
        this.setupAddButtonReadOnlyStatus();
    }

    void setupAddButtonReadOnlyStatus() {
        if (this.readOnlyProvider.isReadOnlyDiagram()) {
            this.addButton.classList.add(new String[]{READ_ONLY_CSS_CLASS});
        } else {
            this.addButton.classList.remove(new String[]{READ_ONLY_CSS_CLASS});
        }
    }

    void onDMNExternalLinkCreated(DMNExternalLink externalLink) {
        this.locker.fire((Object)new LockRequiredEvent());
        this.getValue().addLink(externalLink);
        this.refresh();
    }

    public DocumentationLinks getValue() {
        return this.value;
    }

    public void setValue(DocumentationLinks documentationLinks) {
        this.setValue(documentationLinks, false);
    }

    public void setValue(DocumentationLinks documentationLinks, boolean fireEvents) {
        this.value = documentationLinks;
    }

    @EventHandler(value={"add-button"})
    public void onClickTypeButton(ClickEvent clickEvent) {
        this.cellEditor.show(this.nameAndUrlPopover, clickEvent.getClientX(), clickEvent.getClientY());
    }

    public HandlerRegistration addValueChangeHandler(ValueChangeHandler<DocumentationLinks> handler) {
        return this.addHandler((com.google.gwt.event.shared.EventHandler)handler, ValueChangeEvent.getType());
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setDMNModel(DRGElement model) {
        this.setValue(model.getLinksHolder().getValue());
        this.refresh();
    }

    void refresh() {
        List all = this.getValue().getLinks();
        RemoveHelper.removeChildren((Element)this.linksContainer);
        for (DMNExternalLink link : all) {
            DocumentationLinkItem listItem = (DocumentationLinkItem)this.listItems.get();
            listItem.init(link);
            listItem.setOnDeleted(this::onExternalLinkDeleted);
            this.linksContainer.appendChild((Node)listItem.getElement());
        }
        this.refreshContainersVisibility();
    }

    void refreshContainersVisibility() {
        if (this.getValue().getLinks().size() == 0) {
            HiddenHelper.show((Element)this.noneContainer);
            HiddenHelper.hide((Element)this.linksContainer);
        } else {
            HiddenHelper.hide((Element)this.noneContainer);
            HiddenHelper.show((Element)this.linksContainer);
        }
    }

    void onExternalLinkDeleted(DMNExternalLink externalLink) {
        this.locker.fire((Object)new LockRequiredEvent());
        this.getValue().getLinks().remove(externalLink);
        this.refresh();
    }
}

