/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions;

import java.util.Objects;
import java.util.Optional;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.kie.workbench.common.dmn.client.docks.navigator.DecisionNavigatorPresenter;
import org.kie.workbench.common.dmn.client.docks.navigator.drds.DMNDiagramsSession;
import org.kie.workbench.common.dmn.client.editors.drd.DRDNameChanger;
import org.kie.workbench.common.dmn.client.editors.expressions.ExpressionEditor;
import org.kie.workbench.common.dmn.client.editors.expressions.ExpressionEditorControl;
import org.kie.workbench.common.dmn.client.editors.expressions.ExpressionEditorView;
import org.kie.workbench.common.dmn.client.graph.DMNGraphUtils;
import org.kie.workbench.common.dmn.client.session.DMNSession;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvas;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.controls.AbstractCanvasControl;
import org.kie.workbench.common.stunner.core.client.canvas.event.registration.CanvasElementUpdatedEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.CanvasSelectionEvent;
import org.kie.workbench.common.stunner.core.client.canvas.listener.CanvasDomainObjectListener;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.domainobject.DomainObject;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;

@Dependent
public class ExpressionEditorControlImpl
extends AbstractCanvasControl<AbstractCanvas>
implements ExpressionEditorControl {
    private ExpressionEditorView view;
    private DecisionNavigatorPresenter decisionNavigator;
    private DMNGraphUtils dmnGraphUtils;
    private DMNDiagramsSession dmnDiagramsSession;
    private Event<CanvasElementUpdatedEvent> canvasElementUpdatedEvent;
    private DRDNameChanger drdNameChanger;
    private Optional<DMNSession> session = Optional.empty();
    private Optional<ExpressionEditorView.Presenter> expressionEditor = Optional.empty();
    private RefreshEditorDomainObjectListener refreshEditorDomainObjectListener;

    @Inject
    public ExpressionEditorControlImpl(ExpressionEditorView view, DecisionNavigatorPresenter decisionNavigator, DMNGraphUtils dmnGraphUtils, DMNDiagramsSession dmnDiagramsSession, Event<CanvasElementUpdatedEvent> canvasElementUpdatedEvent, DRDNameChanger drdNameChanger) {
        this.view = view;
        this.decisionNavigator = decisionNavigator;
        this.dmnGraphUtils = dmnGraphUtils;
        this.dmnDiagramsSession = dmnDiagramsSession;
        this.canvasElementUpdatedEvent = canvasElementUpdatedEvent;
        this.drdNameChanger = drdNameChanger;
    }

    public void bind(DMNSession session) {
        ExpressionEditorView.Presenter editor = this.makeExpressionEditor(this.view, this.decisionNavigator, this.dmnGraphUtils, this.dmnDiagramsSession);
        editor.bind(session);
        this.session = Optional.of(session);
        this.expressionEditor = Optional.of(editor);
        this.refreshEditorDomainObjectListener = new RefreshEditorDomainObjectListener(session);
        ((AbstractCanvasHandler)session.getCanvasHandler()).addDomainObjectListener((CanvasDomainObjectListener)this.refreshEditorDomainObjectListener);
    }

    ExpressionEditorView.Presenter makeExpressionEditor(ExpressionEditorView view, DecisionNavigatorPresenter decisionNavigator, DMNGraphUtils dmnGraphUtils, DMNDiagramsSession dmnDiagramsSession) {
        return new ExpressionEditor(view, decisionNavigator, dmnGraphUtils, dmnDiagramsSession, this.drdNameChanger);
    }

    protected void doInit() {
    }

    protected void doDestroy() {
        this.view = null;
        this.decisionNavigator = null;
        this.session.ifPresent(s -> ((AbstractCanvasHandler)s.getCanvasHandler()).removeDomainObjectListener((CanvasDomainObjectListener)this.refreshEditorDomainObjectListener));
        this.session = Optional.empty();
        this.expressionEditor = Optional.empty();
    }

    @Override
    public ExpressionEditorView.Presenter getExpressionEditor() {
        return this.expressionEditor.orElse(null);
    }

    public void onCanvasFocusedSelectionEvent(@Observes CanvasSelectionEvent event) {
        this.session.ifPresent(s -> {
            if (Objects.equals(s.getCanvasHandler(), event.getCanvasHandler())) {
                this.expressionEditor.ifPresent(ExpressionEditorView.Presenter::exit);
            }
        });
    }

    public void onCanvasElementUpdated(@Observes CanvasElementUpdatedEvent event) {
        this.expressionEditor.ifPresent(editor -> editor.handleCanvasElementUpdated(event));
    }

    private class RefreshEditorDomainObjectListener
    implements CanvasDomainObjectListener {
        private DMNSession session;

        public RefreshEditorDomainObjectListener(DMNSession session) {
            this.session = session;
        }

        public void update(DomainObject domainObject) {
            CanvasHandler canvasHandler = this.session.getCanvasHandler();
            Diagram diagram = canvasHandler.getDiagram();
            Graph graph = diagram.getGraph();
            for (Node node : graph.nodes()) {
                DomainObject d;
                Definition definition;
                if (!(node.getContent() instanceof Definition) || !((definition = (Definition)node.getContent()).getDefinition() instanceof DomainObject) || !Objects.equals((d = (DomainObject)definition.getDefinition()).getDomainObjectUUID(), domainObject.getDomainObjectUUID())) continue;
                ExpressionEditorControlImpl.this.canvasElementUpdatedEvent.fire((Object)new CanvasElementUpdatedEvent(canvasHandler, (Element)node));
            }
        }
    }
}

