/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.context;

import java.util.Optional;
import java.util.function.Supplier;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.model.Context;
import org.kie.workbench.common.dmn.api.definition.model.ContextEntry;
import org.kie.workbench.common.dmn.api.definition.model.Expression;
import org.kie.workbench.common.dmn.api.definition.model.InformationItem;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionEditorDefinition;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionEditorDefinitions;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ContextGridCell;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ContextUIModelMapperHelper;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ExpressionCellValue;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.InformationItemCell;
import org.kie.workbench.common.dmn.client.widgets.grid.BaseExpressionGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.ListSelectorView;
import org.kie.workbench.common.dmn.client.widgets.grid.model.BaseUIModelMapper;
import org.kie.workbench.common.dmn.client.widgets.grid.model.DMNGridCell;
import org.kie.workbench.common.dmn.client.widgets.grid.model.GridCellTuple;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridCellValue;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.selections.impl.RowSelectionStrategy;

public class ContextUIModelMapper
extends BaseUIModelMapper<Context> {
    public static final String DEFAULT_ROW_CAPTION = "<result>";
    private final GridWidget gridWidget;
    private final Supplier<Boolean> isOnlyVisualChangeAllowedSupplier;
    private final Supplier<ExpressionEditorDefinitions> expressionEditorDefinitionsSupplier;
    private final ListSelectorView.Presenter listSelector;
    private final int nesting;

    public ContextUIModelMapper(GridWidget gridWidget, Supplier<GridData> uiModel, Supplier<Optional<Context>> dmnModel, Supplier<Boolean> isOnlyVisualChangeAllowedSupplier, Supplier<ExpressionEditorDefinitions> expressionEditorDefinitionsSupplier, ListSelectorView.Presenter listSelector, int nesting) {
        super(uiModel, dmnModel);
        this.gridWidget = gridWidget;
        this.isOnlyVisualChangeAllowedSupplier = isOnlyVisualChangeAllowedSupplier;
        this.expressionEditorDefinitionsSupplier = expressionEditorDefinitionsSupplier;
        this.listSelector = listSelector;
        this.nesting = nesting;
    }

    @Override
    public void fromDMNModel(int rowIndex, int columnIndex) {
        ((Optional)this.dmnModel.get()).ifPresent(context -> {
            boolean isLastRow = this.isLastRow(rowIndex);
            ContextUIModelMapperHelper.ContextSection section = ContextUIModelMapperHelper.getSection(columnIndex);
            switch (section) {
                case ROW_INDEX: {
                    if (!isLastRow) {
                        ((GridData)this.uiModel.get()).setCell(rowIndex, columnIndex, () -> new ContextGridCell(new BaseGridCellValue((Object)(rowIndex + 1)), this.listSelector));
                    } else {
                        ((GridData)this.uiModel.get()).setCell(rowIndex, columnIndex, () -> new DMNGridCell(new BaseGridCellValue((Object)null)));
                    }
                    ((GridData)this.uiModel.get()).getCell(rowIndex, columnIndex).setSelectionStrategy(RowSelectionStrategy.INSTANCE);
                    break;
                }
                case NAME: {
                    InformationItem variable = ((ContextEntry)context.getContextEntry().get(rowIndex)).getVariable();
                    ((GridData)this.uiModel.get()).setCell(rowIndex, columnIndex, () -> new InformationItemCell(() -> InformationItemCell.HasNameAndDataTypeCell.wrap(variable, DEFAULT_ROW_CAPTION), this.listSelector));
                    break;
                }
                case EXPRESSION: {
                    ContextEntry ce = (ContextEntry)context.getContextEntry().get(rowIndex);
                    Optional<Expression> expression = Optional.ofNullable(ce.getExpression());
                    boolean isOnlyVisualChangeAllowed = this.isOnlyVisualChangeAllowedSupplier.get();
                    Optional<ExpressionEditorDefinition<Expression>> expressionEditorDefinition = this.expressionEditorDefinitionsSupplier.get().getExpressionEditorDefinition(expression);
                    expressionEditorDefinition.ifPresent(ed -> {
                        Optional<BaseExpressionGrid<Expression, GridData, BaseUIModelMapper>> editor = ed.getEditor(new GridCellTuple(rowIndex, columnIndex, this.gridWidget), Optional.empty(), (HasExpression)ce, Optional.ofNullable(ce.getVariable()), isOnlyVisualChangeAllowed, this.nesting + 1);
                        ((GridData)this.uiModel.get()).setCell(rowIndex, columnIndex, () -> new ContextGridCell(new ExpressionCellValue(editor), this.listSelector));
                    });
                }
            }
        });
    }

    protected boolean isLastRow(int rowIndex) {
        return ((Optional)this.dmnModel.get()).map(context -> rowIndex == context.getContextEntry().size() - 1).orElse(false);
    }

    @Override
    public void toDMNModel(int rowIndex, int columnIndex, Supplier<Optional<GridCellValue<?>>> cell) {
        ((Optional)this.dmnModel.get()).ifPresent(context -> {
            ContextUIModelMapperHelper.ContextSection section = ContextUIModelMapperHelper.getSection(columnIndex);
            switch (section) {
                case ROW_INDEX: {
                    break;
                }
                case NAME: {
                    ((ContextEntry)context.getContextEntry().get(rowIndex)).getVariable().getName().setValue(((GridCellValue)((Optional)cell.get()).orElse(new BaseGridCellValue((Object)""))).getValue().toString());
                    break;
                }
                case EXPRESSION: {
                    ((Optional)cell.get()).ifPresent(v -> {
                        ExpressionCellValue ecv = (ExpressionCellValue)((Object)((Object)v));
                        ((Optional)ecv.getValue()).ifPresent(beg -> beg.getExpression().get().ifPresent(e -> ((ContextEntry)context.getContextEntry().get(rowIndex)).setExpression(e)));
                    });
                }
            }
        });
    }
}

