/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.dtable;

import org.kie.workbench.common.dmn.api.definition.model.DecisionTable;

public class DecisionTableUIModelMapperHelper {
    public static final int ROW_INDEX_COLUMN_COUNT = 1;

    public static DecisionTableSection getSection(DecisionTable dtable, int columnIndex) {
        int inputClauseColumnCount = dtable.getInput().size();
        int outputClauseColumnCount = dtable.getOutput().size();
        int annotationClauseColumnCount = dtable.getAnnotations().size();
        int _columnIndex = columnIndex;
        if (--_columnIndex < 0) {
            return DecisionTableSection.ROW_INDEX;
        }
        if ((_columnIndex -= inputClauseColumnCount) < 0) {
            return DecisionTableSection.INPUT_CLAUSES;
        }
        if ((_columnIndex -= outputClauseColumnCount) < 0) {
            return DecisionTableSection.OUTPUT_CLAUSES;
        }
        if (_columnIndex - annotationClauseColumnCount < 0) {
            return DecisionTableSection.ANNOTATION_CLAUSES;
        }
        return DecisionTableSection.NONE;
    }

    public static int getInputEntryIndex(DecisionTable dtable, int columnIndex) {
        int inputClauseColumnCount = dtable.getInput().size();
        int _columnIndex = columnIndex;
        if (--_columnIndex < 0) {
            throw new IllegalArgumentException("columnIndex referenced 'Row index' column. Should be a valid InputEntry column.");
        }
        if (_columnIndex > inputClauseColumnCount - 1) {
            throw new IllegalArgumentException("columnIndex did not reference a valid InputEntry column.");
        }
        return _columnIndex;
    }

    public static int getOutputEntryIndex(DecisionTable dtable, int columnIndex) {
        int inputClauseColumnCount = dtable.getInput().size();
        int outputClauseColumnCount = dtable.getOutput().size();
        int _columnIndex = columnIndex;
        if (--_columnIndex < 0) {
            throw new IllegalArgumentException("columnIndex referenced 'Row index' column. Should be a valid OutputEntry column.");
        }
        if ((_columnIndex -= inputClauseColumnCount) < 0) {
            throw new IllegalArgumentException("columnIndex referenced an InputEntry column. Should be a valid OutputEntry column.");
        }
        if (_columnIndex > outputClauseColumnCount - 1) {
            throw new IllegalArgumentException("columnIndex did not reference a valid OutputEntry column.");
        }
        return _columnIndex;
    }

    public static int getAnnotationEntryIndex(DecisionTable dtable, int columnIndex) {
        int inputClauseColumnCount = dtable.getInput().size();
        int outputClauseColumnCount = dtable.getOutput().size();
        int annotationClauseColumnCount = dtable.getAnnotations().size();
        int _columnIndex = columnIndex;
        if (--_columnIndex < 0) {
            throw new IllegalArgumentException("columnIndex referenced 'Row index' column. Should be a valid AnnotationEntry column.");
        }
        if ((_columnIndex -= inputClauseColumnCount) < 0) {
            throw new IllegalArgumentException("columnIndex referenced an InputEntry column. Should be a valid AnnotationEntry column.");
        }
        if ((_columnIndex -= outputClauseColumnCount) < 0) {
            throw new IllegalArgumentException("columnIndex referenced an OutputEntry column. Should be a valid AnnotationEntry column.");
        }
        if (_columnIndex > annotationClauseColumnCount - 1) {
            throw new IllegalArgumentException("columnIndex did not reference a valid AnnotationEntry column.");
        }
        return _columnIndex;
    }

    public static enum DecisionTableSection {
        NONE,
        ROW_INDEX,
        INPUT_CLAUSES,
        OUTPUT_CLAUSES,
        ANNOTATION_CLAUSES;

    }
}

