/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.hitpolicy;

import java.util.Arrays;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.dmn.api.definition.model.BuiltinAggregator;
import org.kie.workbench.common.dmn.api.definition.model.HitPolicy;
import org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.hitpolicy.BuiltinAggregatorUtils;
import org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.hitpolicy.HasHitPolicyControl;
import org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.hitpolicy.HitPolicyPopoverView;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.popover.AbstractPopoverImpl;

@ApplicationScoped
public class HitPolicyPopoverImpl
extends AbstractPopoverImpl<HitPolicyPopoverView, HasHitPolicyControl>
implements HitPolicyPopoverView.Presenter {
    private TranslationService translationService;

    public HitPolicyPopoverImpl() {
    }

    @Inject
    public HitPolicyPopoverImpl(HitPolicyPopoverView view, TranslationService translationService, BuiltinAggregatorUtils builtinAggregatorUtils) {
        super(view);
        this.translationService = translationService;
        view.init(this);
        view.initHitPolicies(Arrays.asList(HitPolicy.values()));
        view.initBuiltinAggregators(builtinAggregatorUtils.getAllValues());
    }

    @Override
    public String getPopoverTitle() {
        return this.translationService.getTranslation("DecisionTableEditor.EditHitPolicy");
    }

    @Override
    public void bind(HasHitPolicyControl bound, int uiRowIndex, int uiColumnIndex) {
        super.bind(bound, uiRowIndex, uiColumnIndex);
        this.refresh();
    }

    private void refresh() {
        this.binding.ifPresent(b -> {
            if (b.getHitPolicy() == null) {
                ((HitPolicyPopoverView)this.view).enableHitPolicies(false);
                ((HitPolicyPopoverView)this.view).enableBuiltinAggregators(false);
            } else {
                ((HitPolicyPopoverView)this.view).enableHitPolicies(true);
                ((HitPolicyPopoverView)this.view).initSelectedHitPolicy(b.getHitPolicy());
                ((HitPolicyPopoverView)this.view).enableBuiltinAggregators(HitPolicy.COLLECT.equals((Object)b.getHitPolicy()));
                ((HitPolicyPopoverView)this.view).initSelectedBuiltinAggregator(b.getBuiltinAggregator());
            }
        });
    }

    @Override
    public void setHitPolicy(HitPolicy hitPolicy) {
        this.binding.ifPresent(b -> b.setHitPolicy(hitPolicy, this::refresh));
    }

    @Override
    public void setBuiltinAggregator(BuiltinAggregator aggregator) {
        this.binding.ifPresent(b -> b.setBuiltinAggregator(aggregator));
    }
}

