/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.function.parameters;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.dmn.api.definition.model.InformationItem;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.client.editors.expressions.types.function.parameters.HasParametersControl;
import org.kie.workbench.common.dmn.client.editors.expressions.types.function.parameters.ParametersPopoverView;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.popover.AbstractPopoverImpl;

@ApplicationScoped
public class ParametersPopoverImpl
extends AbstractPopoverImpl<ParametersPopoverView, HasParametersControl>
implements ParametersPopoverView.Presenter {
    private TranslationService translationService;

    public ParametersPopoverImpl() {
    }

    @Inject
    public ParametersPopoverImpl(ParametersPopoverView view, TranslationService translationService) {
        super(view);
        this.translationService = translationService;
        view.init(this);
    }

    @Override
    public String getPopoverTitle() {
        return this.translationService.getTranslation("FunctionEditor.EditParametersTitle");
    }

    @Override
    public void bind(HasParametersControl bound, int uiRowIndex, int uiColumnIndex) {
        super.bind(bound, uiRowIndex, uiColumnIndex);
        this.binding.ifPresent(b -> ((ParametersPopoverView)this.view).setParameters(b.getParameters()));
    }

    private void refresh() {
        this.binding.ifPresent(b -> {
            ((ParametersPopoverView)this.view).setParameters(b.getParameters());
            this.focusLastParameter((HasParametersControl)b);
        });
    }

    @Override
    public void show() {
        this.binding.ifPresent(b -> {
            ((ParametersPopoverView)this.view).show(Optional.ofNullable(this.getPopoverTitle()));
            this.focusLastParameter((HasParametersControl)b);
        });
    }

    private void focusLastParameter(HasParametersControl hasParameters) {
        List<InformationItem> parameters = hasParameters.getParameters();
        if (!parameters.isEmpty()) {
            ((ParametersPopoverView)this.view).focusParameter(parameters.size() - 1);
        }
    }

    @Override
    public void addParameter() {
        this.binding.ifPresent(b -> b.addParameter(this::refresh));
    }

    @Override
    public void removeParameter(InformationItem parameter) {
        this.binding.ifPresent(b -> b.removeParameter(parameter, this::refresh));
    }

    @Override
    public void updateParameterName(InformationItem parameter, String name) {
        this.binding.ifPresent(b -> {
            String trimmedName;
            String string = trimmedName = Objects.nonNull(name) ? name.trim() : "";
            if (!Objects.equals(parameter.getName().getValue(), trimmedName)) {
                b.updateParameterName(parameter, trimmedName, () -> this.updateViewParameterName((HasParametersControl)b, parameter, trimmedName));
            } else if (!Objects.equals(name, trimmedName)) {
                this.updateViewParameterName((HasParametersControl)b, parameter, trimmedName);
            }
        });
    }

    private void updateViewParameterName(HasParametersControl binding, InformationItem parameter, String name) {
        int index = binding.getParameters().indexOf(parameter);
        ((ParametersPopoverView)this.view).updateParameterName(index, name);
    }

    @Override
    public void updateParameterTypeRef(InformationItem parameter, QName typeRef) {
        this.binding.ifPresent(b -> b.updateParameterTypeRef(parameter, typeRef));
    }
}

