/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.included.grid;

import elemental2.dom.HTMLElement;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.workbench.common.dmn.client.editors.included.BaseIncludedModelActiveRecord;
import org.kie.workbench.common.dmn.client.editors.included.DMNIncludedModelActiveRecord;
import org.kie.workbench.common.dmn.client.editors.included.IncludedModelsPageState;
import org.kie.workbench.common.dmn.client.editors.included.PMMLIncludedModelActiveRecord;
import org.kie.workbench.common.dmn.client.editors.included.grid.BaseCardComponent;
import org.kie.workbench.common.dmn.client.editors.included.grid.DMNCardComponent;
import org.kie.workbench.common.dmn.client.editors.included.grid.DefaultCardComponent;
import org.kie.workbench.common.dmn.client.editors.included.grid.PMMLCardComponent;
import org.kie.workbench.common.dmn.client.editors.included.grid.empty.DMNCardsEmptyStateView;
import org.kie.workbench.common.widgets.client.cards.CardComponent;
import org.kie.workbench.common.widgets.client.cards.CardsGridComponent;

public class DMNCardsGridComponent {
    private final ManagedInstance<DMNCardComponent> dmnCardComponent;
    private final ManagedInstance<PMMLCardComponent> pmmlCardComponent;
    private final ManagedInstance<DefaultCardComponent> defaultCardComponent;
    private final CardsGridComponent cardsGridComponent;
    private final IncludedModelsPageState pageState;
    private final DMNCardsEmptyStateView emptyStateView;

    @Inject
    public DMNCardsGridComponent(ManagedInstance<DMNCardComponent> dmnCardComponent, ManagedInstance<PMMLCardComponent> pmmlCardComponent, ManagedInstance<DefaultCardComponent> defaultCardComponent, CardsGridComponent cardsGridComponent, IncludedModelsPageState pageState, DMNCardsEmptyStateView emptyStateView) {
        this.dmnCardComponent = dmnCardComponent;
        this.pmmlCardComponent = pmmlCardComponent;
        this.defaultCardComponent = defaultCardComponent;
        this.cardsGridComponent = cardsGridComponent;
        this.pageState = pageState;
        this.emptyStateView = emptyStateView;
    }

    @PostConstruct
    public void init() {
        this.cardsGridComponent.setEmptyState(this.emptyStateView.getElement());
    }

    public void refresh() {
        this.cardsGridComponent.setupCards(this.cards(this.generateIncludedModels()));
    }

    public HTMLElement getElement() {
        return this.cardsGridComponent.getElement();
    }

    private List<CardComponent> cards(List<BaseIncludedModelActiveRecord> includes) {
        return includes.stream().map(this::card).collect(Collectors.toList());
    }

    private BaseCardComponent card(BaseIncludedModelActiveRecord includedModel) {
        BaseCardComponent card = includedModel instanceof DMNIncludedModelActiveRecord ? (BaseCardComponent)this.dmnCardComponent.get() : (includedModel instanceof PMMLIncludedModelActiveRecord ? (BaseCardComponent)this.pmmlCardComponent.get() : (BaseCardComponent)this.defaultCardComponent.get());
        card.setup(this, includedModel);
        return card;
    }

    private List<BaseIncludedModelActiveRecord> generateIncludedModels() {
        return this.pageState.generateIncludedModels();
    }
}

