/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.included.imports.persistence;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Any;
import javax.inject.Inject;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.workbench.common.dmn.api.definition.model.Import;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.client.editors.common.messages.FlashMessage;
import org.kie.workbench.common.dmn.client.editors.common.persistence.RecordEngine;
import org.kie.workbench.common.dmn.client.editors.included.BaseIncludedModelActiveRecord;
import org.kie.workbench.common.dmn.client.editors.included.imports.ImportFactory;
import org.kie.workbench.common.dmn.client.editors.included.imports.IncludedModelsIndex;
import org.kie.workbench.common.dmn.client.editors.included.imports.IncludedModelsPageStateProviderImpl;
import org.kie.workbench.common.dmn.client.editors.included.imports.messages.IncludedModelErrorMessageFactory;
import org.kie.workbench.common.dmn.client.editors.included.imports.persistence.DRGElementHandler;
import org.kie.workbench.common.dmn.client.editors.included.imports.persistence.DefinitionsHandler;
import org.kie.workbench.common.stunner.core.util.StringUtils;

public class ImportRecordEngine
implements RecordEngine<BaseIncludedModelActiveRecord> {
    private final IncludedModelsPageStateProviderImpl stateProvider;
    private final IncludedModelsIndex includedModelsIndex;
    private final IncludedModelErrorMessageFactory messageFactory;
    private final ImportFactory importFactory;
    private final Event<FlashMessage> flashMessageEvent;
    private final DefinitionsHandler definitionsHandler;
    private final ManagedInstance<DRGElementHandler> drgElementHandlers;

    @Inject
    public ImportRecordEngine(IncludedModelsPageStateProviderImpl stateProvider, IncludedModelsIndex includedModelsIndex, IncludedModelErrorMessageFactory messageFactory, ImportFactory importFactory, Event<FlashMessage> flashMessageEvent, DefinitionsHandler definitionsHandler, @Any ManagedInstance<DRGElementHandler> drgElementHandlers) {
        this.stateProvider = stateProvider;
        this.includedModelsIndex = includedModelsIndex;
        this.messageFactory = messageFactory;
        this.importFactory = importFactory;
        this.flashMessageEvent = flashMessageEvent;
        this.definitionsHandler = definitionsHandler;
        this.drgElementHandlers = drgElementHandlers;
    }

    @Override
    public List<BaseIncludedModelActiveRecord> update(BaseIncludedModelActiveRecord record) {
        if (!record.isValid()) {
            throw new UnsupportedOperationException("An invalid Included Model cannot be updated.");
        }
        Import anImport = this.getImport(record);
        String oldModelName = anImport.getName().getValue();
        this.drgElementHandlers.forEach(handler -> handler.update(oldModelName, record.getName()));
        anImport.setName(new Name(record.getName()));
        return Collections.singletonList(record);
    }

    @Override
    public List<BaseIncludedModelActiveRecord> destroy(BaseIncludedModelActiveRecord record) {
        this.definitionsHandler.destroy(record);
        this.drgElementHandlers.forEach(handler -> handler.destroy(record.getName()));
        this.stateProvider.getImports().remove(this.getImport(record));
        return Collections.singletonList(record);
    }

    @Override
    public List<BaseIncludedModelActiveRecord> create(BaseIncludedModelActiveRecord record) {
        this.definitionsHandler.create(record);
        this.stateProvider.getImports().add(this.importFactory.makeImport(record));
        return Collections.singletonList(record);
    }

    @Override
    public boolean isValid(BaseIncludedModelActiveRecord record) {
        if (!this.isUniqueName(record)) {
            this.flashMessageEvent.fire((Object)this.messageFactory.getNameIsNotUniqueFlashMessage(record));
            return false;
        }
        if (this.isBlankName(record)) {
            this.flashMessageEvent.fire((Object)this.messageFactory.getNameIsBlankFlashMessage(record));
            return false;
        }
        return true;
    }

    private boolean isUniqueName(BaseIncludedModelActiveRecord record) {
        return this.stateProvider.getImports().stream().noneMatch(anImport -> !this.sameImport(record, (Import)anImport) && this.sameName(record, (Import)anImport));
    }

    private boolean isBlankName(BaseIncludedModelActiveRecord record) {
        return StringUtils.isEmpty((String)record.getName());
    }

    private boolean sameName(BaseIncludedModelActiveRecord record, Import anImport) {
        return Objects.equals(record.getName(), anImport.getName().getValue());
    }

    private boolean sameImport(BaseIncludedModelActiveRecord record, Import anImport) {
        Import recordImport = this.getImport(record);
        return Objects.equals(recordImport, anImport);
    }

    private Import getImport(BaseIncludedModelActiveRecord record) {
        return this.includedModelsIndex.getImport(record);
    }
}

