/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.included.modal.dropdown;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.soup.commons.util.Maps;
import org.kie.workbench.common.dmn.api.editors.included.DMNIncludedModel;
import org.kie.workbench.common.dmn.api.editors.included.IncludedModel;
import org.kie.workbench.common.dmn.api.editors.included.PMMLIncludedModel;
import org.kie.workbench.common.dmn.client.api.included.legacy.DMNIncludeModelsClient;
import org.kie.workbench.common.dmn.client.editors.included.IncludedModelsPageState;
import org.kie.workbench.common.dmn.client.editors.included.imports.IncludedModelsIndex;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.widgets.client.assets.dropdown.KieAssetsDropdownItem;
import org.kie.workbench.common.widgets.client.assets.dropdown.KieAssetsDropdownItemsProvider;
import org.uberfire.backend.vfs.Path;

@Dependent
public class DMNAssetsDropdownItemsProvider
implements KieAssetsDropdownItemsProvider {
    public static final String PATH_METADATA = "path";
    public static final String IMPORT_TYPE_METADATA = "import_type";
    public static final String DRG_ELEMENT_COUNT_METADATA = "drg_element_count";
    public static final String ITEM_DEFINITION_COUNT_METADATA = "item_definition_count";
    public static final String PMML_MODEL_COUNT_METADATA = "pmml_model_count";
    private final DMNIncludeModelsClient client;
    private final IncludedModelsPageState pageState;
    private final IncludedModelsIndex modelsIndex;
    private final SessionManager sessionManager;

    @Inject
    public DMNAssetsDropdownItemsProvider(DMNIncludeModelsClient client, IncludedModelsPageState pageState, IncludedModelsIndex modelsIndex, SessionManager sessionManager) {
        this.client = client;
        this.pageState = pageState;
        this.modelsIndex = modelsIndex;
        this.sessionManager = sessionManager;
    }

    public void getItems(Consumer<List<KieAssetsDropdownItem>> assetListConsumer) {
        this.client.loadModels(this.getDMNModelPath(), this.wrap(assetListConsumer));
    }

    Path getDMNModelPath() {
        return this.sessionManager.getCurrentSession().getCanvasHandler().getDiagram().getMetadata().getPath();
    }

    Consumer<List<IncludedModel>> wrap(Consumer<List<KieAssetsDropdownItem>> assetListConsumer) {
        return dmnIncludeModels -> assetListConsumer.accept(dmnIncludeModels.stream().filter(this::isNotExisting).filter(this::isNotCurrentDiagram).map(this::asKieAsset).collect(Collectors.toList()));
    }

    private boolean isNotExisting(IncludedModel data) {
        return this.modelsIndex.getIndexedImports().stream().noneMatch(anImport -> {
            if (data instanceof DMNIncludedModel) {
                return Objects.equals(((DMNIncludedModel)data).getNamespace(), anImport.getNamespace());
            }
            return Objects.equals(data.getPath(), anImport.getLocationURI().getValue());
        });
    }

    private boolean isNotCurrentDiagram(IncludedModel data) {
        if (data instanceof DMNIncludedModel) {
            return !Objects.equals(((DMNIncludedModel)data).getNamespace(), this.pageState.getCurrentDiagramNamespace());
        }
        return true;
    }

    KieAssetsDropdownItem asKieAsset(IncludedModel includedModel) {
        String text = includedModel.getModelName();
        String subText = includedModel.getModelPackage();
        String value = this.getKieAssetValue(includedModel);
        Map<String, String> metaData = this.buildMetaData(includedModel);
        return new KieAssetsDropdownItem(text, subText, value, metaData);
    }

    private String getKieAssetValue(IncludedModel includedModel) {
        if (includedModel instanceof DMNIncludedModel) {
            return ((DMNIncludedModel)includedModel).getNamespace();
        }
        return includedModel.getModelName();
    }

    private Map<String, String> buildMetaData(IncludedModel includedModel) {
        if (includedModel instanceof DMNIncludedModel) {
            DMNIncludedModel idm = (DMNIncludedModel)includedModel;
            return new Maps.Builder().put((Object)PATH_METADATA, (Object)includedModel.getPath()).put((Object)IMPORT_TYPE_METADATA, (Object)includedModel.getImportType()).put((Object)DRG_ELEMENT_COUNT_METADATA, (Object)idm.getDrgElementsCount().toString()).put((Object)ITEM_DEFINITION_COUNT_METADATA, (Object)idm.getItemDefinitionsCount().toString()).build();
        }
        if (includedModel instanceof PMMLIncludedModel) {
            PMMLIncludedModel ipm = (PMMLIncludedModel)includedModel;
            return new Maps.Builder().put((Object)PATH_METADATA, (Object)includedModel.getPath()).put((Object)IMPORT_TYPE_METADATA, (Object)includedModel.getImportType()).put((Object)PMML_MODEL_COUNT_METADATA, (Object)ipm.getModelCount().toString()).build();
        }
        return Collections.emptyMap();
    }
}

