/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.search;

import elemental2.dom.Element;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.kie.workbench.common.dmn.client.editors.search.DMNSearchableElement;
import org.kie.workbench.common.dmn.client.editors.search.DMNSubIndex;
import org.kie.workbench.common.dmn.client.editors.types.common.DataType;
import org.kie.workbench.common.dmn.client.editors.types.listview.DataTypeList;
import org.kie.workbench.common.dmn.client.editors.types.listview.DataTypeListItem;
import org.kie.workbench.common.dmn.client.editors.types.persistence.DataTypeStore;
import org.kie.workbench.common.dmn.client.editors.types.shortcuts.DataTypeShortcuts;

@ApplicationScoped
public class DMNDataTypesSubIndex
implements DMNSubIndex {
    private final DataTypeList dataTypeList;
    private final DataTypeShortcuts dataTypeShortcuts;
    private final DataTypeStore dataTypeStore;

    @Inject
    public DMNDataTypesSubIndex(DataTypeList dataTypeList, DataTypeShortcuts dataTypeShortcuts, DataTypeStore dataTypeStore) {
        this.dataTypeList = dataTypeList;
        this.dataTypeShortcuts = dataTypeShortcuts;
        this.dataTypeStore = dataTypeStore;
    }

    public List<DMNSearchableElement> getSearchableElements() {
        return this.dataTypeList.getItems().stream().map(this::makeDataTypeListItem).collect(Collectors.toList());
    }

    private DMNSearchableElement makeDataTypeListItem(DataTypeListItem item) {
        DMNSearchableElement element = new DMNSearchableElement();
        element.setText(item.getDataType().getName());
        element.setOnFound(() -> this.highlight(item));
        return element;
    }

    void highlight(DataTypeListItem item) {
        this.expandParents(item);
        this.dataTypeShortcuts.highlight((Element)item.getDragAndDropElement());
    }

    private void expandParents(DataTypeListItem item) {
        item.expand();
        this.getParent(item).ifPresent(parent -> this.getItem((DataType)parent).ifPresent(this::expandParents));
    }

    private Optional<DataType> getParent(DataTypeListItem item) {
        String parentUUID = item.getDataType().getParentUUID();
        return Optional.ofNullable(this.dataTypeStore.get(parentUUID));
    }

    private Optional<DataTypeListItem> getItem(DataType parent) {
        return this.dataTypeList.getItems().stream().filter(item -> Objects.equals(item.getDataType().getUUID(), parent.getUUID())).findAny();
    }

    @Override
    public void onNoResultsFound() {
        this.dataTypeShortcuts.reset();
    }
}

