/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.search;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.kie.workbench.common.dmn.client.editors.search.DMNDataTypesSubIndex;
import org.kie.workbench.common.dmn.client.editors.search.DMNGraphSubIndex;
import org.kie.workbench.common.dmn.client.editors.search.DMNGridSubIndex;
import org.kie.workbench.common.dmn.client.editors.search.DMNSearchableElement;
import org.kie.workbench.common.dmn.client.editors.search.DMNSubIndex;
import org.kie.workbench.common.dmn.client.session.DMNSession;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.widgets.client.search.common.BaseEditorSearchIndex;
import org.kie.workbench.common.widgets.client.search.common.SearchPerformedEvent;
import org.kie.workbench.common.widgets.client.search.common.Searchable;
import org.uberfire.mvp.Command;

@Dependent
public class DMNEditorSearchIndex
extends BaseEditorSearchIndex<DMNSearchableElement> {
    private final DMNGraphSubIndex graphSubIndex;
    private final DMNGridSubIndex gridSubIndex;
    private final DMNDataTypesSubIndex dataTypesSubIndex;
    private final SessionManager sessionManager;
    private Supplier<Boolean> isDataTypesTabActiveSupplier = () -> false;
    private final Event<SearchPerformedEvent> searchPerformedEvent;

    @Inject
    public DMNEditorSearchIndex(DMNGraphSubIndex graphSubIndex, DMNGridSubIndex gridSubIndex, DMNDataTypesSubIndex dataTypesSubIndex, SessionManager sessionManager, Event<SearchPerformedEvent> searchPerformedEvent) {
        this.graphSubIndex = graphSubIndex;
        this.gridSubIndex = gridSubIndex;
        this.dataTypesSubIndex = dataTypesSubIndex;
        this.sessionManager = sessionManager;
        this.searchPerformedEvent = searchPerformedEvent;
    }

    @PostConstruct
    public void init() {
        this.registerSubIndex(this.graphSubIndex);
        this.registerSubIndex(this.gridSubIndex);
        this.setNoResultsFoundCallback(this.getNoResultsFoundCallback());
        this.setSearchClosedCallback(this.getSearchClosedCallback());
        this.setSearchPerformedCallback(this.getSearchPerformedCallback());
    }

    Command getSearchPerformedCallback() {
        return () -> {
            Optional current = this.getCurrentResult();
            DMNSearchableElement value = null;
            if (current.isPresent()) {
                value = (DMNSearchableElement)current.get();
            }
            SearchPerformedEvent event = new SearchPerformedEvent((Searchable)value);
            this.searchPerformedEvent.fire((Object)event);
        };
    }

    protected List<DMNSearchableElement> getSearchableElements() {
        return this.getSubIndex().getSearchableElements();
    }

    Command getNoResultsFoundCallback() {
        return () -> this.getSubIndex().onNoResultsFound();
    }

    public void setIsDataTypesTabActiveSupplier(Supplier<Boolean> isDataTypesTabActiveSupplier) {
        this.isDataTypesTabActiveSupplier = isDataTypesTabActiveSupplier;
    }

    Command getSearchClosedCallback() {
        return () -> this.getSubIndex().onSearchClosed();
    }

    private DMNSubIndex getSubIndex() {
        SearchContext searchContext = this.currentSearchContext();
        switch (searchContext) {
            case BOXED_EXPRESSION: {
                return this.gridSubIndex;
            }
            case DATA_TYPES: {
                return this.dataTypesSubIndex;
            }
            case GRAPH: {
                return this.graphSubIndex;
            }
        }
        throw new UnsupportedOperationException("Unsupported search context: " + (Object)((Object)searchContext));
    }

    public Supplier<Boolean> getIsDataTypesTabActiveSupplier() {
        return this.isDataTypesTabActiveSupplier;
    }

    private SearchContext currentSearchContext() {
        if (this.getIsDataTypesTabActiveSupplier().get().booleanValue()) {
            return SearchContext.DATA_TYPES;
        }
        if (this.isExpressionEditorActive()) {
            return SearchContext.BOXED_EXPRESSION;
        }
        return SearchContext.GRAPH;
    }

    private boolean isExpressionEditorActive() {
        DMNSession session = this.getCurrentSession();
        if (Objects.isNull(session)) {
            return false;
        }
        return session.getExpressionEditor().isActive();
    }

    private DMNSession getCurrentSession() {
        return (DMNSession)this.sessionManager.getCurrentSession();
    }

    static enum SearchContext {
        BOXED_EXPRESSION,
        DATA_TYPES,
        GRAPH;

    }
}

