/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.imported;

import com.google.gwt.event.dom.client.ClickEvent;
import elemental2.dom.HTMLAnchorElement;
import elemental2.dom.HTMLButtonElement;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLElement;
import elemental2.dom.HTMLLabelElement;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.dmn.api.editors.types.DataObject;
import org.kie.workbench.common.dmn.client.editors.types.imported.ImportDataObjectModal;
import org.kie.workbench.common.dmn.client.editors.types.imported.treelist.TreeList;
import org.kie.workbench.common.dmn.client.editors.types.imported.treelist.TreeListItem;

@Dependent
@Templated
public class ImportDataObjectModalView
implements ImportDataObjectModal.View {
    static final String OPENED_CONTAINER_CSS_CLASS = "opened";
    @DataField(value="header")
    private final HTMLDivElement header;
    @DataField(value="body")
    private final HTMLDivElement body;
    @DataField(value="footer")
    private final HTMLDivElement footer;
    @DataField(value="note-text")
    private final HTMLElement noteText;
    @DataField(value="note-label")
    private final HTMLLabelElement noteLabel;
    @DataField(value="items-container")
    private final HTMLDivElement itemsContainer;
    @DataField(value="clear-selection")
    private final HTMLAnchorElement clearSelection;
    @DataField(value="button-cancel")
    private final HTMLButtonElement buttonCancel;
    @DataField(value="button-import")
    private final HTMLButtonElement buttonImport;
    @DataField(value="warning-container")
    private final HTMLDivElement warningContainer;
    private final TreeList treeList;
    private ImportDataObjectModal presenter;
    private final ManagedInstance<TreeListItem> items;

    @Inject
    public ImportDataObjectModalView(HTMLDivElement header, HTMLDivElement body, HTMLDivElement footer, TreeList treeList, @Named(value="span") HTMLElement noteText, HTMLLabelElement noteLabel, HTMLDivElement itemsContainer, HTMLAnchorElement clearSelection, ManagedInstance<TreeListItem> items, HTMLButtonElement buttonImport, HTMLButtonElement buttonCancel, HTMLDivElement warningContainer) {
        this.header = header;
        this.body = body;
        this.footer = footer;
        this.treeList = treeList;
        this.noteText = noteText;
        this.noteLabel = noteLabel;
        this.itemsContainer = itemsContainer;
        this.clearSelection = clearSelection;
        this.items = items;
        this.buttonImport = buttonImport;
        this.buttonCancel = buttonCancel;
        this.warningContainer = warningContainer;
    }

    @PostConstruct
    public void setup() {
        this.treeList.setOnSelectionChanged(this.getOnSelectionChanged());
    }

    Consumer<List<TreeListItem>> getOnSelectionChanged() {
        return this::onSelectionChanged;
    }

    void onSelectionChanged(List<TreeListItem> treeListItems) {
        List<DataObject> selectedItems = treeListItems.stream().map(item -> item.getDataSource()).collect(Collectors.toList());
        this.presenter.onDataObjectSelectionChanged(selectedItems);
    }

    public String getHeader() {
        return this.header.textContent;
    }

    public HTMLElement getBody() {
        return this.body;
    }

    public HTMLElement getFooter() {
        return this.footer;
    }

    public void init(ImportDataObjectModal presenter) {
        this.presenter = presenter;
    }

    @EventHandler(value={"button-cancel"})
    void onButtonCancelClicked(ClickEvent e) {
        this.presenter.hide();
    }

    @EventHandler(value={"button-import"})
    void onButtonImportClicked(ClickEvent e) {
        List<DataObject> selectedItems = this.getSelectedItems();
        this.presenter.hide(selectedItems);
    }

    List<DataObject> getSelectedItems() {
        return this.treeList.getSelectedItems().stream().map(item -> item.getDataSource()).collect(Collectors.toList());
    }

    @EventHandler(value={"clear-selection"})
    void onClearSelectionClicked(ClickEvent e) {
        this.treeList.clearSelection();
        this.refresh();
    }

    @Override
    public void addItems(List<DataObject> dataObjects) {
        ArrayList<TreeListItem> dataObjectItems = new ArrayList<TreeListItem>();
        for (DataObject data : dataObjects) {
            dataObjectItems.add(this.createTreeListItem(data));
        }
        this.treeList.populate(dataObjectItems);
        this.itemsContainer.appendChild(this.treeList.getElement());
    }

    TreeListItem createTreeListItem(DataObject data) {
        TreeListItem item = (TreeListItem)this.items.get();
        item.setDataSource(data);
        item.setDescription(data.getClassType());
        return item;
    }

    void refresh() {
        this.removeTreeList();
        this.treeList.refresh();
        this.itemsContainer.appendChild(this.treeList.getElement());
    }

    @Override
    public void clear() {
        this.removeTreeList();
        this.treeList.clear();
    }

    @Override
    public void showDataTypeWithSameNameWarning() {
        this.warningContainer.classList.add(new String[]{OPENED_CONTAINER_CSS_CLASS});
    }

    @Override
    public void hideDataTypeWithSameNameWarning() {
        this.warningContainer.classList.remove(new String[]{OPENED_CONTAINER_CSS_CLASS});
    }

    void removeTreeList() {
        if (this.itemsContainer.contains(this.treeList.getElement())) {
            this.itemsContainer.removeChild(this.treeList.getElement());
        }
    }
}

