/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.imported.treelist;

import elemental2.dom.Node;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.dmn.client.editors.types.imported.treelist.TreeListItem;
import org.uberfire.client.mvp.UberElemental;

@Dependent
public class TreeList {
    private final View view;
    private List<TreeListItem> currentItems;
    private Consumer<List<TreeListItem>> onSelectionChanged;

    @Inject
    public TreeList(View view) {
        this.view = view;
    }

    public void populate(List<TreeListItem> items) {
        this.currentItems = items;
        this.refresh();
    }

    public void refresh() {
        this.clear();
        for (TreeListItem item : this.getCurrentItems()) {
            item.updateView();
            this.view.add(item);
            item.setOnIsSelectedChanged(this::selectionChanged);
        }
    }

    void selectionChanged(TreeListItem treeListItem) {
        this.callOnSelectionChanged();
    }

    void callOnSelectionChanged() {
        if (!Objects.isNull(this.getOnSelectionChanged())) {
            this.getOnSelectionChanged().accept(this.getSelectedItems());
        }
    }

    public List<TreeListItem> getCurrentItems() {
        return this.currentItems;
    }

    public void clear() {
        this.view.clear();
    }

    public Node getElement() {
        return this.view.getElement();
    }

    public void clearSelection() {
        this.getCurrentItems().stream().forEach(item -> item.setIsSelected(false));
    }

    public List<TreeListItem> getSelectedItems() {
        return this.getCurrentItems().stream().filter(item -> item.getIsSelected()).collect(Collectors.toList());
    }

    public void setOnSelectionChanged(Consumer<List<TreeListItem>> onSelectionChanged) {
        this.onSelectionChanged = onSelectionChanged;
    }

    Consumer<List<TreeListItem>> getOnSelectionChanged() {
        return this.onSelectionChanged;
    }

    public static interface View
    extends UberElemental<TreeList> {
        public void add(TreeListItem var1);

        public void clear();
    }
}

