/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview;

import elemental2.dom.Element;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLElement;
import elemental2.dom.HTMLInputElement;
import elemental2.dom.Node;
import elemental2.dom.NodeList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.dmn.api.qualifiers.DMNEditor;
import org.kie.workbench.common.dmn.client.editors.common.RemoveHelper;
import org.kie.workbench.common.dmn.client.editors.types.common.DataType;
import org.kie.workbench.common.dmn.client.editors.types.common.HiddenHelper;
import org.kie.workbench.common.dmn.client.editors.types.listview.DataTypeListItem;
import org.kie.workbench.common.dmn.client.editors.types.listview.DataTypeSelect;
import org.kie.workbench.common.dmn.client.editors.types.listview.common.JQueryTooltip;
import org.kie.workbench.common.dmn.client.editors.types.listview.common.ListItemViewCssHelper;
import org.kie.workbench.common.dmn.client.editors.types.listview.common.SmallSwitchComponent;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.DataTypeConstraint;
import org.kie.workbench.common.stunner.core.client.ReadOnlyProvider;

@Dependent
@Templated
public class DataTypeListItemView
implements DataTypeListItem.View {
    public static final String UUID_ATTR = "data-row-uuid";
    public static final String NAME_DATA_FIELD = "name-input";
    public static final String PARENT_UUID_ATTR = "data-parent-row-uuid";
    static final String ARROW_BUTTON_SELECTOR = "[data-type-field=\"arrow-button\"]";
    @DataField(value="view")
    private final HTMLDivElement view;
    private final TranslationService translationService;
    private final ReadOnlyProvider readOnlyProvider;
    private DataTypeListItem presenter;

    @Inject
    public DataTypeListItemView(HTMLDivElement view, TranslationService translationService, @DMNEditor ReadOnlyProvider readOnlyProvider) {
        this.view = view;
        this.translationService = translationService;
        this.readOnlyProvider = readOnlyProvider;
    }

    public void init(DataTypeListItem presenter) {
        this.presenter = presenter;
    }

    public HTMLElement getElement() {
        return this.view;
    }

    void setupRowMetadata(DataType dataType) {
        this.getDragAndDropElement().setAttribute(UUID_ATTR, dataType.getUUID());
        this.getDragAndDropElement().setAttribute(PARENT_UUID_ATTR, dataType.getParentUUID());
        this.setupRowCSSClass(dataType);
    }

    void setupRowCSSClass(DataType dataType) {
        this.setupSubDataTypesCSSClass(dataType);
        this.setupReadOnlyCSSClass(dataType);
    }

    void setupSubDataTypesCSSClass(DataType dataType) {
        String hasSubDataTypesCSSClass = "has-sub-data-types";
        if (dataType.hasSubDataTypes()) {
            this.getDragAndDropElement().classList.add(new String[]{"has-sub-data-types"});
        } else {
            this.getDragAndDropElement().classList.remove(new String[]{"has-sub-data-types"});
        }
    }

    void setupReadOnlyCSSClass(DataType dataType) {
        String readOnlyCSSClass = "read-only";
        if (dataType.isReadOnly() || this.readOnlyProvider.isReadOnlyDiagram()) {
            this.getDragAndDropElement().classList.add(new String[]{"read-only"});
        } else {
            this.getDragAndDropElement().classList.remove(new String[]{"read-only"});
        }
    }

    void setupArrow(DataType dataType) {
        this.toggleArrow(dataType.hasSubDataTypes());
    }

    void setupReadOnly(DataType dataType) {
        HiddenHelper.hide((Element)this.getNameInput());
        this.setName(dataType.getName());
    }

    void setupActionButtons() {
        this.showEditButton();
    }

    @Override
    public void toggleArrow(boolean show) {
        if (show) {
            HiddenHelper.show(this.getArrow());
        } else {
            HiddenHelper.hide(this.getArrow());
        }
    }

    @Override
    public void expand() {
        Element parent = this.getRowElement(this.getDataType());
        int parentPositionY = this.presenter.getPositionY(parent);
        AtomicInteger i = new AtomicInteger(1);
        ListItemViewCssHelper.asDownArrow(this.getArrow());
        this.forEachChildElement(parent, (Element child) -> {
            HiddenHelper.show(child);
            double positionY = (double)parentPositionY + (double)i.getAndIncrement() / 10.0;
            this.presenter.setPositionY((Element)child, positionY);
            return !this.isCollapsed(child.querySelector(ARROW_BUTTON_SELECTOR));
        });
        this.presenter.refreshItemsCSSAndHTMLPosition();
    }

    @Override
    public void collapse() {
        Element parent = this.getRowElement(this.getDataType());
        ListItemViewCssHelper.asRightArrow(this.getArrow());
        this.forEachChildElement(parent, (Element element) -> {
            this.presenter.setPositionY((Element)element, -2.0);
            HiddenHelper.hide(element);
        });
        this.presenter.refreshItemsCSSAndHTMLPosition();
    }

    @Override
    public void showEditButton() {
        HiddenHelper.show(this.getEditButton());
        HiddenHelper.show(this.getAddDataTypeRowButton());
        HiddenHelper.show(this.getRemoveButton());
        HiddenHelper.hide(this.getSaveButton());
        HiddenHelper.hide(this.getCloseButton());
    }

    @Override
    public void showSaveButton() {
        HiddenHelper.hide(this.getEditButton());
        HiddenHelper.hide(this.getAddDataTypeRowButton());
        HiddenHelper.hide(this.getRemoveButton());
        HiddenHelper.show(this.getSaveButton());
        HiddenHelper.show(this.getCloseButton());
    }

    @Override
    public void enableFocusMode() {
        Element rowElement = this.getRowElement(this.getDataType());
        ListItemViewCssHelper.asFocusedDataType(rowElement);
        this.forEachChildElement(rowElement, ListItemViewCssHelper::asFocusedDataType);
        this.getNameInput().select();
    }

    @Override
    public void disableFocusMode() {
        Element rowElement = this.getRowElement(this.getDataType());
        if (rowElement != null) {
            ListItemViewCssHelper.asNonFocusedDataType(rowElement);
            this.forEachChildElement(rowElement, ListItemViewCssHelper::asNonFocusedDataType);
        }
    }

    @Override
    public boolean isOnFocusMode() {
        return ListItemViewCssHelper.isFocusedDataType(this.getRowElement(this.getDataType()));
    }

    @Override
    public String getName() {
        return this.getNameInput().value;
    }

    @Override
    public void setName(String name) {
        this.getNameText().textContent = name;
        this.getNameInput().value = name;
    }

    @Override
    public void showDataTypeNameInput() {
        HiddenHelper.hide(this.getNameText());
        HiddenHelper.show((Element)this.getNameInput());
        this.showLabels();
    }

    @Override
    public void hideDataTypeNameInput() {
        this.getNameText().textContent = this.getNameInput().value.isEmpty() ? "-" : this.getNameInput().value;
        HiddenHelper.hide((Element)this.getNameInput());
        HiddenHelper.show(this.getNameText());
        this.hideLabels();
    }

    void showLabels() {
        NodeList<Element> labels = this.getLabels();
        for (int i = 0; i < labels.length; ++i) {
            HiddenHelper.show((Element)labels.getAt(i));
        }
    }

    void hideLabels() {
        NodeList<Element> labels = this.getLabels();
        for (int i = 0; i < labels.length; ++i) {
            HiddenHelper.hide((Element)labels.getAt(i));
        }
    }

    @Override
    public void setupSelectComponent(DataTypeSelect typeSelect) {
        HTMLElement element = typeSelect.getElement();
        RemoveHelper.removeChildren(this.getType());
        this.getType().appendChild((Node)element);
    }

    @Override
    public void setupConstraintComponent(DataTypeConstraint dataTypeConstraintComponent) {
        RemoveHelper.removeChildren(this.getConstraintContainer());
        this.getConstraintContainer().appendChild((Node)dataTypeConstraintComponent.getElement());
    }

    @Override
    public void setupListComponent(SmallSwitchComponent dataTypeListComponent) {
        RemoveHelper.removeChildren(this.getListCheckBoxContainer());
        this.getListCheckBoxContainer().appendChild((Node)dataTypeListComponent.getElement());
    }

    @Override
    public void showListContainer() {
        HiddenHelper.show(this.getListContainer());
    }

    @Override
    public void hideListContainer() {
        HiddenHelper.hide(this.getListContainer());
    }

    @Override
    public void showListYesLabel() {
        HiddenHelper.show(this.getListYes());
    }

    @Override
    public void hideListYesLabel() {
        HiddenHelper.hide(this.getListYes());
    }

    @Override
    public boolean isCollapsed() {
        return this.isCollapsed(this.getArrow());
    }

    Element getRowElement(DataType dataType) {
        return this.getRowElement(dataType.getUUID());
    }

    boolean isCollapsed(Element arrow) {
        return ListItemViewCssHelper.isRightArrow(arrow);
    }

    private void forEachChildElement(Element parent, Consumer<Element> consumer) {
        this.forEachChildElement(parent, (Element element) -> {
            consumer.accept((Element)element);
            return true;
        });
    }

    private void forEachChildElement(Element parent, Function<Element, Boolean> consumer) {
        NodeList<Element> children = this.getChildren(parent);
        for (int i = 0; i < children.length; ++i) {
            Element child = (Element)children.getAt(i);
            if (!consumer.apply(child).booleanValue()) continue;
            this.forEachChildElement(child, consumer);
        }
    }

    private Element getRowElement(String uuid) {
        return this.getDragAndDropListElement().querySelector("[data-row-uuid=\"" + uuid + "\"]");
    }

    private NodeList<Element> getChildren(Element parent) {
        String childrenSelector = "[data-parent-row-uuid=\"" + parent.getAttribute(UUID_ATTR) + "\"]";
        return this.getDragAndDropListElement().querySelectorAll(childrenSelector);
    }

    DataType getDataType() {
        return this.presenter.getDataType();
    }

    @Override
    public void setDataType(DataType dataType) {
        this.setupRowMetadata(dataType);
        this.setupArrow(dataType);
        this.setupReadOnly(dataType);
        this.setupActionButtons();
        this.setupEventHandlers();
        this.setupShortcutsTooltips();
    }

    void setupShortcutsTooltips() {
        String arrowKeysTooltip = this.translationService.format("DataTypeListItemView.ArrowKeysTooltip", new Object[0]);
        this.setTitleAttribute(this.getEditButton(), this.translationService.format("DataTypeListItemView.Edit", new Object[0]));
        this.setTitleAttribute(this.getSaveButton(), this.translationService.format("DataTypeListItemView.Save", new Object[0]));
        this.setTitleAttribute(this.getAddDataTypeRowButton(), this.translationService.format("DataTypeListItemView.AddRowBelow", new Object[0]));
        this.setTitleAttribute(this.getRemoveButton(), this.translationService.format("DataTypeListItemView.Remove", new Object[0]));
        this.setTitleAttribute(this.getCloseButton(), this.translationService.format("DataTypeListItemView.Cancel", new Object[0]));
        this.setTitleAttribute(this.getArrow(), arrowKeysTooltip);
        this.setupTooltips();
    }

    private void setTitleAttribute(Element element, String value) {
        String attribute = "data-title";
        element.setAttribute("data-title", value);
    }

    void setupTooltips() {
        JQueryTooltip.$((NodeList<Element>)this.getElement().querySelectorAll("[data-toggle='tooltip']")).tooltip();
    }

    void setupEventHandlers() {
        this.getEditButton().onclick = this.getOnEditAction();
        this.getSaveButton().onclick = this.getOnSaveAction();
        this.getCloseButton().onclick = this.getOnCloseAction();
        this.getArrow().onclick = this.getOnArrowClickAction();
        this.getAddDataTypeRowButton().onclick = this.getOnAddDataTypeRowAction();
        this.getRemoveButton().onclick = this.getOnRemoveButtonAction();
    }

    private HTMLElement getDragAndDropListElement() {
        return this.presenter.getDragAndDropListElement();
    }

    private HTMLElement getDragAndDropElement() {
        return this.presenter.getDragAndDropElement();
    }

    Element.OnclickFn getOnEditAction() {
        return e -> {
            this.presenter.enableEditMode();
            return true;
        };
    }

    Element.OnclickFn getOnSaveAction() {
        return e -> {
            this.presenter.saveAndCloseEditMode();
            return true;
        };
    }

    Element.OnclickFn getOnCloseAction() {
        return e -> {
            this.presenter.disableEditMode();
            return true;
        };
    }

    Element.OnclickFn getOnArrowClickAction() {
        return e -> {
            this.presenter.expandOrCollapseSubTypes();
            return true;
        };
    }

    Element.OnclickFn getOnAddDataTypeRowAction() {
        return e -> {
            this.presenter.addDataTypeRow();
            return true;
        };
    }

    Element.OnclickFn getOnRemoveButtonAction() {
        return e -> {
            this.presenter.remove();
            return true;
        };
    }

    Element getArrow() {
        return this.querySelector("arrow-button");
    }

    Element getNameText() {
        return this.querySelector("name-text");
    }

    HTMLInputElement getNameInput() {
        return (HTMLInputElement)this.querySelector(NAME_DATA_FIELD);
    }

    Element getType() {
        return this.querySelector("type");
    }

    Element getConstraintContainer() {
        return this.querySelector("constraint-container");
    }

    Element getListContainer() {
        return this.querySelector("list-container");
    }

    Element getListCheckBoxContainer() {
        return this.querySelector("list-checkbox-container");
    }

    Element getListYes() {
        return this.querySelector("list-yes");
    }

    Element getEditButton() {
        return this.querySelector("edit-button");
    }

    Element getSaveButton() {
        return this.querySelector("save-button");
    }

    Element getCloseButton() {
        return this.querySelector("close-button");
    }

    Element getRemoveButton() {
        return this.querySelector("remove-button");
    }

    Element getAddDataTypeRowButton() {
        return this.querySelector("add-data-type-row-button");
    }

    NodeList<Element> getLabels() {
        return this.getElement().querySelectorAll(".data-type-label");
    }

    Element querySelector(String fieldName) {
        return this.getElement().querySelector("[data-type-field=\"" + fieldName + "\"]");
    }
}

