/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview.common;

import com.google.gwt.event.dom.client.ChangeEvent;
import elemental2.dom.HTMLInputElement;
import java.util.Objects;
import java.util.function.Consumer;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.dmn.client.editors.types.listview.common.SmallSwitchComponent;

@Dependent
@Templated
public class SmallSwitchComponentView
implements SmallSwitchComponent.View {
    @DataField(value="input-checkbox")
    private final HTMLInputElement inputCheckbox;
    private SmallSwitchComponent presenter;
    private Consumer<Boolean> onValueChanged;

    @Inject
    public SmallSwitchComponentView(HTMLInputElement inputCheckbox) {
        this.inputCheckbox = inputCheckbox;
    }

    public void init(SmallSwitchComponent presenter) {
        this.presenter = presenter;
    }

    @EventHandler(value={"input-checkbox"})
    public void onInputCheckBoxChange(ChangeEvent e) {
        this.callOnValueChanged();
    }

    void callOnValueChanged() {
        if (!Objects.isNull(this.onValueChanged)) {
            this.onValueChanged.accept(this.isChecked());
        }
    }

    @Override
    public boolean getValue() {
        return this.isChecked();
    }

    @Override
    public void setValue(boolean value) {
        this.inputCheckbox.checked = value;
    }

    @Override
    public void setOnValueChanged(Consumer<Boolean> onValueChanged) {
        this.onValueChanged = onValueChanged;
    }

    private boolean isChecked() {
        return this.inputCheckbox.checked;
    }
}

