/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview.constraint;

import com.google.gwt.event.dom.client.ClickEvent;
import elemental2.dom.Element;
import elemental2.dom.HTMLAnchorElement;
import elemental2.dom.HTMLButtonElement;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLElement;
import elemental2.dom.Node;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.dmn.api.definition.model.ConstraintType;
import org.kie.workbench.common.dmn.client.editors.common.RemoveHelper;
import org.kie.workbench.common.dmn.client.editors.types.common.HiddenHelper;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.DataTypeConstraintModal;
import org.kie.workbench.common.stunner.core.util.StringUtils;
import org.uberfire.client.views.pfly.selectpicker.JQuery;
import org.uberfire.client.views.pfly.selectpicker.JQuerySelectPicker;
import org.uberfire.client.views.pfly.selectpicker.JQuerySelectPickerEvent;
import org.uberfire.mvp.Command;

@Templated
@Dependent
public class DataTypeConstraintModalView
implements DataTypeConstraintModal.View {
    private static final String DISABLED_CLASS = "disabled";
    @DataField(value="header")
    private final HTMLDivElement header;
    @DataField(value="body")
    private final HTMLDivElement body;
    @DataField(value="footer")
    private final HTMLDivElement footer;
    @DataField(value="constraint-component-container")
    private final HTMLDivElement componentContainer;
    @DataField(value="ok-button")
    private final HTMLButtonElement okButton;
    @DataField(value="cancel-button")
    private final HTMLButtonElement cancelButton;
    @DataField(value="clear-all-anchor")
    private final HTMLAnchorElement clearAllAnchor;
    @DataField(value="type")
    private final HTMLElement type;
    @DataField(value="select-constraint")
    private final HTMLDivElement selectConstraint;
    @DataField(value="constraint-warning-message")
    private final HTMLDivElement constraintWarningMessage;
    @DataField(value="close-constraint-warning-message")
    private final HTMLButtonElement closeConstraintWarningMessage;
    private DataTypeConstraintModal presenter;

    @Inject
    public DataTypeConstraintModalView(HTMLDivElement header, HTMLDivElement body, HTMLDivElement footer, HTMLDivElement componentContainer, HTMLButtonElement okButton, HTMLButtonElement cancelButton, HTMLAnchorElement clearAllAnchor, @Named(value="span") HTMLElement type, HTMLDivElement selectConstraint, HTMLDivElement constraintWarningMessage, HTMLButtonElement closeConstraintWarningMessage) {
        this.header = header;
        this.body = body;
        this.footer = footer;
        this.componentContainer = componentContainer;
        this.okButton = okButton;
        this.cancelButton = cancelButton;
        this.clearAllAnchor = clearAllAnchor;
        this.type = type;
        this.selectConstraint = selectConstraint;
        this.constraintWarningMessage = constraintWarningMessage;
        this.closeConstraintWarningMessage = closeConstraintWarningMessage;
    }

    @PostConstruct
    public void init() {
        this.setupSelectPicker();
        this.setupSelectPickerOnChangeHandler();
        this.setupEmptyContainer();
    }

    public void init(DataTypeConstraintModal presenter) {
        this.presenter = presenter;
    }

    public String getHeader() {
        return this.header.textContent;
    }

    public HTMLElement getBody() {
        return this.body;
    }

    public HTMLElement getFooter() {
        return this.footer;
    }

    @EventHandler(value={"ok-button"})
    public void onOkButtonClick(ClickEvent e) {
        this.presenter.save();
    }

    @EventHandler(value={"cancel-button"})
    public void onCancelButtonClick(ClickEvent e) {
        this.presenter.hide();
    }

    @EventHandler(value={"clear-all-anchor"})
    public void onClearAllAnchorClick(ClickEvent e) {
        this.presenter.clearAll();
    }

    @EventHandler(value={"close-constraint-warning-message"})
    public void onCloseConstraintWarningClick(ClickEvent e) {
        HiddenHelper.hide((Element)this.constraintWarningMessage);
    }

    @Override
    public void showConstraintWarningMessage() {
        HiddenHelper.show((Element)this.constraintWarningMessage);
    }

    @Override
    public void setType(String type) {
        this.type.textContent = type;
    }

    void onSelectChange(JQuerySelectPickerEvent event) {
        String constraintType = event.target.value;
        if (!StringUtils.isEmpty((String)constraintType)) {
            ConstraintType constraint = ConstraintType.fromString((String)constraintType);
            this.loadComponent(constraint);
            this.presenter.setConstraintType(constraint);
        }
    }

    @Override
    public void setupEmptyContainer() {
        RemoveHelper.removeChildren((Element)this.componentContainer);
        this.componentContainer.appendChild((Node)this.selectConstraint);
    }

    @Override
    public void loadComponent(ConstraintType constraintType) {
        this.presenter.setupComponent(constraintType);
        RemoveHelper.removeChildren((Element)this.componentContainer);
        this.componentContainer.appendChild((Node)this.presenter.getCurrentComponent().getElement());
    }

    @Override
    public void onShow() {
        this.setPickerValue(this.getSelectPicker(), this.getConstraintType());
    }

    @Override
    public void setupOnHideHandler(Command handler) {
        this.constraintModalJQuery().on("hidden.bs.modal", e -> handler.execute());
    }

    private Node getModalElement() {
        Node modalBody = this.getBody().parentNode;
        Node modalContent = modalBody.parentNode;
        Node modalDialog = modalContent.parentNode;
        Node modalComponent = modalDialog.parentNode;
        return modalComponent;
    }

    @Override
    public void enableOkButton() {
        this.okButton.classList.remove(new String[]{DISABLED_CLASS});
    }

    @Override
    public void disableOkButton() {
        this.okButton.classList.add(new String[]{DISABLED_CLASS});
    }

    private String getConstraintType() {
        if (this.presenter.getConstraintType() == null) {
            return this.presenter.inferComponentType(this.presenter.getConstraintValue()).value();
        }
        return this.presenter.getConstraintType().toString();
    }

    void setupSelectPicker() {
        this.triggerPickerAction(this.getSelectPicker(), "refresh");
    }

    void setupSelectPickerOnChangeHandler() {
        this.setupOnChangeHandler(this.getSelectPicker());
    }

    void setupOnChangeHandler(Element element) {
        JQuerySelectPicker.$((Element)element).on("hidden.bs.select", this::onSelectChange);
    }

    void setPickerValue(Element element, String value) {
        JQuerySelectPicker.$((Element)element).selectpicker("val", value);
    }

    Element getSelectPicker() {
        return this.body.querySelector(".selectpicker");
    }

    void triggerPickerAction(Element element, String method) {
        JQuerySelectPicker.$((Element)element).selectpicker(method);
    }

    JQuery constraintModalJQuery() {
        return JQuery.$((Node)this.getModalElement());
    }
}

