/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview.constraint;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONString;
import com.google.gwt.json.client.JSONValue;
import elemental2.dom.Element;
import elemental2.dom.HTMLAnchorElement;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLElement;
import java.util.Objects;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.dmn.client.editors.types.common.HiddenHelper;
import org.kie.workbench.common.dmn.client.editors.types.listview.common.JQueryTooltip;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.DataTypeConstraint;
import org.kie.workbench.common.stunner.core.util.StringUtils;

@Templated
@Dependent
public class DataTypeConstraintView
implements DataTypeConstraint.View {
    @DataField(value="constraints-anchor-container")
    private final HTMLAnchorElement constraintsAnchorContainer;
    @DataField(value="constraints-label-container")
    private final HTMLDivElement constraintsLabelContainer;
    @DataField(value="constraints-anchor-text")
    private final HTMLElement constraintsAnchorText;
    @DataField(value="constraints-label-text")
    private final HTMLElement constraintsLabelText;
    @DataField(value="constraints-tooltip")
    private final HTMLElement constraintsTooltip;
    private final TranslationService translationService;
    private DataTypeConstraint presenter;

    @Inject
    public DataTypeConstraintView(HTMLAnchorElement constraintsAnchorContainer, HTMLDivElement constraintsLabelContainer, @Named(value="span") HTMLElement constraintsAnchorText, @Named(value="span") HTMLElement constraintsLabelText, @Named(value="span") HTMLElement constraintsTooltip, TranslationService translationService) {
        this.constraintsAnchorContainer = constraintsAnchorContainer;
        this.constraintsLabelContainer = constraintsLabelContainer;
        this.constraintsAnchorText = constraintsAnchorText;
        this.constraintsLabelText = constraintsLabelText;
        this.constraintsTooltip = constraintsTooltip;
        this.translationService = translationService;
    }

    public void init(DataTypeConstraint presenter) {
        this.presenter = presenter;
    }

    @PostConstruct
    public void setup() {
        this.constraintsTooltip.setAttribute("title", this.translationService.format("DataTypeConstraintView.ConstraintsTooltip", new Object[0]));
        this.setupTooltip(this.properties().getJavaScriptObject());
    }

    @EventHandler(value={"constraints-anchor-container"})
    public void onConstraintsClick(ClickEvent e) {
        this.presenter.openModal();
    }

    @Override
    public void showAnchor() {
        HiddenHelper.hide((Element)this.constraintsLabelContainer);
        HiddenHelper.show((Element)this.constraintsAnchorContainer);
        HiddenHelper.show((Element)this.constraintsTooltip);
    }

    @Override
    public void hideAnchor() {
        if (Objects.equals(this.constraintsLabelText.textContent, this.addConstraints())) {
            HiddenHelper.hide((Element)this.constraintsLabelContainer);
        } else {
            HiddenHelper.show((Element)this.constraintsLabelContainer);
        }
        HiddenHelper.hide((Element)this.constraintsAnchorContainer);
        HiddenHelper.hide((Element)this.constraintsTooltip);
    }

    @Override
    public void setText(String text) {
        String constraintText;
        String constraints = this.addConstraints();
        this.constraintsAnchorText.textContent = constraintText = StringUtils.isEmpty((String)text) ? constraints : text;
        this.constraintsLabelText.textContent = constraintText;
    }

    @Override
    public void enable() {
        HiddenHelper.show((Element)this.getElement());
    }

    @Override
    public void disable() {
        HiddenHelper.hide((Element)this.getElement());
    }

    void setupTooltip(JavaScriptObject javaScriptObject) {
        JQueryTooltip.$((Element)this.constraintsTooltip).tooltip(javaScriptObject);
    }

    JSONObject properties() {
        JSONObject jsonObject = this.makeJsonObject();
        jsonObject.put("container", (JSONValue)new JSONString("body"));
        return jsonObject;
    }

    JSONObject makeJsonObject() {
        return new JSONObject();
    }

    private String addConstraints() {
        return this.translationService.format("DataTypeConstraintView.AddConstraints", new Object[0]);
    }
}

