/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.time;

import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.ClickEvent;
import elemental2.dom.Element;
import elemental2.dom.Event;
import elemental2.dom.HTMLButtonElement;
import elemental2.dom.HTMLElement;
import elemental2.dom.HTMLInputElement;
import elemental2.dom.HTMLOptionElement;
import elemental2.dom.HTMLSelectElement;
import elemental2.dom.Node;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.dmn.api.editors.types.DMNSimpleTimeZone;
import org.kie.workbench.common.dmn.client.editors.common.RemoveHelper;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.time.TimeSelector;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.time.picker.TimePicker;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.time.picker.TimeValue;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.time.picker.TimeValueFormatter;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.time.picker.TimeZoneProvider;
import org.kie.workbench.common.stunner.core.client.i18n.ClientTranslationService;
import org.uberfire.client.views.pfly.selectpicker.JQuerySelectPicker;
import org.uberfire.client.views.pfly.selectpicker.JQuerySelectPickerEvent;

@Templated
@Dependent
public class TimeSelectorView
implements TimeSelector.View {
    @DataField(value="toggle-timezone-button")
    private final HTMLButtonElement toggleTimeZoneButton;
    @DataField(value="toggle-timezone-icon")
    private final HTMLElement toggleTimeZoneIcon;
    @DataField(value="time-input")
    private HTMLInputElement timeInput;
    @DataField(value="time-zone-selector")
    private final HTMLSelectElement timeZoneSelector;
    @DataField(value="time-zone-select-option")
    private final HTMLOptionElement typeSelectOption;
    static final String NONE_TRANSLATION_KEY = "TimeSelectorView.None";
    static final String TIMEZONE_CLASS_ICON = "fa-globe";
    static final String OFFSET_CLASS_ICON = "fa-clock-o";
    static final String NONE_VALUE = "None";
    private final TimeZoneProvider timeZoneProvider;
    private final ClientTranslationService translationService;
    private final List<DMNSimpleTimeZone> timeZones;
    private final TimePicker picker;
    private final TimeValueFormatter formatter;
    private TimeSelectorView presenter;
    private Consumer<BlurEvent> onValueInputBlur;
    private boolean isOffsetMode;
    private String timeZoneSelectedValue;

    @Inject
    public TimeSelectorView(HTMLInputElement timeInput, TimePicker picker, TimeZoneProvider timeZoneProvider, TimeValueFormatter formatter, @Named(value="i") HTMLElement toggleTimeZoneIcon, HTMLButtonElement toggleTimeZoneButton, ClientTranslationService translationService, HTMLSelectElement timeZoneSelector, HTMLOptionElement typeSelectOption) {
        this.timeInput = timeInput;
        this.picker = picker;
        this.timeZoneProvider = timeZoneProvider;
        this.formatter = formatter;
        this.toggleTimeZoneIcon = toggleTimeZoneIcon;
        this.toggleTimeZoneButton = toggleTimeZoneButton;
        this.timeZones = new ArrayList<DMNSimpleTimeZone>();
        this.translationService = translationService;
        this.typeSelectOption = typeSelectOption;
        this.isOffsetMode = false;
        this.timeZoneSelector = timeZoneSelector;
        this.timeZoneSelector.setAttribute("data-container", "body");
    }

    void timeZoneSelectorRefresh() {
        this.triggerPickerAction(this.getSelectPicker(), "refresh");
        this.showSelectPicker();
    }

    void showSelectPicker() {
        this.triggerPickerAction(this.getSelectPicker(), "show");
    }

    Element getSelectPicker() {
        return this.timeZoneSelector;
    }

    void triggerPickerAction(Element element, String method) {
        JQuerySelectPicker.$((Element)element).selectpicker(method);
    }

    String getTimeZoneSelectedValue() {
        return this.timeZoneSelectedValue;
    }

    @PostConstruct
    void init() {
        this.picker.bind(this.timeInput);
        this.timeZoneProvider.getTimeZones(this::timeZoneProviderSuccessCallBack);
    }

    private void timeZoneProviderSuccessCallBack(List<DMNSimpleTimeZone> timeZones) {
        this.timeZones.clear();
        this.timeZones.addAll(timeZones);
        this.setupOnChangeHandler(this.getSelectPicker());
        this.populateTimeZoneSelectorWithIds();
    }

    boolean getIsOffsetMode() {
        return this.isOffsetMode;
    }

    List<DMNSimpleTimeZone> getTimeZones() {
        return this.timeZones;
    }

    void populateTimeZoneSelectorWithIds() {
        RemoveHelper.removeChildren((Element)this.timeZoneSelector);
        this.timeZoneSelector.appendChild((Node)this.createNoneOption());
        for (int i = 0; i < this.getTimeZones().size(); ++i) {
            DMNSimpleTimeZone timeZone = this.getTimeZones().get(i);
            HTMLOptionElement option = this.createOptionWithId(timeZone);
            this.timeZoneSelector.appendChild((Node)option);
        }
        this.setPickerValue(this.getSelectPicker(), this.getTimeZoneSelectedValue());
        this.timeZoneSelectorRefresh();
    }

    HTMLOptionElement createOptionWithId(DMNSimpleTimeZone timeZone) {
        String timeZoneId = timeZone.getId();
        HTMLOptionElement option = this.getNewOption();
        option.value = timeZoneId;
        option.text = timeZoneId;
        return option;
    }

    void populateTimeZoneSelectorWithOffSets() {
        List<String> offSets = this.timeZoneProvider.getTimeZonesOffsets();
        RemoveHelper.removeChildren((Element)this.timeZoneSelector);
        this.timeZoneSelector.appendChild((Node)this.createNoneOption());
        for (int i = 0; i < offSets.size(); ++i) {
            HTMLOptionElement option = this.createOptionWithOffset(offSets.get(i));
            this.timeZoneSelector.appendChild((Node)option);
        }
        this.setPickerValue(this.getSelectPicker(), this.getTimeZoneSelectedValue());
        this.timeZoneSelectorRefresh();
    }

    HTMLOptionElement createOptionWithOffset(String timeZoneOffSet) {
        HTMLOptionElement option = this.getNewOption();
        option.value = timeZoneOffSet;
        option.text = timeZoneOffSet;
        return option;
    }

    HTMLOptionElement getNewOption() {
        return (HTMLOptionElement)this.typeSelectOption.cloneNode(false);
    }

    HTMLOptionElement createNoneOption() {
        HTMLOptionElement none = this.getNewOption();
        none.text = this.translationService.getValue(NONE_TRANSLATION_KEY);
        none.value = NONE_VALUE;
        return none;
    }

    void setPickerValue(Element element, String value) {
        JQuerySelectPicker.$((Element)element).selectpicker("val", value);
    }

    void setupOnChangeHandler(Element element) {
        JQuerySelectPicker.$((Element)element).on("hidden.bs.select", this::onSelectChange);
    }

    public void onSelectChange(JQuerySelectPickerEvent event) {
        String newValue = event.target.value;
        if (!Objects.equals(newValue, this.getValue())) {
            this.setPickerValue(newValue);
        }
    }

    void setPickerValue(String value) {
        this.setPickerValue(this.getSelectPicker(), value);
        this.timeZoneSelectedValue = value;
    }

    @Override
    public String getValue() {
        String time = this.picker.getValue();
        String timeZoneValue = !Objects.isNull(this.getTimeZoneSelectedValue()) ? (NONE_VALUE.equals(this.getTimeZoneSelectedValue()) ? "" : this.getTimeZoneSelectedValue()) : "";
        return this.formatter.buildRawValue(time, timeZoneValue);
    }

    @Override
    public void setValue(String value) {
        TimeValue timeValue = this.formatter.getTimeValue(value);
        this.picker.setValue(timeValue.getTime());
        switch (timeValue.getTimeZoneMode()) {
            case OFFSET: {
                this.setIsOffsetMode(true);
                this.refreshTimeZoneOffsetMode(timeValue);
                break;
            }
            case TIMEZONE: {
                this.setIsOffsetMode(false);
                this.refreshTimeZoneOffsetMode(timeValue);
                break;
            }
            case NONE: {
                this.setPickerValue("");
            }
        }
    }

    void setIsOffsetMode(boolean isOffsetMode) {
        this.isOffsetMode = isOffsetMode;
    }

    void refreshTimeZoneOffsetMode(TimeValue timeValue) {
        this.refreshToggleTimeZoneIcon();
        this.reloadTimeZoneSelector();
        this.setPickerValue(timeValue.getTimeZoneValue());
    }

    @Override
    public void setPlaceholder(String placeholder) {
        this.timeInput.setAttribute("placeholder", placeholder);
    }

    @Override
    public void setOnInputChangeCallback(Consumer<Event> onValueChanged) {
        this.timeInput.onchange = event -> {
            onValueChanged.accept(event);
            return this;
        };
        this.picker.setOnDateChanged(v -> onValueChanged.accept(null));
    }

    @Override
    public void select() {
        this.timeInput.select();
    }

    @Override
    public void setOnInputBlurCallback(Consumer<BlurEvent> onValueInputBlur) {
        this.onValueInputBlur = onValueInputBlur;
    }

    Consumer<BlurEvent> getOnValueInputBlur() {
        return this.onValueInputBlur;
    }

    Object getEventTarget(BlurEvent blurEvent) {
        return blurEvent.getNativeEvent().getRelatedEventTarget();
    }

    @EventHandler(value={"time-input"})
    public void onTimeInputBlur(BlurEvent blurEvent) {
        this.onBlur(blurEvent);
    }

    private void onBlur(BlurEvent blurEvent) {
        Object target = this.getEventTarget(blurEvent);
        if (!(Objects.isNull(this.getOnValueInputBlur()) || Objects.isNull(target) || this.isChildOfView(target))) {
            this.getOnValueInputBlur().accept(blurEvent);
        }
    }

    @EventHandler(value={"toggle-timezone-button"})
    public void onToggleTimeZoneButtonClick(ClickEvent clickEvent) {
        this.setIsOffsetMode(!this.getIsOffsetMode());
        this.refreshToggleTimeZoneIcon();
        this.reloadTimeZoneSelector();
    }

    void reloadTimeZoneSelector() {
        if (this.getIsOffsetMode()) {
            this.populateTimeZoneSelectorWithOffSets();
        } else {
            this.populateTimeZoneSelectorWithIds();
        }
    }

    void refreshToggleTimeZoneIcon() {
        if (this.getIsOffsetMode()) {
            this.toggleTimeZoneIcon.classList.remove(new String[]{TIMEZONE_CLASS_ICON});
            this.toggleTimeZoneIcon.classList.add(new String[]{OFFSET_CLASS_ICON});
        } else {
            this.toggleTimeZoneIcon.classList.add(new String[]{TIMEZONE_CLASS_ICON});
            this.toggleTimeZoneIcon.classList.remove(new String[]{OFFSET_CLASS_ICON});
        }
    }

    @Override
    public boolean isChildOfView(Object element) {
        HTMLElement viewElement = this.getElement();
        return viewElement.contains((Node)((Element)element));
    }

    public void init(TimeSelectorView presenter) {
        this.presenter = presenter;
    }
}

