/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview.constraint.range;

import elemental2.dom.Element;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLInputElement;
import elemental2.dom.Node;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.dmn.client.editors.common.RemoveHelper;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.TypedValueComponentSelector;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.TypedValueSelector;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.range.DataTypeConstraintRange;
import org.kie.workbench.common.stunner.core.util.StringUtils;

@Templated
@Dependent
public class DataTypeConstraintRangeView
implements DataTypeConstraintRange.View {
    private final TypedValueComponentSelector startValueComponentSelector;
    private final TypedValueComponentSelector endValueComponentSelector;
    private TypedValueSelector startValueComponent;
    private TypedValueSelector endValueComponent;
    private DataTypeConstraintRange presenter;
    @DataField(value="end-value-container")
    private final HTMLDivElement endValueContainer;
    @DataField(value="start-value-container")
    private final HTMLDivElement startValueContainer;
    @DataField(value="include-end-value")
    private final HTMLInputElement includeEndValue;
    @DataField(value="include-start-value")
    private final HTMLInputElement includeStartValue;

    @Inject
    public DataTypeConstraintRangeView(HTMLDivElement startValueContainer, HTMLDivElement endValueContainer, HTMLInputElement includeStartValue, HTMLInputElement includeEndValue, TypedValueComponentSelector startValueComponentSelector, TypedValueComponentSelector endValueComponentSelector) {
        this.startValueComponentSelector = startValueComponentSelector;
        this.endValueComponentSelector = endValueComponentSelector;
        this.startValueContainer = startValueContainer;
        this.endValueContainer = endValueContainer;
        this.includeStartValue = includeStartValue;
        this.includeEndValue = includeEndValue;
    }

    public void init(DataTypeConstraintRange presenter) {
        this.presenter = presenter;
    }

    void setupInputFields() {
        this.startValueComponent.setOnInputChangeCallback(this::onValueChanged);
        this.endValueComponent.setOnInputChangeCallback(this::onValueChanged);
    }

    @Override
    public String getStartValue() {
        return this.startValueComponent.getValue();
    }

    @Override
    public String getEndValue() {
        return this.endValueComponent.getValue();
    }

    @Override
    public void setStartValue(String value) {
        this.startValueComponent.setValue(value);
    }

    @Override
    public void setEndValue(String value) {
        this.endValueComponent.setValue(value);
    }

    @Override
    public boolean getIncludeStartValue() {
        return this.includeStartValue.checked;
    }

    @Override
    public void setIncludeStartValue(boolean includeStartValue) {
        this.includeStartValue.checked = includeStartValue;
    }

    @Override
    public boolean getIncludeEndValue() {
        return this.includeEndValue.checked;
    }

    @Override
    public void setIncludeEndValue(boolean includeEndValue) {
        this.includeEndValue.checked = includeEndValue;
    }

    @Override
    public void setPlaceholders(String placeholder) {
        this.startValueComponent.setPlaceholder(placeholder);
        this.endValueComponent.setPlaceholder(placeholder);
    }

    @Override
    public void setComponentSelector(String type) {
        this.startValueComponent = this.startValueComponentSelector.makeSelectorForType(type);
        RemoveHelper.removeChildren((Element)this.startValueContainer);
        this.startValueContainer.appendChild((Node)this.startValueComponent.getElement());
        this.endValueComponent = this.endValueComponentSelector.makeSelectorForType(type);
        RemoveHelper.removeChildren((Element)this.endValueContainer);
        this.endValueContainer.appendChild((Node)this.endValueComponent.getElement());
        this.setupInputFields();
    }

    void onValueChanged(Object event) {
        if (StringUtils.isEmpty((String)this.startValueComponent.getValue()) || StringUtils.isEmpty((String)this.endValueComponent.getValue())) {
            this.presenter.disableOkButton();
        } else {
            this.presenter.enableOkButton();
        }
    }
}

