/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview.draganddrop;

import elemental2.dom.Element;
import elemental2.dom.NodeList;
import java.util.Objects;
import java.util.Optional;
import org.kie.workbench.common.dmn.client.editors.types.common.DataType;
import org.kie.workbench.common.dmn.client.editors.types.listview.draganddrop.DNDDataTypesHandler;
import org.kie.workbench.common.dmn.client.editors.types.listview.draganddrop.DNDDataTypesHandlerShiftStrategy;
import org.kie.workbench.common.dmn.client.editors.types.listview.draganddrop.DNDListDOMHelper;

class DNDDataTypesHandlerContext {
    private final Element currentElement;
    private final Element hoverElement;
    private DNDDataTypesHandler dndDataTypesHandler;
    private Element previousElement;
    private DataType current;
    private DataType hovered;
    private DataType previous;

    DNDDataTypesHandlerContext(DNDDataTypesHandler dndDataTypesHandler, Element currentElement, Element hoverElement) {
        this.dndDataTypesHandler = dndDataTypesHandler;
        this.currentElement = currentElement;
        this.hoverElement = hoverElement;
        this.current = this.getDataType(currentElement);
    }

    Optional<DataType> getReference() {
        if (this.reloadHoveredDataType().isPresent() && this.hoveredDataTypeIsNotReadOnly()) {
            return this.getHoveredDataType();
        }
        if (this.reloadPreviousDataType().isPresent()) {
            return this.getPreviousDataType();
        }
        return this.getCurrentDataType().flatMap(this::getFirstDataType);
    }

    DNDDataTypesHandlerShiftStrategy getStrategy() {
        if (this.getHoveredDataType().isPresent() && this.hoveredDataTypeIsNotReadOnly()) {
            return DNDDataTypesHandlerShiftStrategy.INSERT_INTO_HOVERED_DATA_TYPE;
        }
        if (!this.getPreviousDataType().isPresent()) {
            return DNDDataTypesHandlerShiftStrategy.INSERT_TOP_LEVEL_DATA_TYPE_AT_THE_TOP;
        }
        int currentElementLevel = DNDListDOMHelper.Position.getX(this.currentElement);
        int previousElementLevel = DNDListDOMHelper.Position.getX(this.previousElement);
        if (currentElementLevel == 0) {
            return DNDDataTypesHandlerShiftStrategy.INSERT_TOP_LEVEL_DATA_TYPE;
        }
        if (previousElementLevel < currentElementLevel && this.previousDataTypeIsNotReadOnly()) {
            return DNDDataTypesHandlerShiftStrategy.INSERT_NESTED_DATA_TYPE;
        }
        return DNDDataTypesHandlerShiftStrategy.INSERT_SIBLING_DATA_TYPE;
    }

    private Optional<DataType> reloadHoveredDataType() {
        this.hovered = this.getDataType(this.hoverElement);
        return this.getHoveredDataType();
    }

    private Optional<DataType> reloadPreviousDataType() {
        this.previousElement = this.getPreviousElement(this.currentElement);
        this.previous = this.getDataType(this.previousElement);
        return this.getPreviousDataType();
    }

    private boolean previousDataTypeIsNotReadOnly() {
        return this.getPreviousDataType().map(DataType::isReadOnly).orElse(false) == false;
    }

    private boolean hoveredDataTypeIsNotReadOnly() {
        return this.getHoveredDataType().map(DataType::isReadOnly).orElse(false) == false;
    }

    Optional<DataType> getCurrentDataType() {
        return Optional.ofNullable(this.current);
    }

    private Optional<DataType> getHoveredDataType() {
        return Optional.ofNullable(this.hovered);
    }

    private Optional<DataType> getPreviousDataType() {
        return Optional.ofNullable(this.previous);
    }

    private DataType getDataType(Element element) {
        return element == null ? null : this.dndDataTypesHandler.getDataTypeStore().get(element.getAttribute("data-row-uuid"));
    }

    private Optional<DataType> getFirstDataType(DataType current) {
        NodeList nodes = this.dndDataTypesHandler.getDndListComponent().getDragArea().childNodes;
        for (int i = 0; i < nodes.length; ++i) {
            DataType dataType;
            Element element = (Element)nodes.getAt(i);
            Integer elementY = DNDListDOMHelper.Position.getY(element);
            Integer elementX = DNDListDOMHelper.Position.getX(element);
            if (elementY <= -1 || elementX != 0 || element.classList.contains("kie-dnd-current-dragging") || (dataType = this.getDataType(element)) == null || Objects.equals(current.getName(), dataType.getName())) continue;
            return Optional.of(dataType);
        }
        return Optional.empty();
    }

    private Element getPreviousElement(Element reference) {
        return this.dndDataTypesHandler.getDndListComponent().getPreviousElement(reference, element -> DNDListDOMHelper.Position.getX(element) <= DNDListDOMHelper.Position.getX(reference)).orElse(null);
    }
}

