/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.search;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyUpEvent;
import elemental2.dom.DomGlobal;
import elemental2.dom.Element;
import elemental2.dom.HTMLButtonElement;
import elemental2.dom.HTMLElement;
import elemental2.dom.HTMLInputElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.dmn.client.editors.types.common.DataType;
import org.kie.workbench.common.dmn.client.editors.types.common.HiddenHelper;
import org.kie.workbench.common.dmn.client.editors.types.listview.DataTypeListItem;
import org.kie.workbench.common.dmn.client.editors.types.search.DataTypeSearchBar;
import org.kie.workbench.common.stunner.core.util.StringUtils;

@Templated
@ApplicationScoped
public class DataTypeSearchBarView
implements DataTypeSearchBar.View {
    static final String ENABLED_SEARCH = "kie-search-engine-enabled";
    @DataField(value="search-bar")
    private final HTMLInputElement searchBar;
    @DataField(value="search-icon")
    private final HTMLElement searchIcon;
    @DataField(value="close-search")
    private final HTMLButtonElement closeSearch;
    private final TranslationService translationService;
    private DataTypeSearchBar presenter;

    @Inject
    public DataTypeSearchBarView(HTMLInputElement searchBar, @Named(value="span") HTMLElement searchIcon, HTMLButtonElement closeSearch, TranslationService translationService) {
        this.searchBar = searchBar;
        this.searchIcon = searchIcon;
        this.closeSearch = closeSearch;
        this.translationService = translationService;
    }

    @PostConstruct
    public void setupSearchBar() {
        this.searchBar.placeholder = this.translationService.format("DataTypeSearchBarView.Search", new Object[0]);
    }

    public void init(DataTypeSearchBar presenter) {
        this.presenter = presenter;
    }

    @EventHandler(value={"close-search"})
    public void onSearchBarCloseButton(ClickEvent e) {
        this.presenter.reset();
    }

    @EventHandler(value={"search-bar"})
    public void onSearchBarKeyUpEvent(KeyUpEvent event) {
        if (this.isEscape(event)) {
            this.presenter.reset();
        } else {
            this.search();
        }
    }

    @EventHandler(value={"search-bar"})
    public void onSearchBarKeyDownEvent(KeyDownEvent e) {
        this.refreshSearchBarState();
    }

    @EventHandler(value={"search-bar"})
    public void onSearchBarChangeEvent(ChangeEvent e) {
        this.refreshSearchBarState();
    }

    @Override
    public void resetSearchBar() {
        this.searchBar.value = "";
        this.refreshSearchBarState();
        this.disableSearch();
    }

    @Override
    public void showSearchResults(List<DataType> results) {
        AtomicInteger position = new AtomicInteger(0);
        List<DataTypeListItem> listItems = this.presenter.getDataTypeListItemsSortedByPositionY();
        this.expandListItems(listItems);
        List<DataTypeListItem> grouped = this.groupElementsWithItsParents(listItems);
        for (DataTypeListItem listItem : grouped) {
            HTMLElement element = listItem.getDragAndDropElement();
            if (results.contains(listItem.getDataType())) {
                this.showElementAt(element, position);
                continue;
            }
            this.hideElement(element);
        }
        this.refreshItemsPosition();
        this.enableSearch();
        this.refreshDragAreaSize();
    }

    void expandListItems(List<DataTypeListItem> listItems) {
        for (DataTypeListItem listItem : listItems) {
            listItem.expand();
        }
    }

    List<DataTypeListItem> groupElementsWithItsParents(List<DataTypeListItem> allElements) {
        List<DataTypeListItem> groupedElements = this.getGroupedElementsList();
        for (DataTypeListItem item : allElements) {
            this.groupElementWithItsParent(groupedElements, allElements, item);
        }
        return groupedElements;
    }

    List<DataTypeListItem> getGroupedElementsList() {
        return new ArrayList<DataTypeListItem>();
    }

    void groupElementWithItsParent(List<DataTypeListItem> groupedElements, List<DataTypeListItem> allElements, DataTypeListItem item) {
        if (groupedElements.contains(item)) {
            return;
        }
        String parentElementId = item.getDragAndDropElement().getAttribute("data-parent-row-uuid");
        if (!StringUtils.isEmpty((String)parentElementId)) {
            Optional<DataTypeListItem> parentElement = allElements.stream().filter(element -> Objects.equals(element.getDragAndDropElement().getAttribute("data-row-uuid"), parentElementId)).findFirst();
            parentElement.ifPresent(parent -> {
                if (!this.isParentElementOnList(groupedElements, parentElementId)) {
                    this.groupElementWithItsParent(groupedElements, allElements, (DataTypeListItem)parent);
                    groupedElements.add(item);
                } else {
                    int index = this.getIndexOfParentOrLastElementInGroup(groupedElements, (DataTypeListItem)parent) + 1;
                    if (index == groupedElements.size()) {
                        groupedElements.add(item);
                    } else {
                        groupedElements.add(index, item);
                    }
                }
            });
        } else {
            groupedElements.add(item);
        }
    }

    int getIndexOfParentOrLastElementInGroup(List<DataTypeListItem> groupedElements, DataTypeListItem parent) {
        int parentIndex = groupedElements.indexOf(parent);
        String parentId = parent.getDragAndDropElement().getAttribute("data-row-uuid");
        int index = parentIndex;
        for (int i = parentIndex; i < groupedElements.size(); ++i) {
            if (!Objects.equals(groupedElements.get(i).getDragAndDropElement().getAttribute("data-parent-row-uuid"), parentId)) continue;
            ++index;
        }
        return index;
    }

    boolean isParentElementOnList(List<DataTypeListItem> groupedElements, String parentId) {
        return groupedElements.stream().anyMatch(element -> Objects.equals(element.getDragAndDropElement().getAttribute("data-row-uuid"), parentId));
    }

    private void refreshDragAreaSize() {
        this.presenter.getDNDListComponent().refreshDragAreaSize();
    }

    public void refreshItemsPosition() {
        this.presenter.getDNDListComponent().refreshItemsPosition();
    }

    private void hideElement(HTMLElement element) {
        HiddenHelper.hide((Element)element);
        this.presenter.getDNDListComponent().setPositionY((Element)element, -1.0);
    }

    private void showElementAt(HTMLElement element, AtomicInteger position) {
        HiddenHelper.show((Element)element);
        this.presenter.getDNDListComponent().setPositionY((Element)element, position.getAndIncrement());
    }

    void enableSearch() {
        this.getResultsContainer().classList.add(new String[]{ENABLED_SEARCH});
    }

    void disableSearch() {
        this.getResultsContainer().classList.remove(new String[]{ENABLED_SEARCH});
    }

    void search() {
        String currentValue = this.searchBar.value;
        this.setTimeout(type -> {
            if (Objects.equals(this.searchBar.value, currentValue)) {
                this.presenter.search(currentValue);
            }
        }, 500.0);
    }

    void refreshSearchBarState() {
        boolean isActive = !StringUtils.isEmpty((String)this.searchBar.value);
        this.searchBarActive(isActive);
    }

    private void searchBarActive(boolean isActive) {
        if (isActive) {
            HiddenHelper.hide((Element)this.searchIcon);
            HiddenHelper.show((Element)this.closeSearch);
        } else {
            HiddenHelper.show((Element)this.searchIcon);
            HiddenHelper.hide((Element)this.closeSearch);
        }
    }

    void setTimeout(DomGlobal.SetTimeoutCallbackFn callback, double delay) {
        DomGlobal.setTimeout((DomGlobal.SetTimeoutCallbackFn)callback, (double)delay, (Object[])new Object[0]);
    }

    private boolean isEscape(KeyUpEvent event) {
        return Objects.equals(event.getNativeKeyCode(), 27);
    }

    private Element getResultsContainer() {
        return this.presenter.getResultsContainer();
    }
}

