/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.kie.workbench.common.dmn.client.editors.types.common.DataType;
import org.kie.workbench.common.dmn.client.editors.types.persistence.DataTypeStore;

@ApplicationScoped
public class DataTypeSearchEngine {
    private final DataTypeStore dataTypeStore;

    @Inject
    public DataTypeSearchEngine(DataTypeStore dataTypeStore) {
        this.dataTypeStore = dataTypeStore;
    }

    public List<DataType> search(String keyword) {
        ArrayList<DataType> results = new ArrayList<DataType>();
        for (DataType dataType : this.findByName(keyword)) {
            results.addAll(this.getStack(dataType));
        }
        return results;
    }

    private List<DataType> getStack(DataType dataType) {
        return this.getStack(new ArrayList<DataType>(), dataType);
    }

    private List<DataType> getStack(List<DataType> stack, DataType dataType) {
        DataType parent = this.parent(dataType);
        stack.add(dataType);
        if (dataType.isTopLevel() || Objects.isNull(parent)) {
            return stack;
        }
        return this.getStack(stack, parent);
    }

    private DataType parent(DataType dataType) {
        return this.dataTypeStore.get(dataType.getParentUUID());
    }

    private List<DataType> findByName(String keyword) {
        String keywordUpCase = this.upCase(keyword);
        if (keywordUpCase.isEmpty()) {
            return Collections.emptyList();
        }
        return this.dataTypeStore.all().stream().filter(dataType -> this.upCase(dataType.getName()).contains(keywordUpCase)).collect(Collectors.toList());
    }

    private String upCase(String value) {
        return Objects.isNull(value) ? "" : value.toUpperCase();
    }
}

