/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.marshaller.common;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmndi12.JSIDMNDiagram;
import org.kie.workbench.common.stunner.core.util.StringUtils;
import org.kie.workbench.common.stunner.core.util.UUID;

public class IdUtils {
    private static String SEPARATOR_DELIMITER = "#";
    private static String COMBINER_DELIMITER = "-";

    public static String getPrefixedId(String prefixId, String rawId) {
        return Stream.of(prefixId, rawId).filter(s -> !StringUtils.isEmpty((String)s)).collect(Collectors.joining(SEPARATOR_DELIMITER));
    }

    public static String getRawId(String prefixedId) {
        if (StringUtils.isEmpty((String)prefixedId)) {
            return "";
        }
        String[] parts = prefixedId.split(SEPARATOR_DELIMITER);
        switch (parts.length) {
            case 1: {
                return parts[0];
            }
            case 2: {
                return parts[1];
            }
        }
        return "";
    }

    public static String getComposedId(String ... parts) {
        return Stream.of(parts).filter(s -> !StringUtils.isEmpty((String)s)).map(s -> s.trim().replaceAll("\\s+", COMBINER_DELIMITER)).collect(Collectors.joining(COMBINER_DELIMITER));
    }

    public static String getShapeId(JSIDMNDiagram diagram, List<String> dmnElementIds, String dmnElementId) {
        String diagramName = IdUtils.lower(diagram.getName());
        return IdUtils.getUniqueId("dmnshape", diagramName, dmnElementId, 1, dmnElementIds);
    }

    public static String getEdgeId(JSIDMNDiagram diagram, List<String> dmnElementIds, String dmnElementId) {
        String diagramName = IdUtils.lower(diagram.getName());
        return IdUtils.getUniqueId("dmnedge", diagramName, dmnElementId, 1, dmnElementIds);
    }

    private static String getUniqueId(String prefix, String diagramName, String dmnElementId, int seed, List<String> dmnElementIds) {
        String count = seed == 1 ? "" : Integer.toString(seed);
        String id = IdUtils.getComposedId(prefix, diagramName, count, dmnElementId);
        if (dmnElementIds.contains(id)) {
            return IdUtils.getUniqueId(prefix, diagramName, dmnElementId, seed + 1, dmnElementIds);
        }
        dmnElementIds.add(id);
        return id;
    }

    public static String uniqueId() {
        return UUID.uuid();
    }

    private static String lower(String s) {
        return s == null ? "" : s.toLowerCase();
    }
}

