/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.marshaller.converters;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import jsinterop.base.Js;
import org.kie.workbench.common.dmn.api.definition.HasComponentWidths;
import org.kie.workbench.common.dmn.api.definition.model.BusinessKnowledgeModel;
import org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.model.DRGElement;
import org.kie.workbench.common.dmn.api.definition.model.DecisionService;
import org.kie.workbench.common.dmn.api.definition.model.FunctionDefinition;
import org.kie.workbench.common.dmn.api.definition.model.InformationItemPrimary;
import org.kie.workbench.common.dmn.api.definition.model.KnowledgeRequirement;
import org.kie.workbench.common.dmn.api.definition.model.KnowledgeSource;
import org.kie.workbench.common.dmn.api.property.background.BackgroundSet;
import org.kie.workbench.common.dmn.api.property.dimensions.GeneralRectangleDimensionsSet;
import org.kie.workbench.common.dmn.api.property.dmn.Description;
import org.kie.workbench.common.dmn.api.property.dmn.Id;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.api.property.font.FontSet;
import org.kie.workbench.common.dmn.client.marshaller.common.IdUtils;
import org.kie.workbench.common.dmn.client.marshaller.converters.DMNExternalLinksToExtensionElements;
import org.kie.workbench.common.dmn.client.marshaller.converters.DescriptionPropertyConverter;
import org.kie.workbench.common.dmn.client.marshaller.converters.FunctionDefinitionPropertyConverter;
import org.kie.workbench.common.dmn.client.marshaller.converters.HrefBuilder;
import org.kie.workbench.common.dmn.client.marshaller.converters.IdPropertyConverter;
import org.kie.workbench.common.dmn.client.marshaller.converters.InformationItemPrimaryPropertyConverter;
import org.kie.workbench.common.dmn.client.marshaller.converters.NodeConverter;
import org.kie.workbench.common.dmn.client.marshaller.unmarshall.nodes.NodeEntry;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITAuthorityRequirement;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITBusinessKnowledgeModel;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITDMNElementReference;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITDRGElement;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITFunctionDefinition;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITInformationItem;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITKnowledgeRequirement;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.kie.JSITComponentWidths;
import org.kie.workbench.common.stunner.core.api.FactoryManager;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableAdapterUtils;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;

public class BusinessKnowledgeModelConverter
implements NodeConverter<JSITBusinessKnowledgeModel, BusinessKnowledgeModel> {
    private FactoryManager factoryManager;

    public BusinessKnowledgeModelConverter(FactoryManager factoryManager) {
        this.factoryManager = factoryManager;
    }

    @Override
    public Node<View<BusinessKnowledgeModel>, ?> nodeFromDMN(NodeEntry nodeEntry) {
        JSITBusinessKnowledgeModel dmn = (JSITBusinessKnowledgeModel)Js.uncheckedCast((Object)nodeEntry.getDmnElement());
        Node node = this.factoryManager.newElement(nodeEntry.getId(), BindableAdapterUtils.getDefinitionId(BusinessKnowledgeModel.class)).asNode();
        Id id = IdPropertyConverter.wbFromDMN(dmn.getId());
        Description description = DescriptionPropertyConverter.wbFromDMN(dmn.getDescription());
        Name name = new Name(dmn.getName());
        InformationItemPrimary informationItem = InformationItemPrimaryPropertyConverter.wbFromDMN(dmn.getVariable(), dmn);
        JSITFunctionDefinition dmnFunctionDefinition = dmn.getEncapsulatedLogic();
        FunctionDefinition functionDefinition = FunctionDefinitionPropertyConverter.wbFromDMN(dmnFunctionDefinition, nodeEntry.getComponentWidthsConsumer());
        BusinessKnowledgeModel bkm = new BusinessKnowledgeModel(id, description, name, informationItem, functionDefinition, new BackgroundSet(), new FontSet(), new GeneralRectangleDimensionsSet());
        bkm.setDiagramId(nodeEntry.getDiagramId());
        ((View)node.getContent()).setDefinition((Object)bkm);
        if (Objects.nonNull(informationItem)) {
            informationItem.setParent((DMNModelInstrumentedBase)bkm);
        }
        if (Objects.nonNull(functionDefinition)) {
            functionDefinition.setParent((DMNModelInstrumentedBase)bkm);
        }
        if (Objects.nonNull(dmnFunctionDefinition)) {
            nodeEntry.getComponentWidthsConsumer().accept(dmnFunctionDefinition.getId(), (HasComponentWidths)functionDefinition);
        }
        DMNExternalLinksToExtensionElements.loadExternalLinksFromExtensionElements((JSITDRGElement)dmn, (DRGElement)bkm);
        return node;
    }

    @Override
    public JSITBusinessKnowledgeModel dmnFromNode(Node<View<BusinessKnowledgeModel>, ?> node, Consumer<JSITComponentWidths> componentWidthsConsumer) {
        String uuid;
        BusinessKnowledgeModel source = (BusinessKnowledgeModel)DefinitionUtils.getElementDefinition(node);
        JSITBusinessKnowledgeModel result = new JSITBusinessKnowledgeModel();
        result.setId(source.getId().getValue());
        Optional<String> description = Optional.ofNullable(DescriptionPropertyConverter.dmnFromWB(source.getDescription()));
        description.ifPresent(arg_0 -> ((JSITBusinessKnowledgeModel)result).setDescription(arg_0));
        result.setName(source.getName().getValue());
        if (Objects.isNull(result.getKnowledgeRequirement())) {
            result.setKnowledgeRequirement(new ArrayList());
        }
        if (Objects.isNull(result.getAuthorityRequirement())) {
            result.setAuthorityRequirement(new ArrayList());
        }
        DMNExternalLinksToExtensionElements.loadExternalLinksIntoExtensionElements((DRGElement)source, (JSITDRGElement)result);
        JSITInformationItem variable = InformationItemPrimaryPropertyConverter.dmnFromWB(source.getVariable(), (DMNModelInstrumentedBase)source);
        result.setVariable(variable);
        JSITFunctionDefinition functionDefinition = FunctionDefinitionPropertyConverter.dmnFromWB(source.getEncapsulatedLogic(), componentWidthsConsumer);
        FunctionDefinition wbFunctionDefinition = source.getEncapsulatedLogic();
        if (Objects.nonNull(wbFunctionDefinition) && Objects.nonNull(uuid = wbFunctionDefinition.getId().getValue())) {
            JSITComponentWidths componentWidths = new JSITComponentWidths();
            componentWidths.setDmnElementRef(uuid);
            source.getEncapsulatedLogic().getComponentWidths().stream().filter(Objects::nonNull).forEach(w -> componentWidths.addWidth(new Float((double)w).floatValue()));
            componentWidthsConsumer.accept(componentWidths);
        }
        result.setEncapsulatedLogic(functionDefinition);
        List inEdges = node.getInEdges();
        for (Edge e : inEdges) {
            JSITDMNElementReference ri;
            JSITKnowledgeRequirement iReq;
            View view;
            Node sourceNode = e.getSourceNode();
            if (!(sourceNode.getContent() instanceof View) || !((view = (View)sourceNode.getContent()).getDefinition() instanceof DRGElement)) continue;
            DRGElement drgElement = (DRGElement)view.getDefinition();
            if (drgElement instanceof BusinessKnowledgeModel) {
                iReq = new JSITKnowledgeRequirement();
                iReq.setId(IdUtils.getRawId(e.getUUID()));
                ri = new JSITDMNElementReference();
                ri.setHref(HrefBuilder.getHref(drgElement));
                iReq.setRequiredKnowledge(ri);
                result.addKnowledgeRequirement(iReq);
                continue;
            }
            if (drgElement instanceof KnowledgeSource) {
                iReq = new JSITAuthorityRequirement();
                iReq.setId(IdUtils.getRawId(e.getUUID()));
                ri = new JSITDMNElementReference();
                ri.setHref(HrefBuilder.getHref(drgElement));
                iReq.setRequiredAuthority(ri);
                result.addAuthorityRequirement((JSITAuthorityRequirement)iReq);
                continue;
            }
            if (drgElement instanceof DecisionService) {
                if (e.getContent() instanceof View && ((View)e.getContent()).getDefinition() instanceof KnowledgeRequirement) {
                    iReq = new JSITKnowledgeRequirement();
                    iReq.setId(IdUtils.getRawId(e.getUUID()));
                    ri = new JSITDMNElementReference();
                    ri.setHref(HrefBuilder.getHref(drgElement));
                    iReq.setRequiredKnowledge(ri);
                    result.addKnowledgeRequirement(iReq);
                    continue;
                }
                throw new UnsupportedOperationException("wrong model definition.");
            }
            throw new UnsupportedOperationException("wrong model definition.");
        }
        return result;
    }
}

