/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.marshaller.converters;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import jsinterop.base.Js;
import org.kie.workbench.common.dmn.api.definition.model.DMNElementReference;
import org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.model.DRGElement;
import org.kie.workbench.common.dmn.api.definition.model.Decision;
import org.kie.workbench.common.dmn.api.definition.model.DecisionService;
import org.kie.workbench.common.dmn.api.definition.model.InformationItemPrimary;
import org.kie.workbench.common.dmn.api.definition.model.InputData;
import org.kie.workbench.common.dmn.api.definition.model.KnowledgeRequirement;
import org.kie.workbench.common.dmn.api.property.background.BackgroundSet;
import org.kie.workbench.common.dmn.api.property.dimensions.DecisionServiceRectangleDimensionsSet;
import org.kie.workbench.common.dmn.api.property.dmn.DecisionServiceDividerLineY;
import org.kie.workbench.common.dmn.api.property.dmn.Description;
import org.kie.workbench.common.dmn.api.property.dmn.Id;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.api.property.font.FontSet;
import org.kie.workbench.common.dmn.client.marshaller.converters.DMNElementReferenceConverter;
import org.kie.workbench.common.dmn.client.marshaller.converters.DMNExternalLinksToExtensionElements;
import org.kie.workbench.common.dmn.client.marshaller.converters.DescriptionPropertyConverter;
import org.kie.workbench.common.dmn.client.marshaller.converters.IdPropertyConverter;
import org.kie.workbench.common.dmn.client.marshaller.converters.InformationItemPrimaryPropertyConverter;
import org.kie.workbench.common.dmn.client.marshaller.converters.NodeConverter;
import org.kie.workbench.common.dmn.client.marshaller.unmarshall.nodes.NodeEntry;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITDMNElementReference;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITDRGElement;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITDecisionService;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITInformationItem;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.kie.JSITComponentWidths;
import org.kie.workbench.common.stunner.core.api.FactoryManager;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableAdapterUtils;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.relationship.Child;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;

public class DecisionServiceConverter
implements NodeConverter<JSITDecisionService, DecisionService> {
    private FactoryManager factoryManager;

    public DecisionServiceConverter(FactoryManager factoryManager) {
        this.factoryManager = factoryManager;
    }

    private static boolean isOutputDecision(View<?> childView, View<DecisionService> decisionServiceView) {
        double decisionServiceViewLineY;
        double decisionServiceViewY;
        double childViewY = childView.getBounds().getUpperLeft().getY();
        return childViewY < (decisionServiceViewY = decisionServiceView.getBounds().getUpperLeft().getY().doubleValue()) + (decisionServiceViewLineY = ((DecisionService)decisionServiceView.getDefinition()).getDividerLineY().getValue().doubleValue());
    }

    @Override
    public Node<View<DecisionService>, ?> nodeFromDMN(NodeEntry nodeEntry) {
        List jsiInputDatas;
        List jsiInputDecisions;
        List jsiEncapsulatedDecisions;
        JSITDecisionService dmn = (JSITDecisionService)Js.uncheckedCast((Object)nodeEntry.getDmnElement());
        Node node = this.factoryManager.newElement(nodeEntry.getId(), BindableAdapterUtils.getDefinitionId(DecisionService.class)).asNode();
        Id id = IdPropertyConverter.wbFromDMN(dmn.getId());
        Description description = DescriptionPropertyConverter.wbFromDMN(dmn.getDescription());
        Name name = new Name(dmn.getName());
        InformationItemPrimary informationItem = InformationItemPrimaryPropertyConverter.wbFromDMN(dmn.getVariable(), dmn);
        ArrayList<DMNElementReference> outputDecision = new ArrayList<DMNElementReference>();
        ArrayList<DMNElementReference> encapsulatedDecision = new ArrayList<DMNElementReference>();
        ArrayList<DMNElementReference> inputDecision = new ArrayList<DMNElementReference>();
        ArrayList<DMNElementReference> inputData = new ArrayList<DMNElementReference>();
        List jsiOutputDecisions = dmn.getOutputDecision();
        if (Objects.nonNull(jsiOutputDecisions)) {
            for (int i = 0; i < jsiOutputDecisions.size(); ++i) {
                JSITDMNElementReference jsiOutputDecision = (JSITDMNElementReference)Js.uncheckedCast(jsiOutputDecisions.get(i));
                outputDecision.add(DMNElementReferenceConverter.wbFromDMN(jsiOutputDecision));
            }
        }
        if (Objects.nonNull(jsiEncapsulatedDecisions = dmn.getEncapsulatedDecision())) {
            for (int i = 0; i < jsiEncapsulatedDecisions.size(); ++i) {
                JSITDMNElementReference jsiEncapsulatedDecision = (JSITDMNElementReference)Js.uncheckedCast(jsiEncapsulatedDecisions.get(i));
                encapsulatedDecision.add(DMNElementReferenceConverter.wbFromDMN(jsiEncapsulatedDecision));
            }
        }
        if (Objects.nonNull(jsiInputDecisions = dmn.getInputDecision())) {
            for (int i = 0; i < jsiInputDecisions.size(); ++i) {
                JSITDMNElementReference jsiInputDecision = (JSITDMNElementReference)Js.uncheckedCast(jsiInputDecisions.get(i));
                inputDecision.add(DMNElementReferenceConverter.wbFromDMN(jsiInputDecision));
            }
        }
        if (Objects.nonNull(jsiInputDatas = dmn.getInputData())) {
            for (int i = 0; i < jsiInputDatas.size(); ++i) {
                JSITDMNElementReference jsiInputData = (JSITDMNElementReference)Js.uncheckedCast(jsiInputDatas.get(i));
                inputData.add(DMNElementReferenceConverter.wbFromDMN(jsiInputData));
            }
        }
        DecisionService decisionService = new DecisionService(id, description, name, informationItem, outputDecision, encapsulatedDecision, inputDecision, inputData, new BackgroundSet(), new FontSet(), new DecisionServiceRectangleDimensionsSet(), new DecisionServiceDividerLineY());
        decisionService.setDiagramId(nodeEntry.getDiagramId());
        ((View)node.getContent()).setDefinition((Object)decisionService);
        if (Objects.nonNull(informationItem)) {
            informationItem.setParent((DMNModelInstrumentedBase)decisionService);
        }
        DMNExternalLinksToExtensionElements.loadExternalLinksFromExtensionElements((JSITDRGElement)dmn, (DRGElement)decisionService);
        return node;
    }

    @Override
    public JSITDecisionService dmnFromNode(Node<View<DecisionService>, ?> node, Consumer<JSITComponentWidths> componentWidthsConsumer) {
        JSITDMNElementReference er;
        int i;
        DecisionService source = (DecisionService)DefinitionUtils.getElementDefinition(node);
        JSITDecisionService ds = new JSITDecisionService();
        ds.setId(source.getId().getValue());
        Optional<String> description = Optional.ofNullable(DescriptionPropertyConverter.dmnFromWB(source.getDescription()));
        description.ifPresent(arg_0 -> ((JSITDecisionService)ds).setDescription(arg_0));
        ds.setName(source.getName().getValue());
        JSITInformationItem variable = InformationItemPrimaryPropertyConverter.dmnFromWB(source.getVariable(), (DMNModelInstrumentedBase)source);
        ds.setVariable(variable);
        List<JSITDMNElementReference> existing_outputDecision = source.getOutputDecision().stream().map(DMNElementReferenceConverter::dmnFromWB).collect(Collectors.toList());
        List<JSITDMNElementReference> existing_encapsulatedDecision = source.getEncapsulatedDecision().stream().map(DMNElementReferenceConverter::dmnFromWB).collect(Collectors.toList());
        List<JSITDMNElementReference> existing_inputDecision = source.getInputDecision().stream().map(DMNElementReferenceConverter::dmnFromWB).collect(Collectors.toList());
        List<JSITDMNElementReference> existing_inputData = source.getInputData().stream().map(DMNElementReferenceConverter::dmnFromWB).collect(Collectors.toList());
        ArrayList<JSITDMNElementReference> candidate_outputDecision = new ArrayList<JSITDMNElementReference>();
        ArrayList<JSITDMNElementReference> candidate_encapsulatedDecision = new ArrayList<JSITDMNElementReference>();
        ArrayList<JSITDMNElementReference> candidate_inputDecision = new ArrayList<JSITDMNElementReference>();
        ArrayList<JSITDMNElementReference> candidate_inputData = new ArrayList<JSITDMNElementReference>();
        ArrayList<InputData> reqInputs = new ArrayList<InputData>();
        ArrayList<Decision> reqDecisions = new ArrayList<Decision>();
        List outEdges = node.getOutEdges();
        for (Edge e : outEdges) {
            if (e.getContent() instanceof Child) {
                Node targetNode = e.getTargetNode();
                View targetNodeView = (View)targetNode.getContent();
                if (!(targetNodeView.getDefinition() instanceof DRGElement)) continue;
                DRGElement drgElement = (DRGElement)targetNodeView.getDefinition();
                if (drgElement instanceof Decision) {
                    Decision decision = (Decision)drgElement;
                    JSITDMNElementReference ri2 = new JSITDMNElementReference();
                    ri2.setHref("#" + decision.getId().getValue());
                    if (DecisionServiceConverter.isOutputDecision((View)targetNode.getContent(), (View<DecisionService>)((View)node.getContent()))) {
                        candidate_outputDecision.add(ri2);
                    } else {
                        candidate_encapsulatedDecision.add(ri2);
                    }
                    this.inspectDecisionForDSReqs(targetNode, reqInputs, reqDecisions);
                    continue;
                }
                throw new UnsupportedOperationException("wrong model definition: a DecisionService is expected to encapsulate only Decision");
            }
            if (e.getContent() instanceof View && ((View)e.getContent()).getDefinition() instanceof KnowledgeRequirement) continue;
            throw new UnsupportedOperationException("wrong model definition.");
        }
        reqInputs.stream().sorted(Comparator.comparing(x -> x.getName().getValue())).map(x -> {
            JSITDMNElementReference ri = new JSITDMNElementReference();
            ri.setHref("#" + x.getId().getValue());
            return ri;
        }).forEach(ri -> candidate_inputData.add((JSITDMNElementReference)Js.uncheckedCast((Object)ri)));
        reqDecisions.stream().sorted(Comparator.comparing(x -> x.getName().getValue())).map(x -> {
            JSITDMNElementReference ri = new JSITDMNElementReference();
            ri.setHref("#" + x.getId().getValue());
            return ri;
        }).forEach(rs -> candidate_inputDecision.add((JSITDMNElementReference)Js.uncheckedCast((Object)rs)));
        for (i = 0; i < candidate_outputDecision.size(); ++i) {
            er = (JSITDMNElementReference)Js.uncheckedCast(candidate_outputDecision.get(i));
            candidate_inputDecision.removeIf(x -> x.getHref().equals(er.getHref()));
        }
        for (i = 0; i < candidate_encapsulatedDecision.size(); ++i) {
            er = (JSITDMNElementReference)Js.uncheckedCast(candidate_encapsulatedDecision.get(i));
            candidate_inputDecision.removeIf(x -> x.getHref().equals(er.getHref()));
        }
        ds.setInputData(this.reconcileExistingAndCandidate(existing_inputData, candidate_inputData));
        ds.setInputDecision(this.reconcileExistingAndCandidate(existing_inputDecision, candidate_inputDecision));
        ds.setEncapsulatedDecision(this.reconcileExistingAndCandidate(existing_encapsulatedDecision, candidate_encapsulatedDecision));
        ds.setOutputDecision(this.reconcileExistingAndCandidate(existing_outputDecision, candidate_outputDecision));
        DMNExternalLinksToExtensionElements.loadExternalLinksIntoExtensionElements((DRGElement)source, (JSITDRGElement)ds);
        return ds;
    }

    private List<JSITDMNElementReference> reconcileExistingAndCandidate(List<JSITDMNElementReference> existingList, List<JSITDMNElementReference> candidateList) {
        int i;
        ArrayList<JSITDMNElementReference> targetList = new ArrayList<JSITDMNElementReference>();
        ArrayList<JSITDMNElementReference> existing = new ArrayList<JSITDMNElementReference>(existingList);
        ArrayList<JSITDMNElementReference> candidate = new ArrayList<JSITDMNElementReference>(candidateList);
        for (i = 0; i < existing.size(); ++i) {
            JSITDMNElementReference e = (JSITDMNElementReference)Js.uncheckedCast(existing.get(i));
            boolean existingIsAlsoCandidate = candidate.removeIf(er -> er.getHref().equals(e.getHref()));
            if (!existingIsAlsoCandidate) continue;
            targetList.add((JSITDMNElementReference)Js.uncheckedCast((Object)e));
        }
        for (i = 0; i < candidate.size(); ++i) {
            JSITDMNElementReference c = (JSITDMNElementReference)Js.uncheckedCast(candidate.get(i));
            targetList.add(c);
        }
        return targetList;
    }

    private void inspectDecisionForDSReqs(Node<View<?>, ?> targetNode, List<InputData> reqInputs, List<Decision> reqDecisions) {
        List inEdges = targetNode.getInEdges();
        for (Edge e : inEdges) {
            View view;
            Node sourceNode = e.getSourceNode();
            if (!(sourceNode.getContent() instanceof View) || !((view = (View)sourceNode.getContent()).getDefinition() instanceof DRGElement)) continue;
            DRGElement drgElement = (DRGElement)view.getDefinition();
            if (drgElement instanceof Decision) {
                reqDecisions.add((Decision)drgElement);
                continue;
            }
            if (!(drgElement instanceof InputData)) continue;
            reqInputs.add((InputData)drgElement);
        }
    }
}

