/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.marshaller.converters;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import jsinterop.base.Js;
import org.kie.workbench.common.dmn.api.definition.HasComponentWidths;
import org.kie.workbench.common.dmn.api.definition.model.Context;
import org.kie.workbench.common.dmn.api.definition.model.ContextEntry;
import org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.model.Expression;
import org.kie.workbench.common.dmn.api.definition.model.FunctionDefinition;
import org.kie.workbench.common.dmn.api.definition.model.InformationItem;
import org.kie.workbench.common.dmn.api.definition.model.LiteralExpression;
import org.kie.workbench.common.dmn.api.definition.model.LiteralExpressionPMMLDocument;
import org.kie.workbench.common.dmn.api.definition.model.LiteralExpressionPMMLDocumentModel;
import org.kie.workbench.common.dmn.api.property.dmn.Description;
import org.kie.workbench.common.dmn.api.property.dmn.Id;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.client.marshaller.converters.DescriptionPropertyConverter;
import org.kie.workbench.common.dmn.client.marshaller.converters.ExpressionPropertyConverter;
import org.kie.workbench.common.dmn.client.marshaller.converters.IdPropertyConverter;
import org.kie.workbench.common.dmn.client.marshaller.converters.InformationItemPropertyConverter;
import org.kie.workbench.common.dmn.client.marshaller.converters.QNamePropertyConverter;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITExpression;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITFunctionDefinition;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITFunctionKind;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITInformationItem;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.kie.JSITComponentWidths;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.mapper.JsUtils;

public class FunctionDefinitionPropertyConverter {
    public static FunctionDefinition wbFromDMN(JSITFunctionDefinition dmn, BiConsumer<String, HasComponentWidths> hasComponentWidthsConsumer) {
        if (Objects.isNull(dmn)) {
            return null;
        }
        Id id = IdPropertyConverter.wbFromDMN(dmn.getId());
        Description description = DescriptionPropertyConverter.wbFromDMN(dmn.getDescription());
        QName typeRef = QNamePropertyConverter.wbFromDMN(dmn.getTypeRef());
        Expression expression = null;
        JSITExpression jsiWrapped = dmn.getExpression();
        if (Objects.nonNull(jsiWrapped)) {
            JSITExpression jsiExpression = (JSITExpression)Js.uncheckedCast((Object)JsUtils.getUnwrappedElement((Object)jsiWrapped));
            expression = ExpressionPropertyConverter.wbFromDMN(jsiExpression, (JSITExpression)Js.uncheckedCast((Object)dmn), hasComponentWidthsConsumer);
        }
        FunctionDefinition result = new FunctionDefinition(id, description, typeRef, expression);
        if (Objects.nonNull(expression)) {
            expression.setParent((DMNModelInstrumentedBase)result);
        }
        String sKind = (String)Js.uncheckedCast((Object)dmn.getKind());
        FunctionDefinition.Kind kind = FunctionDefinition.Kind.fromValue((String)sKind);
        switch (kind) {
            case FEEL: {
                result.setKind(FunctionDefinition.Kind.FEEL);
                break;
            }
            case JAVA: {
                result.setKind(FunctionDefinition.Kind.JAVA);
                break;
            }
            case PMML: {
                result.setKind(FunctionDefinition.Kind.PMML);
                FunctionDefinitionPropertyConverter.convertPMMLFunctionExpression(result, hasComponentWidthsConsumer);
                break;
            }
            default: {
                result.setKind(FunctionDefinition.Kind.FEEL);
            }
        }
        List jsiInformationItems = dmn.getFormalParameter();
        for (int i = 0; i < jsiInformationItems.size(); ++i) {
            JSITInformationItem jsiInformationItem = (JSITInformationItem)Js.uncheckedCast(jsiInformationItems.get(i));
            InformationItem iiConverted = InformationItemPropertyConverter.wbFromDMN(jsiInformationItem);
            if (Objects.nonNull(iiConverted)) {
                iiConverted.setParent((DMNModelInstrumentedBase)result);
            }
            result.getFormalParameter().add(iiConverted);
        }
        return result;
    }

    private static void convertPMMLFunctionExpression(FunctionDefinition function, BiConsumer<String, HasComponentWidths> hasComponentWidthsConsumer) {
        Expression expression = function.getExpression();
        if (expression instanceof Context) {
            Context context = (Context)expression;
            context.getContextEntry().forEach(ce -> FunctionDefinitionPropertyConverter.convertContextEntryExpression(ce, hasComponentWidthsConsumer));
        }
    }

    private static void convertContextEntryExpression(ContextEntry contextEntry, BiConsumer<String, HasComponentWidths> hasComponentWidthsConsumer) {
        Expression expression = contextEntry.getExpression();
        if (expression instanceof LiteralExpression) {
            LiteralExpression le = (LiteralExpression)expression;
            String variableName = contextEntry.getVariable().getName().getValue();
            if (Objects.equals("document", variableName)) {
                LiteralExpressionPMMLDocument e = FunctionDefinitionPropertyConverter.convertLiteralExpressionToPMMLDocument(le);
                hasComponentWidthsConsumer.accept(e.getId().getValue(), (HasComponentWidths)e);
                contextEntry.setExpression((Expression)e);
            } else if (Objects.equals("model", variableName)) {
                LiteralExpressionPMMLDocumentModel e = FunctionDefinitionPropertyConverter.convertLiteralExpressionToPMMLDocumentModel(le);
                hasComponentWidthsConsumer.accept(e.getId().getValue(), (HasComponentWidths)e);
                contextEntry.setExpression((Expression)e);
            }
        }
    }

    private static LiteralExpressionPMMLDocument convertLiteralExpressionToPMMLDocument(LiteralExpression le) {
        return new LiteralExpressionPMMLDocument(le.getId(), le.getDescription(), le.getTypeRef(), le.getText(), le.getImportedValues(), le.getExpressionLanguage());
    }

    private static LiteralExpressionPMMLDocumentModel convertLiteralExpressionToPMMLDocumentModel(LiteralExpression le) {
        return new LiteralExpressionPMMLDocumentModel(le.getId(), le.getDescription(), le.getTypeRef(), le.getText(), le.getImportedValues(), le.getExpressionLanguage());
    }

    public static JSITFunctionDefinition dmnFromWB(FunctionDefinition wb, Consumer<JSITComponentWidths> componentWidthsConsumer) {
        if (Objects.isNull(wb)) {
            return null;
        }
        JSITFunctionDefinition result = new JSITFunctionDefinition();
        result.setId(wb.getId().getValue());
        if (Objects.isNull(result.getFormalParameter())) {
            result.setFormalParameter(new ArrayList());
        }
        Optional<String> description = Optional.ofNullable(DescriptionPropertyConverter.dmnFromWB(wb.getDescription()));
        description.ifPresent(arg_0 -> ((JSITFunctionDefinition)result).setDescription(arg_0));
        QNamePropertyConverter.setDMNfromWB(wb.getTypeRef(), arg_0 -> ((JSITFunctionDefinition)result).setTypeRef(arg_0));
        result.setExpression(ExpressionPropertyConverter.dmnFromWB(wb.getExpression(), componentWidthsConsumer));
        FunctionDefinition.Kind kind = wb.getKind();
        switch (kind) {
            case FEEL: {
                result.setKind((JSITFunctionKind)Js.uncheckedCast((Object)JSITFunctionKind.FEEL.value()));
                break;
            }
            case JAVA: {
                result.setKind((JSITFunctionKind)Js.uncheckedCast((Object)JSITFunctionKind.JAVA.value()));
                break;
            }
            case PMML: {
                result.setKind((JSITFunctionKind)Js.uncheckedCast((Object)JSITFunctionKind.PMML.value()));
                break;
            }
            default: {
                result.setKind((JSITFunctionKind)Js.uncheckedCast((Object)JSITFunctionKind.FEEL.value()));
            }
        }
        for (InformationItem ii : wb.getFormalParameter()) {
            JSITInformationItem iiConverted = InformationItemPropertyConverter.dmnFromWB(ii);
            result.addFormalParameter(iiConverted);
        }
        return result;
    }
}

