/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.marshaller.converters;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.model.Import;
import org.kie.workbench.common.dmn.api.definition.model.ImportDMN;
import org.kie.workbench.common.dmn.api.definition.model.ImportPMML;
import org.kie.workbench.common.dmn.api.editors.included.DMNImportTypes;
import org.kie.workbench.common.dmn.api.editors.included.PMMLDocumentMetadata;
import org.kie.workbench.common.dmn.api.property.dmn.LocationURI;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.client.marshaller.common.NameSpaceUtils;
import org.kie.workbench.common.dmn.client.marshaller.converters.DescriptionPropertyConverter;
import org.kie.workbench.common.dmn.client.marshaller.converters.IdPropertyConverter;
import org.kie.workbench.common.dmn.client.marshaller.converters.QNamePropertyConverter;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITDMNElement;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITDefinitions;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITImport;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITUnaryTests;

public final class ImportConverter {
    public static Import wbFromDMN(JSITImport dmn, JSITDefinitions definitions, PMMLDocumentMetadata pmmlDocument) {
        Import result = ImportConverter.createWBImport(dmn, definitions, pmmlDocument);
        HashMap additionalAttributes = new HashMap();
        Map otherAttributes = JSITUnaryTests.getOtherAttributesMap((JSITDMNElement)dmn);
        for (Map.Entry entry : otherAttributes.entrySet()) {
            additionalAttributes.put(QNamePropertyConverter.wbFromDMN(((javax.xml.namespace.QName)entry.getKey()).toString()), entry.getValue());
        }
        result.setAdditionalAttributes(additionalAttributes);
        String name = dmn.getName();
        String description = dmn.getDescription();
        result.setId(IdPropertyConverter.wbFromDMN(dmn.getId()));
        result.setName(new Name(name));
        result.setDescription(DescriptionPropertyConverter.wbFromDMN(description));
        NameSpaceUtils.extractNamespacesKeyedByPrefix((JSITDMNElement)dmn).forEach((key, value) -> result.getNsContext().put(key, value));
        return result;
    }

    private static Import createWBImport(JSITImport dmn, JSITDefinitions definitions, PMMLDocumentMetadata pmmlDocument) {
        LocationURI locationURI = new LocationURI(dmn.getLocationURI());
        if (Objects.equals(DMNImportTypes.DMN, DMNImportTypes.determineImportType((String)dmn.getImportType()))) {
            ImportDMN result = new ImportDMN(dmn.getNamespace(), locationURI, dmn.getImportType());
            result.setDrgElementsCount(ImportConverter.countDefinitionElement(definitions, d -> d.getDrgElement().size()).intValue());
            result.setItemDefinitionsCount(ImportConverter.countDefinitionElement(definitions, d -> d.getItemDefinition().size()).intValue());
            return result;
        }
        if (Objects.equals(DMNImportTypes.PMML, DMNImportTypes.determineImportType((String)dmn.getImportType()))) {
            ImportPMML result = new ImportPMML(dmn.getNamespace(), locationURI, dmn.getImportType());
            result.setModelCount(ImportConverter.countDefinitionElement(pmmlDocument, document -> document.getModels().size()).intValue());
            return result;
        }
        return new Import(dmn.getNamespace(), locationURI, dmn.getImportType());
    }

    static JSITImport dmnFromWb(Import wb) {
        JSITImport result = new JSITImport();
        result.setImportType(wb.getImportType());
        result.setLocationURI(wb.getLocationURI().getValue());
        result.setNamespace(wb.getNamespace());
        HashMap otherAttributes = new HashMap();
        for (Map.Entry entry : wb.getAdditionalAttributes().entrySet()) {
            QNamePropertyConverter.dmnFromWB((QName)entry.getKey()).ifPresent(qName -> {
                String cfr_ignored_0 = (String)otherAttributes.put(qName, entry.getValue());
            });
        }
        wb.getNsContext().forEach((k, v) -> {
            if (!Objects.equals(k, DMNModelInstrumentedBase.Namespace.DEFAULT.getPrefix())) {
                otherAttributes.put(new javax.xml.namespace.QName("http://www.w3.org/2000/xmlns/", (String)k, ""), v);
            }
        });
        otherAttributes.remove(new javax.xml.namespace.QName("http://www.w3.org/2000/xmlns/", DMNModelInstrumentedBase.Namespace.DEFAULT.getPrefix(), ""));
        result.setId(wb.getId().getValue());
        result.setName(wb.getName().getValue());
        Optional<String> description = Optional.ofNullable(DescriptionPropertyConverter.dmnFromWB(wb.getDescription()));
        description.ifPresent(arg_0 -> ((JSITImport)result).setDescription(arg_0));
        result.setOtherAttributes(otherAttributes);
        return result;
    }

    private static <T> Integer countDefinitionElement(T definition, Function<T, Integer> countFunction) {
        Integer none = 0;
        return Optional.ofNullable(definition).map(countFunction).orElse(none);
    }
}

