/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.marshaller.converters;

import java.util.List;
import org.kie.workbench.common.dmn.api.definition.model.ItemDefinition;
import org.kie.workbench.common.dmn.api.editors.types.BuiltInTypeUtils;
import org.kie.workbench.common.dmn.client.marshaller.converters.ItemDefinitionPropertyConverter;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITItemDefinition;

public class ImportedItemDefinitionPropertyConverter {
    private ImportedItemDefinitionPropertyConverter() {
    }

    public static ItemDefinition wbFromDMN(JSITItemDefinition dmnItemDefinition, String prefix) {
        JSITItemDefinition dmnItemDefinitionWithNamespace = ImportedItemDefinitionPropertyConverter.withNamespace(dmnItemDefinition, prefix);
        ItemDefinition wbItemDefinition = ItemDefinitionPropertyConverter.wbFromDMN(dmnItemDefinitionWithNamespace);
        ImportedItemDefinitionPropertyConverter.allowOnlyVisualChange(wbItemDefinition);
        return wbItemDefinition;
    }

    public static JSITItemDefinition withNamespace(JSITItemDefinition itemDefinition, String prefix) {
        String nameWithPrefix = prefix + "." + itemDefinition.getName();
        List itemComponents = itemDefinition.getItemComponent();
        if (itemDefinition.getTypeRef() != null && !ImportedItemDefinitionPropertyConverter.isBuiltInType(itemDefinition.getTypeRef())) {
            itemDefinition.setTypeRef(ImportedItemDefinitionPropertyConverter.makeQNameWithPrefix(itemDefinition.getTypeRef(), prefix));
        }
        itemDefinition.setName(nameWithPrefix);
        ImportedItemDefinitionPropertyConverter.setItemDefinitionsNamespace(itemComponents, prefix);
        return itemDefinition;
    }

    private static void allowOnlyVisualChange(ItemDefinition itemDefinition) {
        itemDefinition.setAllowOnlyVisualChange(true);
        itemDefinition.getItemComponent().forEach(ImportedItemDefinitionPropertyConverter::allowOnlyVisualChange);
    }

    private static void setItemDefinitionsNamespace(List<JSITItemDefinition> itemDefinitions, String prefix) {
        itemDefinitions.forEach(itemDefinition -> ImportedItemDefinitionPropertyConverter.withNamespace(itemDefinition, prefix));
    }

    private static boolean isBuiltInType(String typeRef) {
        return BuiltInTypeUtils.isBuiltInType((String)typeRef);
    }

    private static String makeQNameWithPrefix(String qName, String prefix) {
        return prefix + "." + qName;
    }
}

