/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.marshaller.converters;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import jsinterop.base.Js;
import org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.model.IsUnaryTests;
import org.kie.workbench.common.dmn.api.definition.model.ItemDefinition;
import org.kie.workbench.common.dmn.api.definition.model.UnaryTests;
import org.kie.workbench.common.dmn.api.property.dmn.Description;
import org.kie.workbench.common.dmn.api.property.dmn.Id;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.api.property.dmn.types.BuiltInType;
import org.kie.workbench.common.dmn.client.marshaller.converters.DescriptionPropertyConverter;
import org.kie.workbench.common.dmn.client.marshaller.converters.IdPropertyConverter;
import org.kie.workbench.common.dmn.client.marshaller.converters.QNamePropertyConverter;
import org.kie.workbench.common.dmn.client.marshaller.converters.UnaryTestsPropertyConverter;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITItemDefinition;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITUnaryTests;

public class ItemDefinitionPropertyConverter {
    public static ItemDefinition wbFromDMN(JSITItemDefinition dmn) {
        if (Objects.isNull(dmn)) {
            return null;
        }
        Id id = IdPropertyConverter.wbFromDMN(dmn.getId());
        Name name = new Name(dmn.getName());
        Description description = ItemDefinitionPropertyConverter.wbDescriptionFromDMN(dmn);
        QName typeRef = ItemDefinitionPropertyConverter.wbTypeRefFromDMN(dmn);
        String typeLanguage = dmn.getTypeLanguage();
        boolean isCollection = dmn.getIsCollection();
        ItemDefinition wb = new ItemDefinition(id, description, name, typeRef, null, null, typeLanguage, Boolean.valueOf(isCollection), Boolean.valueOf(false));
        ItemDefinitionPropertyConverter.setUnaryTests(wb, dmn);
        ItemDefinitionPropertyConverter.setItemComponent(wb, dmn);
        return wb;
    }

    static void setUnaryTests(ItemDefinition wb, JSITItemDefinition dmn) {
        JSITUnaryTests dmnAllowedValues = dmn.getAllowedValues();
        Optional<UnaryTests> wbUnaryTests = Optional.ofNullable(UnaryTestsPropertyConverter.wbFromDMN(dmnAllowedValues));
        wbUnaryTests.ifPresent(unaryTests -> {
            wb.setAllowedValues(unaryTests);
            unaryTests.setParent((DMNModelInstrumentedBase)wb);
        });
    }

    static void setItemComponent(ItemDefinition wb, JSITItemDefinition dmn) {
        List jsiItemDefinitions = dmn.getItemComponent();
        if (Objects.nonNull(jsiItemDefinitions)) {
            for (int i = 0; i < jsiItemDefinitions.size(); ++i) {
                JSITItemDefinition jsiItemDefinition = (JSITItemDefinition)Js.uncheckedCast(jsiItemDefinitions.get(i));
                wb.getItemComponent().add(ItemDefinitionPropertyConverter.wbChildFromDMN(wb, jsiItemDefinition));
            }
        }
    }

    static ItemDefinition wbChildFromDMN(ItemDefinition wbParent, JSITItemDefinition dmnChild) {
        ItemDefinition wbChild = ItemDefinitionPropertyConverter.wbFromDMN(dmnChild);
        if (Objects.nonNull(wbChild)) {
            wbChild.setParent((DMNModelInstrumentedBase)wbParent);
        }
        return wbChild;
    }

    static Description wbDescriptionFromDMN(JSITItemDefinition dmn) {
        return DescriptionPropertyConverter.wbFromDMN(dmn.getDescription());
    }

    static QName wbTypeRefFromDMN(JSITItemDefinition dmn) {
        QName undefinedQName;
        QName wbQName = QNamePropertyConverter.wbFromDMN(dmn.getTypeRef());
        return Objects.equals(wbQName, undefinedQName = BuiltInType.UNDEFINED.asQName()) ? null : wbQName;
    }

    public static JSITItemDefinition dmnFromWB(ItemDefinition wb) {
        if (Objects.isNull(wb)) {
            return null;
        }
        JSITItemDefinition result = new JSITItemDefinition();
        result.setId(wb.getId().getValue());
        Optional<String> description = Optional.ofNullable(DescriptionPropertyConverter.dmnFromWB(wb.getDescription()));
        description.ifPresent(arg_0 -> ((JSITItemDefinition)result).setDescription(arg_0));
        result.setName(wb.getName().getValue());
        QNamePropertyConverter.setDMNfromWB(wb.getTypeRef(), arg_0 -> ((JSITItemDefinition)result).setTypeRef(arg_0));
        result.setTypeLanguage(wb.getTypeLanguage());
        result.setIsCollection(wb.isIsCollection());
        JSITUnaryTests utConverted = UnaryTestsPropertyConverter.dmnFromWB((IsUnaryTests)wb.getAllowedValues());
        result.setAllowedValues(utConverted);
        for (ItemDefinition child : wb.getItemComponent()) {
            JSITItemDefinition convertedChild = ItemDefinitionPropertyConverter.dmnFromWB(child);
            result.addItemComponent(convertedChild);
        }
        return result;
    }
}

