/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.marshaller.converters;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.api.property.dmn.types.BuiltInType;
import org.kie.workbench.common.stunner.core.util.StringUtils;

public class QNamePropertyConverter {
    public static QName wbFromDMN(String qNameAsString) {
        if (StringUtils.isEmpty((String)qNameAsString)) {
            return BuiltInType.UNDEFINED.asQName();
        }
        javax.xml.namespace.QName qName = javax.xml.namespace.QName.valueOf(qNameAsString);
        return new QName(qName.getNamespaceURI(), qName.getLocalPart(), qName.getPrefix());
    }

    public static void setDMNfromWB(QName qname, Consumer<String> setter) {
        if (Objects.nonNull(qname)) {
            Optional<javax.xml.namespace.QName> dmnTypeRef = QNamePropertyConverter.dmnFromWB(qname);
            dmnTypeRef.ifPresent(typeRef -> setter.accept(typeRef.toString()));
        }
    }

    public static Optional<javax.xml.namespace.QName> dmnFromWB(QName wb) {
        if (Objects.nonNull(wb)) {
            if (Objects.equals(wb, BuiltInType.UNDEFINED.asQName())) {
                return Optional.empty();
            }
            return Optional.of(new javax.xml.namespace.QName(wb.getNamespaceURI(), wb.getLocalPart(), wb.getPrefix()));
        }
        return Optional.empty();
    }
}

