/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.marshaller.included;

import elemental2.promise.Promise;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.guvnor.common.services.project.client.context.WorkspaceProjectContext;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.jboss.errai.common.client.api.Caller;
import org.kie.workbench.common.dmn.api.DMNContentService;
import org.kie.workbench.common.dmn.api.editors.included.PMMLDocumentMetadata;
import org.kie.workbench.common.dmn.client.marshaller.included.DMNMarshallerImportsContentService;
import org.kie.workbench.common.stunner.core.client.service.ClientRuntimeError;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.client.promise.Promises;

@ApplicationScoped
public class DMNMarshallerImportsContentServiceImpl
implements DMNMarshallerImportsContentService {
    private final Caller<DMNContentService> dmnContentServiceCaller;
    private final Promises promises;
    private final WorkspaceProjectContext projectContext;

    @Inject
    public DMNMarshallerImportsContentServiceImpl(Caller<DMNContentService> dmnContentServiceCaller, Promises promises, WorkspaceProjectContext projectContext) {
        this.dmnContentServiceCaller = dmnContentServiceCaller;
        this.promises = promises;
        this.projectContext = projectContext;
    }

    @Override
    public Promise<String> loadFile(String fileUri) {
        return this.promises.create((success, failure) -> ((DMNContentService)this.dmnContentServiceCaller.call(arg_0 -> ((Promise.PromiseExecutorCallbackFn.ResolveCallbackFn)success).onInvoke(arg_0), (message, throwable) -> {
            failure.onInvoke((Object)new ClientRuntimeError(throwable));
            return false;
        })).getContent(this.makePath(fileUri)));
    }

    @Override
    public Promise<String[]> getModelsURIs() {
        return this.promises.create((success, failure) -> this.getContentServiceCaller((Promise.PromiseExecutorCallbackFn.ResolveCallbackFn<String[]>)success, failure).getModelsPaths(this.getWorkspaceProject()));
    }

    @Override
    public Promise<String[]> getModelsDMNFilesURIs() {
        return this.promises.create((success, failure) -> this.getContentServiceCaller((Promise.PromiseExecutorCallbackFn.ResolveCallbackFn<String[]>)success, failure).getDMNModelsPaths(this.getWorkspaceProject()));
    }

    @Override
    public Promise<String[]> getModelsPMMLFilesURIs() {
        return this.promises.create((success, failure) -> this.getContentServiceCaller((Promise.PromiseExecutorCallbackFn.ResolveCallbackFn<String[]>)success, failure).getPMMLModelsPaths(this.getWorkspaceProject()));
    }

    @Override
    public Promise<PMMLDocumentMetadata> getPMMLDocumentMetadata(String fileUri) {
        return this.promises.create((success, failure) -> ((DMNContentService)this.dmnContentServiceCaller.call(arg_0 -> ((Promise.PromiseExecutorCallbackFn.ResolveCallbackFn)success).onInvoke(arg_0), (message, throwable) -> {
            failure.onInvoke((Object)new ClientRuntimeError(throwable));
            return false;
        })).loadPMMLDocumentMetadata(this.makePath(fileUri)));
    }

    private Path makePath(String fileUri) {
        return PathFactory.newPath((String)".", (String)fileUri);
    }

    private DMNContentService getContentServiceCaller(Promise.PromiseExecutorCallbackFn.ResolveCallbackFn<String[]> success, Promise.PromiseExecutorCallbackFn.RejectCallbackFn failure) {
        return (DMNContentService)this.dmnContentServiceCaller.call(paths -> success.onInvoke(paths.stream().map(Path::toURI).toArray(String[]::new)), (message, throwable) -> {
            failure.onInvoke((Object)new ClientRuntimeError(throwable));
            return false;
        });
    }

    private WorkspaceProject getWorkspaceProject() {
        return this.projectContext.getActiveWorkspaceProject().orElse(null);
    }
}

