/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.marshaller.marshall;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.xml.namespace.QName;
import jsinterop.base.Js;
import jsinterop.base.JsPropertyMap;
import org.kie.workbench.common.dmn.api.definition.DMNViewDefinition;
import org.kie.workbench.common.dmn.api.definition.model.Association;
import org.kie.workbench.common.dmn.api.definition.model.BusinessKnowledgeModel;
import org.kie.workbench.common.dmn.api.definition.model.DMNDiagram;
import org.kie.workbench.common.dmn.api.definition.model.DMNElement;
import org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.model.DRGElement;
import org.kie.workbench.common.dmn.api.definition.model.Decision;
import org.kie.workbench.common.dmn.api.definition.model.DecisionService;
import org.kie.workbench.common.dmn.api.definition.model.Definitions;
import org.kie.workbench.common.dmn.api.definition.model.Import;
import org.kie.workbench.common.dmn.api.definition.model.InputData;
import org.kie.workbench.common.dmn.api.definition.model.KnowledgeSource;
import org.kie.workbench.common.dmn.api.definition.model.TextAnnotation;
import org.kie.workbench.common.dmn.client.docks.navigator.drds.DMNDiagramsSession;
import org.kie.workbench.common.dmn.client.marshaller.common.DMNGraphUtils;
import org.kie.workbench.common.dmn.client.marshaller.common.IdUtils;
import org.kie.workbench.common.dmn.client.marshaller.common.JsInteropUtils;
import org.kie.workbench.common.dmn.client.marshaller.common.WrapperUtils;
import org.kie.workbench.common.dmn.client.marshaller.converters.AssociationConverter;
import org.kie.workbench.common.dmn.client.marshaller.converters.BusinessKnowledgeModelConverter;
import org.kie.workbench.common.dmn.client.marshaller.converters.DecisionConverter;
import org.kie.workbench.common.dmn.client.marshaller.converters.DecisionServiceConverter;
import org.kie.workbench.common.dmn.client.marshaller.converters.DefinitionsConverter;
import org.kie.workbench.common.dmn.client.marshaller.converters.InputDataConverter;
import org.kie.workbench.common.dmn.client.marshaller.converters.KnowledgeSourceConverter;
import org.kie.workbench.common.dmn.client.marshaller.converters.TextAnnotationConverter;
import org.kie.workbench.common.dmn.client.marshaller.converters.dd.PointUtils;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.MainJs;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.di.JSIDiagramElement;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITArtifact;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITAssociation;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITBusinessKnowledgeModel;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITDMNElement;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITDRGElement;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITDecision;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITDecisionService;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITDefinitions;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITInputData;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITKnowledgeSource;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmndi12.JSIDMNDiagram;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmndi12.JSIDMNEdge;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.kie.JSITComponentWidths;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.kie.JSITComponentsWidthsExtension;
import org.kie.workbench.common.stunner.core.api.FactoryManager;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.HasContentDefinitionId;
import org.kie.workbench.common.stunner.core.graph.content.view.Connection;
import org.kie.workbench.common.stunner.core.graph.content.view.ControlPoint;
import org.kie.workbench.common.stunner.core.graph.content.view.Point2D;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewConnector;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;

@ApplicationScoped
public class DMNMarshaller {
    public static final String PREFIX = "dmn";
    private InputDataConverter inputDataConverter;
    private DecisionConverter decisionConverter;
    private BusinessKnowledgeModelConverter bkmConverter;
    private KnowledgeSourceConverter knowledgeSourceConverter;
    private TextAnnotationConverter textAnnotationConverter;
    private DecisionServiceConverter decisionServiceConverter;
    @Inject
    private DMNDiagramsSession dmnDiagramsSession;

    protected DMNMarshaller() {
        this(null);
    }

    @Inject
    public DMNMarshaller(FactoryManager factoryManager) {
        this.inputDataConverter = new InputDataConverter(factoryManager);
        this.decisionConverter = new DecisionConverter(factoryManager);
        this.bkmConverter = new BusinessKnowledgeModelConverter(factoryManager);
        this.knowledgeSourceConverter = new KnowledgeSourceConverter(factoryManager);
        this.textAnnotationConverter = new TextAnnotationConverter(factoryManager);
        this.decisionServiceConverter = new DecisionServiceConverter(factoryManager);
    }

    @PostConstruct
    public void init() {
        MainJs.initializeJsInteropConstructors((JsPropertyMap)MainJs.getConstructorsMap());
    }

    public JSITDefinitions marshall() {
        HashMap nodes = new HashMap();
        HashMap textAnnotations = new HashMap();
        Node<?, ?> dmnDiagramRoot = DMNGraphUtils.findDMNDiagramRoot(this.dmnDiagramsSession.getDRGDiagram().getGraph());
        Definitions definitionsStunnerPojo = ((DMNDiagram)DefinitionUtils.getElementDefinition(dmnDiagramRoot)).getDefinitions();
        ArrayList dmnDiagramElementIds = new ArrayList();
        JSITDefinitions definitions = DefinitionsConverter.dmnFromWB(definitionsStunnerPojo, true);
        if (Objects.isNull(definitions.getExtensionElements())) {
            JSITDMNElement.JSIExtensionElements jsiExtensionElements = new JSITDMNElement.JSIExtensionElements();
            definitions.setExtensionElements(jsiExtensionElements);
        }
        List dmnDiagrams = definitions.getDMNDI().getDMNDiagram();
        JsInteropUtils.forEach(dmnDiagrams, diagram -> {
            String elementDiagramId = diagram.getId();
            ArrayList<JSIDMNEdge> dmnEdges = new ArrayList<JSIDMNEdge>();
            List<Node> diagramNodes = this.getNodeStream(this.dmnDiagramsSession.getDiagram(elementDiagramId));
            if (Objects.isNull(diagram.getExtension())) {
                diagram.setExtension(new JSIDiagramElement.JSIExtension());
            }
            JSITComponentsWidthsExtension componentsWidthsExtension = new JSITComponentsWidthsExtension();
            JSIDiagramElement.JSIExtension extension = diagram.getExtension();
            JSITComponentsWidthsExtension wrappedComponentsWidthsExtension = WrapperUtils.getWrappedJSITComponentsWidthsExtension(componentsWidthsExtension);
            extension.addAny((Object)wrappedComponentsWidthsExtension);
            Consumer<JSITComponentWidths> componentWidthsConsumer = cw -> componentsWidthsExtension.addComponentWidths(cw);
            for (Node node2 : diagramNodes) {
                PointUtils.convertToAbsoluteBounds(node2);
            }
            for (Node node2 : diagramNodes) {
                String namespaceURI;
                HasContentDefinitionId hasContentDefinitionId;
                String nodeDiagramId;
                View view;
                Object viewDefinition;
                if (!(node2.getContent() instanceof View) || !((viewDefinition = (view = (View)node2.getContent()).getDefinition()) instanceof HasContentDefinitionId) || !Objects.equals(nodeDiagramId = (hasContentDefinitionId = (HasContentDefinitionId)viewDefinition).getDiagramId(), elementDiagramId)) continue;
                if (viewDefinition instanceof DRGElement) {
                    DRGElement drgElement = (DRGElement)viewDefinition;
                    if (!drgElement.isAllowOnlyVisualChange()) {
                        nodes.put(drgElement.getId().getValue(), this.stunnerToDMN(this.withIncludedModels(node2, definitionsStunnerPojo), componentWidthsConsumer));
                    }
                    namespaceURI = definitionsStunnerPojo.getDefaultNamespace();
                    diagram.addDMNDiagramElement((JSIDiagramElement)WrapperUtils.getWrappedJSIDMNShape(diagram, dmnDiagramElementIds, definitionsStunnerPojo, (View<? extends DMNElement>)view, namespaceURI));
                }
                if (viewDefinition instanceof TextAnnotation) {
                    TextAnnotation textAnnotation = (TextAnnotation)viewDefinition;
                    if (!textAnnotation.isAllowOnlyVisualChange()) {
                        textAnnotations.put(textAnnotation.getId().getValue(), this.textAnnotationConverter.dmnFromNode((Node<View<TextAnnotation>, ?>)node2, componentWidthsConsumer));
                    }
                    namespaceURI = definitionsStunnerPojo.getDefaultNamespace();
                    diagram.addDMNDiagramElement((JSIDiagramElement)WrapperUtils.getWrappedJSIDMNShape(diagram, dmnDiagramElementIds, definitionsStunnerPojo, (View<? extends DMNElement>)view, namespaceURI));
                    List<JSITAssociation> associations = AssociationConverter.dmnFromWB(node2);
                    JsInteropUtils.forEach(associations, association -> {
                        JSITAssociation wrappedJSITAssociation = WrapperUtils.getWrappedJSITAssociation((JSITAssociation)Js.uncheckedCast((Object)association));
                        definitions.addArtifact((JSITArtifact)wrappedJSITAssociation);
                    });
                }
                this.connect((JSIDMNDiagram)diagram, dmnDiagramElementIds, definitionsStunnerPojo, (List<JSIDMNEdge>)dmnEdges, (Node<?, ?>)node2, (View<?>)view);
            }
            nodes.values().forEach(node -> this.mergeOrAddNodeToDefinitions((JSITDRGElement)node, definitions));
            textAnnotations.values().forEach(text -> {
                boolean exists = JsInteropUtils.anyMatch(definitions.getArtifact(), artifact -> Objects.equals(artifact.getId(), text.getId()));
                if (!exists) {
                    definitions.addArtifact((JSITArtifact)WrapperUtils.getWrappedJSITTextAnnotation(text));
                }
            });
            JsInteropUtils.forEach(dmnEdges, dmnEdge -> {
                boolean exists = JsInteropUtils.anyMatch(diagram.getDMNDiagramElement(), diagramElement -> {
                    if (JSIDMNEdge.instanceOf((Object)diagramElement)) {
                        JSIDMNEdge jsidmnEdge = (JSIDMNEdge)Js.uncheckedCast((Object)diagramElement);
                        return Objects.equals(jsidmnEdge.getDmnElementRef(), dmnEdge.getDmnElementRef());
                    }
                    return false;
                });
                if (!exists) {
                    diagram.addDMNDiagramElement((JSIDiagramElement)WrapperUtils.getWrappedJSIDMNEdge((JSIDMNEdge)Js.uncheckedCast((Object)dmnEdge)));
                }
            });
            for (Node node2 : diagramNodes) {
                PointUtils.convertToRelativeBounds(node2);
            }
        });
        return definitions;
    }

    Node<?, ?> withIncludedModels(Node<?, ?> node, Definitions definitionsStunnerPojo) {
        Object elementDefinition = DefinitionUtils.getElementDefinition(node);
        List diagramImports = definitionsStunnerPojo.getImport();
        if (!(elementDefinition instanceof DRGElement) || diagramImports.isEmpty()) {
            return node;
        }
        DRGElement drgElement = (DRGElement)elementDefinition;
        Optional<Definitions> nodeDefinitions = DMNMarshaller.getDefinitions(drgElement);
        if (!nodeDefinitions.isPresent()) {
            return node;
        }
        List nodeImports = nodeDefinitions.get().getImport();
        this.updateNodeImports(diagramImports, nodeImports);
        return node;
    }

    private void updateNodeImports(List<Import> diagramImports, List<Import> nodeImports) {
        for (Import anImport : diagramImports) {
            if (nodeImports.contains(anImport)) continue;
            nodeImports.add(anImport);
        }
    }

    private static Optional<Definitions> getDefinitions(DRGElement drgElement) {
        DMNModelInstrumentedBase parent = drgElement.getParent();
        if (parent instanceof DMNDiagram) {
            DMNDiagram diagram = (DMNDiagram)parent;
            return Optional.ofNullable(diagram.getDefinitions());
        }
        if (parent instanceof Definitions) {
            return Optional.of((Definitions)parent);
        }
        return Optional.empty();
    }

    void mergeOrAddNodeToDefinitions(JSITDRGElement node, JSITDefinitions definitions) {
        Optional<JSITDRGElement> existingNode = this.getExistingNode(definitions, node);
        if (existingNode.isPresent()) {
            JSITDRGElement existingDRGElement = (JSITDRGElement)Js.uncheckedCast((Object)existingNode.get());
            this.mergeNodeRequirements(node, existingDRGElement);
        } else {
            this.addNodeToDefinitions(node, definitions);
        }
    }

    private void addNodeToDefinitions(JSITDRGElement node, JSITDefinitions definitions) {
        JSINodeLocalPartName localPart = this.getLocalPart(node);
        JSITDRGElement toAdd = this.getWrappedJSITDRGElement(node, localPart);
        definitions.addDrgElement(toAdd);
    }

    JSITDRGElement getWrappedJSITDRGElement(JSITDRGElement node, JSINodeLocalPartName localPart) {
        return WrapperUtils.getWrappedJSITDRGElement(node, PREFIX, localPart.getLocalPart());
    }

    private void mergeNodeRequirements(JSITDRGElement node, JSITDRGElement existingDRGElement) {
        if (this.instanceOfBusinessKnowledgeModel(node)) {
            JSITBusinessKnowledgeModel existingBkm = (JSITBusinessKnowledgeModel)Js.uncheckedCast((Object)existingDRGElement);
            JSITBusinessKnowledgeModel nodeBkm = (JSITBusinessKnowledgeModel)Js.uncheckedCast((Object)node);
            existingBkm.setAuthorityRequirement(this.distinct(nodeBkm.getAuthorityRequirement(), existingBkm.getAuthorityRequirement()));
            existingBkm.setKnowledgeRequirement(this.distinct(nodeBkm.getKnowledgeRequirement(), existingBkm.getKnowledgeRequirement()));
        } else if (this.instanceOfDecision(node)) {
            JSITDecision existingDecision = (JSITDecision)Js.uncheckedCast((Object)existingDRGElement);
            JSITDecision nodeDecision = (JSITDecision)Js.uncheckedCast((Object)node);
            existingDecision.setAuthorityRequirement(this.distinct(nodeDecision.getAuthorityRequirement(), existingDecision.getAuthorityRequirement()));
            existingDecision.setInformationRequirement(this.distinct(nodeDecision.getInformationRequirement(), existingDecision.getInformationRequirement()));
            existingDecision.setKnowledgeRequirement(this.distinct(nodeDecision.getKnowledgeRequirement(), existingDecision.getKnowledgeRequirement()));
        } else if (this.instanceOfKnowledgeSource(node)) {
            JSITKnowledgeSource existingKnowledgeSource = (JSITKnowledgeSource)Js.uncheckedCast((Object)existingDRGElement);
            JSITKnowledgeSource nodeKnowledgeSource = (JSITKnowledgeSource)Js.uncheckedCast((Object)node);
            existingKnowledgeSource.setAuthorityRequirement(this.distinct(nodeKnowledgeSource.getAuthorityRequirement(), existingKnowledgeSource.getAuthorityRequirement()));
        }
    }

    private <T extends JSITDMNElement> List<T> distinct(List<T> list1, List<T> list2) {
        List combined = Stream.concat(list1.stream(), list2.stream()).collect(Collectors.toList());
        HashMap map = new HashMap();
        JsInteropUtils.forEach(combined, item -> map.putIfAbsent(item.getId(), Js.uncheckedCast((Object)item)));
        return new ArrayList(map.values());
    }

    boolean instanceOfBusinessKnowledgeModel(JSITDRGElement node) {
        return JSITBusinessKnowledgeModel.instanceOf((Object)node);
    }

    boolean instanceOfDecision(JSITDRGElement node) {
        return JSITDecision.instanceOf((Object)node);
    }

    boolean instanceOfKnowledgeSource(JSITDRGElement node) {
        return JSITKnowledgeSource.instanceOf((Object)node);
    }

    Optional<JSITDRGElement> getExistingNode(JSITDefinitions definitions, JSITDRGElement node) {
        JSITDRGElement[] existingDRGElement = new JSITDRGElement[1];
        JsInteropUtils.forEach(definitions.getDrgElement(), drgElement -> {
            if (Objects.equals(drgElement.getId(), node.getId())) {
                existingDRGElement[0] = drgElement;
            }
        });
        JSITDRGElement value = (JSITDRGElement)Js.uncheckedCast((Object)existingDRGElement[0]);
        return Optional.ofNullable(value);
    }

    private JSINodeLocalPartName getLocalPart(JSITDRGElement node) {
        if (JSITBusinessKnowledgeModel.instanceOf((Object)node)) {
            return JSINodeLocalPartName.BUSINESS_KNOWLEDGE_MODEL;
        }
        if (JSITDecision.instanceOf((Object)node)) {
            return JSINodeLocalPartName.DECISION;
        }
        if (JSITDecisionService.instanceOf((Object)node)) {
            return JSINodeLocalPartName.DECISION_SERVICE;
        }
        if (JSITInputData.instanceOf((Object)node)) {
            return JSINodeLocalPartName.INPUT_DATA;
        }
        if (JSITKnowledgeSource.instanceOf((Object)node)) {
            return JSINodeLocalPartName.KNOWLEDGE_SOURCE;
        }
        return JSINodeLocalPartName.UNKNOWN;
    }

    public List<Node> getNodeStream(Diagram diagram) {
        Graph graph = diagram.getGraph();
        return StreamSupport.stream(graph.nodes().spliterator(), false).collect(Collectors.toList());
    }

    private void connect(JSIDMNDiagram diagram, List<String> dmnDiagramElementIds, Definitions definitionsStunnerPojo, List<JSIDMNEdge> dmnEdges, Node<?, ?> node, View<?> view) {
        List inEdges = node.getInEdges();
        for (Edge e : inEdges) {
            DMNViewDefinition dmnViewDefinition;
            ViewConnector connectionContent;
            if (!(e.getContent() instanceof ViewConnector) || !(connectionContent = (ViewConnector)e.getContent()).getSourceConnection().isPresent() || !connectionContent.getTargetConnection().isPresent()) continue;
            Point2D sourcePoint = ((Connection)connectionContent.getSourceConnection().get()).getLocation();
            Point2D targetPoint = ((Connection)connectionContent.getTargetConnection().get()).getLocation();
            Node sourceNode = e.getSourceNode();
            View sourceView = (View)sourceNode.getContent();
            double xSource = PointUtils.xOfBound(PointUtils.upperLeftBound(sourceView));
            double ySource = PointUtils.yOfBound(PointUtils.upperLeftBound(sourceView));
            double xTarget = PointUtils.xOfBound(PointUtils.upperLeftBound(view));
            double yTarget = PointUtils.yOfBound(PointUtils.upperLeftBound(view));
            if (Objects.isNull(sourcePoint)) {
                if (sourceView.getDefinition() instanceof DMNViewDefinition) {
                    dmnViewDefinition = (DMNViewDefinition)sourceView.getDefinition();
                    xSource += dmnViewDefinition.getDimensionsSet().getWidth().getValue() / 2.0;
                    ySource += dmnViewDefinition.getDimensionsSet().getHeight().getValue() / 2.0;
                }
                sourcePoint = Point2D.create((double)xSource, (double)ySource);
            } else {
                sourcePoint = Point2D.create((double)(xSource + sourcePoint.getX()), (double)(ySource + sourcePoint.getY()));
            }
            if (Objects.isNull(targetPoint)) {
                if (view.getDefinition() instanceof DMNViewDefinition) {
                    dmnViewDefinition = (DMNViewDefinition)view.getDefinition();
                    xTarget += dmnViewDefinition.getDimensionsSet().getWidth().getValue() / 2.0;
                    yTarget += dmnViewDefinition.getDimensionsSet().getHeight().getValue() / 2.0;
                }
                targetPoint = Point2D.create((double)xTarget, (double)yTarget);
            } else {
                targetPoint = Point2D.create((double)(xTarget + targetPoint.getX()), (double)(yTarget + targetPoint.getY()));
            }
            JSIDMNEdge dmnEdge = new JSIDMNEdge();
            String uuid = IdUtils.getRawId(this.getUUID(e));
            String edgeId = IdUtils.getEdgeId(diagram, dmnDiagramElementIds, uuid);
            dmnEdge.setId(edgeId);
            String namespaceURI = definitionsStunnerPojo.getDefaultNamespace();
            dmnEdge.setDmnElementRef(new QName(namespaceURI, uuid, ""));
            dmnEdge.addWaypoint(PointUtils.point2dToDMNDIPoint(sourcePoint));
            for (ControlPoint cp : connectionContent.getControlPoints()) {
                dmnEdge.addWaypoint(PointUtils.point2dToDMNDIPoint(cp.getLocation()));
            }
            dmnEdge.addWaypoint(PointUtils.point2dToDMNDIPoint(targetPoint));
            dmnEdges.add(dmnEdge);
        }
    }

    private String getUUID(Edge<?, ?> edge) {
        View edgeView;
        Object definition;
        if (edge.getContent() instanceof View && (definition = (edgeView = (View)edge.getContent()).getDefinition()) instanceof Association) {
            Association association = (Association)definition;
            return association.getId().getValue();
        }
        return edge.getUUID();
    }

    public JSITDRGElement stunnerToDMN(Node<?, ?> node, Consumer<JSITComponentWidths> componentWidthsConsumer) {
        if (node.getContent() instanceof View) {
            View view = (View)node.getContent();
            if (view.getDefinition() instanceof InputData) {
                return this.inputDataConverter.dmnFromNode((Node<View<InputData>, ?>)node, componentWidthsConsumer);
            }
            if (view.getDefinition() instanceof Decision) {
                return this.decisionConverter.dmnFromNode((Node<View<Decision>, ?>)node, componentWidthsConsumer);
            }
            if (view.getDefinition() instanceof BusinessKnowledgeModel) {
                return this.bkmConverter.dmnFromNode((Node<View<BusinessKnowledgeModel>, ?>)node, componentWidthsConsumer);
            }
            if (view.getDefinition() instanceof KnowledgeSource) {
                return this.knowledgeSourceConverter.dmnFromNode((Node<View<KnowledgeSource>, ?>)node, componentWidthsConsumer);
            }
            if (view.getDefinition() instanceof DecisionService) {
                return this.decisionServiceConverter.dmnFromNode((Node<View<DecisionService>, ?>)node, componentWidthsConsumer);
            }
            throw new UnsupportedOperationException("Unsupported View type [" + view.getDefinition().getClass().getName() + "]");
        }
        throw new RuntimeException("Wrong diagram structure to marshall");
    }

    public static enum JSINodeLocalPartName {
        UNKNOWN("UNKNOWN"),
        BUSINESS_KNOWLEDGE_MODEL("businessKnowledgeModel"),
        DECISION("decision"),
        DECISION_SERVICE("decisionService"),
        INPUT_DATA("inputData"),
        KNOWLEDGE_SOURCE("knowledgeSource");

        private String localPart;

        private JSINodeLocalPartName(String localPart) {
            this.localPart = localPart;
        }

        public String getLocalPart() {
            return this.localPart;
        }
    }
}

