/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.marshaller.unmarshall.nodes;

import com.ait.lienzo.client.core.types.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import jsinterop.base.Js;
import org.kie.workbench.common.dmn.api.definition.model.Association;
import org.kie.workbench.common.dmn.api.definition.model.AuthorityRequirement;
import org.kie.workbench.common.dmn.api.definition.model.InformationRequirement;
import org.kie.workbench.common.dmn.api.definition.model.KnowledgeRequirement;
import org.kie.workbench.common.dmn.api.property.dmn.Description;
import org.kie.workbench.common.dmn.api.property.dmn.Id;
import org.kie.workbench.common.dmn.client.marshaller.common.IdUtils;
import org.kie.workbench.common.dmn.client.marshaller.common.JsInteropUtils;
import org.kie.workbench.common.dmn.client.marshaller.converters.dd.PointUtils;
import org.kie.workbench.common.dmn.client.marshaller.unmarshall.nodes.NodeEntry;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dc.JSIBounds;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dc.JSIPoint;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITAssociation;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITAuthorityRequirement;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITBusinessKnowledgeModel;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITDMNElement;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITDMNElementReference;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITDecision;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITDecisionService;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITInformationRequirement;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITKnowledgeRequirement;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITKnowledgeSource;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmndi12.JSIDMNDiagram;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmndi12.JSIDMNEdge;
import org.kie.workbench.common.stunner.core.api.FactoryManager;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableAdapterUtils;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.relationship.Child;
import org.kie.workbench.common.stunner.core.graph.content.view.Connection;
import org.kie.workbench.common.stunner.core.graph.content.view.ControlPoint;
import org.kie.workbench.common.stunner.core.graph.content.view.MagnetConnection;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewConnector;
import org.kie.workbench.common.stunner.core.graph.impl.EdgeImpl;

@Dependent
public class NodeConnector {
    private final FactoryManager factoryManager;
    private static final double CENTRE_TOLERANCE = 1.0;
    private static final String INFO_REQ_ID = BindableAdapterUtils.getDefinitionId(InformationRequirement.class);
    private static final String KNOWLEDGE_REQ_ID = BindableAdapterUtils.getDefinitionId(KnowledgeRequirement.class);
    private static final String AUTH_REQ_ID = BindableAdapterUtils.getDefinitionId(AuthorityRequirement.class);
    private static final String ASSOCIATION_ID = BindableAdapterUtils.getDefinitionId(Association.class);

    @Inject
    public NodeConnector(FactoryManager factoryManager) {
        this.factoryManager = factoryManager;
    }

    void connect(JSIDMNDiagram dmnDiagram, List<JSIDMNEdge> edges, List<JSITAssociation> associations, List<NodeEntry> nodeEntries) {
        Map<String, List<NodeEntry>> entriesById = this.makeNodeIndex(nodeEntries);
        String diagramId = dmnDiagram.getId();
        ArrayList<JSIDMNEdge> pendingEdges = new ArrayList<JSIDMNEdge>(edges);
        for (NodeEntry nodeEntry : nodeEntries) {
            JSITDMNElement element = nodeEntry.getDmnElement();
            Node node = nodeEntry.getNode();
            if (nodeEntry.isIncluded()) continue;
            if (JSITDecision.instanceOf((Object)element)) {
                JSITDecision decision = (JSITDecision)Js.uncheckedCast((Object)element);
                List jsiInformationRequirements = decision.getInformationRequirement();
                for (int i = 0; i < jsiInformationRequirements.size(); ++i) {
                    JSITInformationRequirement ir = (JSITInformationRequirement)Js.uncheckedCast(jsiInformationRequirements.get(i));
                    this.connectEdgeToNodes(INFO_REQ_ID, (JSITDMNElement)ir, ir.getRequiredInput(), entriesById, diagramId, edges, pendingEdges, node);
                    this.connectEdgeToNodes(INFO_REQ_ID, (JSITDMNElement)ir, ir.getRequiredDecision(), entriesById, diagramId, edges, pendingEdges, node);
                }
                List jsiKnowledgeRequirements = decision.getKnowledgeRequirement();
                for (int i = 0; i < jsiKnowledgeRequirements.size(); ++i) {
                    JSITKnowledgeRequirement kr = (JSITKnowledgeRequirement)Js.uncheckedCast(jsiKnowledgeRequirements.get(i));
                    this.connectEdgeToNodes(KNOWLEDGE_REQ_ID, (JSITDMNElement)kr, kr.getRequiredKnowledge(), entriesById, diagramId, edges, pendingEdges, node);
                }
                List jsiAuthorityRequirements = decision.getAuthorityRequirement();
                for (int i = 0; i < jsiAuthorityRequirements.size(); ++i) {
                    JSITAuthorityRequirement ar = (JSITAuthorityRequirement)Js.uncheckedCast(jsiAuthorityRequirements.get(i));
                    this.connectEdgeToNodes(AUTH_REQ_ID, (JSITDMNElement)ar, ar.getRequiredAuthority(), entriesById, diagramId, edges, pendingEdges, node);
                }
                continue;
            }
            if (JSITBusinessKnowledgeModel.instanceOf((Object)element)) {
                JSITBusinessKnowledgeModel bkm = (JSITBusinessKnowledgeModel)Js.uncheckedCast((Object)element);
                List jsiKnowledgeRequirements = bkm.getKnowledgeRequirement();
                for (int i = 0; i < jsiKnowledgeRequirements.size(); ++i) {
                    JSITKnowledgeRequirement kr = (JSITKnowledgeRequirement)Js.uncheckedCast(jsiKnowledgeRequirements.get(i));
                    this.connectEdgeToNodes(KNOWLEDGE_REQ_ID, (JSITDMNElement)kr, kr.getRequiredKnowledge(), entriesById, diagramId, edges, pendingEdges, node);
                }
                List jsiAuthorityRequirements = bkm.getAuthorityRequirement();
                for (int i = 0; i < jsiAuthorityRequirements.size(); ++i) {
                    JSITAuthorityRequirement ar = (JSITAuthorityRequirement)Js.uncheckedCast(jsiAuthorityRequirements.get(i));
                    this.connectEdgeToNodes(AUTH_REQ_ID, (JSITDMNElement)ar, ar.getRequiredAuthority(), entriesById, diagramId, edges, pendingEdges, node);
                }
                continue;
            }
            if (JSITKnowledgeSource.instanceOf((Object)element)) {
                JSITKnowledgeSource ks = (JSITKnowledgeSource)Js.uncheckedCast((Object)element);
                List jsiAuthorityRequirements = ks.getAuthorityRequirement();
                for (int i = 0; i < jsiAuthorityRequirements.size(); ++i) {
                    JSITAuthorityRequirement ar = (JSITAuthorityRequirement)Js.uncheckedCast(jsiAuthorityRequirements.get(i));
                    this.connectEdgeToNodes(AUTH_REQ_ID, (JSITDMNElement)ar, ar.getRequiredInput(), entriesById, diagramId, edges, pendingEdges, node);
                    this.connectEdgeToNodes(AUTH_REQ_ID, (JSITDMNElement)ar, ar.getRequiredDecision(), entriesById, diagramId, edges, pendingEdges, node);
                    this.connectEdgeToNodes(AUTH_REQ_ID, (JSITDMNElement)ar, ar.getRequiredAuthority(), entriesById, diagramId, edges, pendingEdges, node);
                }
                continue;
            }
            if (!JSITDecisionService.instanceOf((Object)element)) continue;
            JSITDecisionService ds = (JSITDecisionService)Js.uncheckedCast((Object)element);
            List encapsulatedDecisions = ds.getEncapsulatedDecision();
            JsInteropUtils.forEach(encapsulatedDecisions, er -> {
                String reqInputID = this.getId((JSITDMNElementReference)er);
                this.getNode(nodeEntry, reqInputID, entriesById).ifPresent(requiredNode -> this.connectDSChildEdge(node, (Node)requiredNode));
            });
            List outputDecisions = ds.getOutputDecision();
            JsInteropUtils.forEach(outputDecisions, er -> {
                String reqInputID = this.getId((JSITDMNElementReference)er);
                this.getNode(nodeEntry, reqInputID, entriesById).ifPresent(requiredNode -> this.connectDSChildEdge(node, (Node)requiredNode));
            });
        }
        JsInteropUtils.forEach(associations, association -> {
            boolean targetPresent;
            String sourceId = this.getId(association.getSourceRef());
            String targetId = this.getId(association.getTargetRef());
            List source = (List)entriesById.get(sourceId);
            List target = (List)entriesById.get(targetId);
            boolean sourcePresent = source != null && source.size() > 0;
            boolean bl = targetPresent = target != null && target.size() > 0;
            if (sourcePresent && targetPresent) {
                NodeEntry sourceEntry = (NodeEntry)source.get(0);
                NodeEntry targetEntry = (NodeEntry)target.get(0);
                Node sourceNode = sourceEntry.getNode();
                Node targetNode = targetEntry.getNode();
                Edge myEdge = this.factoryManager.newElement(diagramId + "#" + association.getId(), ASSOCIATION_ID).asEdge();
                ViewConnector connectionContent = (ViewConnector)myEdge.getContent();
                Id id = new Id(association.getId());
                Description description = new Description(association.getDescription());
                Association definition = new Association(id, description);
                this.connectEdge(myEdge, sourceNode, targetNode);
                connectionContent.setDefinition((Object)definition);
                connectionContent.setTargetConnection((Connection)MagnetConnection.Builder.atCenter((Element)targetNode));
                connectionContent.setSourceConnection((Connection)MagnetConnection.Builder.atCenter((Element)sourceNode));
            }
        });
    }

    private Optional<Node> getNode(NodeEntry decisionServiceEntry, String internalDMNElementId, Map<String, List<NodeEntry>> entriesById) {
        JSIBounds decisionServiceBounds = decisionServiceEntry.getDmnShape().getBounds();
        for (Map.Entry<String, List<NodeEntry>> entry : entriesById.entrySet()) {
            String id = entry.getKey();
            List<NodeEntry> entries = entry.getValue();
            if (!id.contains(internalDMNElementId)) continue;
            for (NodeEntry nodeEntry : entries) {
                boolean innerY;
                JSIBounds nodeBounds = nodeEntry.getDmnShape().getBounds();
                boolean b = nodeBounds.getX() + nodeBounds.getWidth() < decisionServiceBounds.getX() + decisionServiceBounds.getWidth();
                boolean b1 = nodeBounds.getX() > decisionServiceBounds.getX();
                boolean innerX = b1 && b;
                boolean b2 = nodeBounds.getY() + nodeBounds.getHeight() < decisionServiceBounds.getY() + decisionServiceBounds.getHeight();
                boolean b3 = nodeBounds.getY() > decisionServiceBounds.getY();
                boolean bl = innerY = b2 && b3;
                if (!innerX || !innerY) continue;
                return Optional.of(nodeEntry.getNode());
            }
        }
        return Optional.empty();
    }

    private Map<String, List<NodeEntry>> makeNodeIndex(List<NodeEntry> nodeEntries) {
        HashMap<String, List<NodeEntry>> map = new HashMap<String, List<NodeEntry>>();
        nodeEntries.forEach(nodeEntry -> {
            String dmnElementId = nodeEntry.getDmnElement().getId();
            map.putIfAbsent(dmnElementId, new ArrayList());
            ((List)map.get(dmnElementId)).add(nodeEntry);
        });
        return map;
    }

    private void connectDSChildEdge(Node dsNode, Node requiredNode) {
        String uuid = dsNode.getUUID() + "er" + requiredNode.getUUID();
        EdgeImpl myEdge = new EdgeImpl(uuid);
        myEdge.setContent((Object)new Child());
        this.connectEdge((Edge)myEdge, dsNode, requiredNode);
    }

    private String getId(JSITDMNElementReference er) {
        String href = er.getHref();
        return href.contains("#") ? href.substring(href.indexOf(35) + 1) : href;
    }

    private void connectEdgeToNodes(String connectorTypeId, JSITDMNElement jsiDMNElement, JSITDMNElementReference jsiDMNElementReference, Map<String, List<NodeEntry>> entriesById, String diagramId, List<JSIDMNEdge> edges, List<JSIDMNEdge> pendingEdges, Node currentNode) {
        if (Objects.nonNull(jsiDMNElementReference) && !edges.isEmpty()) {
            String reqInputID = this.getId(jsiDMNElementReference);
            List<NodeEntry> nodeEntries = entriesById.get(reqInputID);
            Optional<JSIDMNEdge> dmnEdgeOpt = edges.stream().filter(e -> {
                String localPart = e.getDmnElementRef().getLocalPart();
                String id = jsiDMNElement.getId();
                return Objects.equals(localPart, id);
            }).findFirst();
            if (nodeEntries != null && nodeEntries.size() > 0) {
                String id;
                Node requiredNode;
                JSIDMNEdge dmnEdge;
                if (dmnEdgeOpt.isPresent()) {
                    dmnEdge = (JSIDMNEdge)Js.uncheckedCast((Object)dmnEdgeOpt.get());
                    requiredNode = this.getNode(dmnEdge, nodeEntries);
                    id = dmnEdge.getDmnElementRef().getLocalPart();
                    pendingEdges.remove(dmnEdge);
                } else if (edges.isEmpty()) {
                    dmnEdge = new JSIDMNEdge();
                    JSIPoint point = new JSIPoint();
                    point.setX(0.0);
                    point.setY(0.0);
                    dmnEdge.addAllWaypoint(new JSIPoint[]{point, point});
                    NodeEntry nodeEntry = nodeEntries.get(0);
                    requiredNode = nodeEntry.getNode();
                    id = nodeEntry.getDmnElement().getId();
                } else {
                    return;
                }
                Edge myEdge = this.factoryManager.newElement(IdUtils.getPrefixedId(diagramId, id), connectorTypeId).asEdge();
                ViewConnector connectionContent = (ViewConnector)myEdge.getContent();
                this.connectEdge(myEdge, requiredNode, currentNode);
                this.setConnectionMagnets(myEdge, connectionContent, dmnEdge);
            }
        }
    }

    private void connectEdge(Edge edge, Node source, Node target) {
        edge.setSourceNode(source);
        edge.setTargetNode(target);
        source.getOutEdges().add(edge);
        target.getInEdges().add(edge);
    }

    private void setConnectionMagnets(Edge edge, ViewConnector connectionContent, JSIDMNEdge jsidmnEdge) {
        JSIDMNEdge e = (JSIDMNEdge)Js.uncheckedCast((Object)jsidmnEdge);
        JSIPoint source = (JSIPoint)Js.uncheckedCast(e.getWaypoint().get(0));
        Node sourceNode = edge.getSourceNode();
        if (null != sourceNode) {
            this.setConnectionMagnet(sourceNode, source, arg_0 -> ((ViewConnector)connectionContent).setSourceConnection(arg_0));
        }
        JSIPoint target = (JSIPoint)Js.uncheckedCast(e.getWaypoint().get(e.getWaypoint().size() - 1));
        Node targetNode = edge.getTargetNode();
        if (null != targetNode) {
            this.setConnectionMagnet(targetNode, target, arg_0 -> ((ViewConnector)connectionContent).setTargetConnection(arg_0));
        }
        if (e.getWaypoint().size() > 2) {
            connectionContent.setControlPoints((ControlPoint[])e.getWaypoint().subList(1, e.getWaypoint().size() - 1).stream().map(p -> ControlPoint.build((org.kie.workbench.common.stunner.core.graph.content.view.Point2D)PointUtils.dmndiPointToPoint2D(p))).toArray(ControlPoint[]::new));
        }
    }

    private void setConnectionMagnet(Node<View<?>, Edge> node, JSIPoint magnetPoint, Consumer<Connection> connectionConsumer) {
        double viewHeight;
        double viewWidth;
        double magnetRelativeY;
        View view = (View)node.getContent();
        double viewX = PointUtils.xOfBound(PointUtils.upperLeftBound(view));
        double viewY = PointUtils.yOfBound(PointUtils.upperLeftBound(view));
        double magnetRelativeX = magnetPoint.getX() - viewX;
        if (this.isCentre(magnetRelativeX, magnetRelativeY = magnetPoint.getY() - viewY, viewWidth = view.getBounds().getWidth(), viewHeight = view.getBounds().getHeight())) {
            connectionConsumer.accept((Connection)MagnetConnection.Builder.atCenter(node));
        } else {
            connectionConsumer.accept((Connection)MagnetConnection.Builder.at((double)magnetRelativeX, (double)magnetRelativeY).setAuto(true));
        }
    }

    private boolean isCentre(double magnetRelativeX, double magnetRelativeY, double viewWidth, double viewHeight) {
        return Math.abs(viewWidth / 2.0 - magnetRelativeX) < 1.0 && Math.abs(viewHeight / 2.0 - magnetRelativeY) < 1.0;
    }

    private Node getNode(JSIDMNEdge jsidmnEdge, List<NodeEntry> entries) {
        if (entries.size() == 1) {
            return entries.get(0).getNode();
        }
        JSIPoint jsiSource = (JSIPoint)Js.uncheckedCast(jsidmnEdge.getWaypoint().get(0));
        Point2D source = new Point2D(jsiSource.getX(), jsiSource.getY());
        HashMap<Point2D, NodeEntry> entriesByPoint2D = new HashMap<Point2D, NodeEntry>();
        for (NodeEntry entry : entries) {
            JSIBounds bounds = entry.getDmnShape().getBounds();
            double centerX = bounds.getX() + bounds.getWidth() / 2.0;
            double centerY = bounds.getY() + bounds.getHeight() / 2.0;
            entriesByPoint2D.put(new Point2D(centerX, centerY), entry);
        }
        Point2D nearest = (Point2D)Collections.min(entriesByPoint2D.keySet(), (point1, point2) -> {
            Double distance1 = source.distance(point1);
            Double distance2 = source.distance(point2);
            return distance1.compareTo(distance2);
        });
        return ((NodeEntry)entriesByPoint2D.get(nearest)).getNode();
    }
}

