/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.marshaller.unmarshall.nodes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.namespace.QName;
import jsinterop.base.Js;
import org.kie.workbench.common.dmn.api.definition.HasComponentWidths;
import org.kie.workbench.common.dmn.client.marshaller.common.IdUtils;
import org.kie.workbench.common.dmn.client.marshaller.common.JsInteropUtils;
import org.kie.workbench.common.dmn.client.marshaller.unmarshall.nodes.NodeEntry;
import org.kie.workbench.common.dmn.client.marshaller.unmarshall.nodes.StunnerConverter;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dc.JSIBounds;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITDMNElement;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITDRGElement;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITTextAnnotation;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmndi12.JSIDMNDiagram;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmndi12.JSIDMNShape;
import org.kie.workbench.common.stunner.core.graph.Node;

class NodeEntriesBuilder {
    private final Map<JSIDMNShape, String> shapesByDiagramId = new HashMap<JSIDMNShape, String>();
    private final List<JSITDRGElement> drgElements = new ArrayList<JSITDRGElement>();
    private final List<JSITDRGElement> includedDRGElements = new ArrayList<JSITDRGElement>();
    private final List<JSIDMNDiagram> dmnDiagrams = new ArrayList<JSIDMNDiagram>();
    private final List<JSITTextAnnotation> textAnnotations = new ArrayList<JSITTextAnnotation>();
    private final StunnerConverter nodeFactory;
    private BiConsumer<String, HasComponentWidths> componentWidthsConsumer;

    NodeEntriesBuilder(StunnerConverter nodeFactory) {
        this.nodeFactory = nodeFactory;
    }

    List<NodeEntry> buildEntries() {
        boolean modelDoesNotHaveDMNDI;
        boolean modelHasDMNDI;
        boolean bl = modelHasDMNDI = this.shapesByDiagramId.size() > 0;
        if (modelHasDMNDI) {
            return this.shapesByDiagramId.entrySet().stream().map(entry -> {
                String diagramId = (String)entry.getValue();
                JSIDMNShape shape = (JSIDMNShape)Js.uncheckedCast(entry.getKey());
                return this.makeEntry(diagramId, shape);
            }).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        }
        List<JSITDMNElement> dmnElements = this.getDMNElements();
        boolean bl2 = modelDoesNotHaveDMNDI = this.dmnDiagrams.size() == 1 && dmnElements.size() > 0;
        if (modelDoesNotHaveDMNDI) {
            return dmnElements.stream().map(dmnElement -> {
                JSIDMNDiagram diagram = (JSIDMNDiagram)Js.uncheckedCast((Object)this.dmnDiagrams.get(0));
                String diagramId = diagram.getId();
                return this.makeEntry(diagramId, this.makeStandardShape(), (JSITDMNElement)dmnElement);
            }).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    NodeEntriesBuilder withShapesByDiagramId(Map<JSIDMNShape, String> shapesByDiagramId) {
        this.shapesByDiagramId.putAll(shapesByDiagramId);
        return this;
    }

    NodeEntriesBuilder withDRGElements(List<JSITDRGElement> drgElements) {
        this.drgElements.addAll(drgElements);
        return this;
    }

    NodeEntriesBuilder withTextAnnotations(List<JSITTextAnnotation> textAnnotations) {
        this.textAnnotations.addAll(textAnnotations);
        return this;
    }

    NodeEntriesBuilder withIncludedDRGElements(List<JSITDRGElement> includedDRGElements) {
        this.includedDRGElements.addAll(includedDRGElements);
        return this;
    }

    public NodeEntriesBuilder withDMNDiagrams(List<JSIDMNDiagram> dmnDiagrams) {
        this.dmnDiagrams.addAll(dmnDiagrams);
        return this;
    }

    NodeEntriesBuilder withComponentWidthsConsumer(BiConsumer<String, HasComponentWidths> componentWidthsConsumer) {
        this.componentWidthsConsumer = componentWidthsConsumer;
        return this;
    }

    private Optional<NodeEntry> makeEntry(String diagramId, JSIDMNShape shape) {
        return this.getDMNElement(shape).map(dmnElement -> this.makeEntry(diagramId, shape, (JSITDMNElement)dmnElement));
    }

    private NodeEntry makeEntry(String diagramId, JSIDMNShape shape, JSITDMNElement dmnElement) {
        NodeEntry nodeEntry = new NodeEntry(diagramId, this.copy(shape), dmnElement, this.isIncluded(dmnElement), this.componentWidthsConsumer);
        Node node = this.nodeFactory.make(nodeEntry);
        nodeEntry.setNode(node);
        return nodeEntry;
    }

    private JSIDMNShape copy(JSIDMNShape shape) {
        JSIDMNShape copy = (JSIDMNShape)Js.uncheckedCast((Object)JsInteropUtils.jsCopy(shape));
        copy.setId(IdUtils.uniqueId());
        return copy;
    }

    private boolean isIncluded(JSITDMNElement dmnElement) {
        JSITDRGElement drgElement = (JSITDRGElement)Js.uncheckedCast((Object)dmnElement);
        return this.includedDRGElements.contains(drgElement);
    }

    private Optional<JSITDMNElement> getDMNElement(JSIDMNShape shape) {
        return this.getDMNElements().stream().filter(dmnElement -> {
            QName dmnElementRef = shape.getDmnElementRef();
            String dmnElementId = dmnElement.getId();
            return dmnElementRef.getLocalPart().endsWith(dmnElementId);
        }).findFirst();
    }

    private JSIDMNShape makeStandardShape() {
        JSIDMNShape jsidmnShape = new JSIDMNShape();
        JSIBounds boundsParam = new JSIBounds();
        boundsParam.setX(0.0);
        boundsParam.setY(0.0);
        boundsParam.setWidth(100.0);
        boundsParam.setHeight(50.0);
        jsidmnShape.setBounds(boundsParam);
        return jsidmnShape;
    }

    private List<JSITDMNElement> getDMNElements() {
        return Stream.of(this.drgElements, this.includedDRGElements, this.textAnnotations).flatMap(Collection::stream).collect(Collectors.toList());
    }
}

