/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.marshaller.unmarshall.nodes;

import java.util.function.BiConsumer;
import jsinterop.base.Js;
import org.kie.workbench.common.dmn.api.definition.HasComponentWidths;
import org.kie.workbench.common.dmn.client.marshaller.common.IdUtils;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITDMNElement;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITNamedElement;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITTextAnnotation;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmndi12.JSIDMNShape;
import org.kie.workbench.common.stunner.core.graph.Node;

public class NodeEntry {
    private String name;
    private Node node;
    private final String id = IdUtils.uniqueId();
    private final String diagramId;
    private final JSIDMNShape dmnShape;
    private final boolean isIncluded;
    private final JSITDMNElement dmnElement;
    private final BiConsumer<String, HasComponentWidths> componentWidthsConsumer;

    NodeEntry(String diagramId, JSIDMNShape dmnShape, JSITDMNElement dmnElement, boolean isIncluded, BiConsumer<String, HasComponentWidths> componentWidthsConsumer) {
        this.diagramId = diagramId;
        this.dmnShape = dmnShape;
        this.dmnElement = dmnElement;
        this.isIncluded = isIncluded;
        this.componentWidthsConsumer = componentWidthsConsumer;
    }

    public JSIDMNShape getDmnShape() {
        return this.dmnShape;
    }

    public JSITDMNElement getDmnElement() {
        return this.dmnElement;
    }

    public BiConsumer<String, HasComponentWidths> getComponentWidthsConsumer() {
        return this.componentWidthsConsumer;
    }

    public String getId() {
        return this.id;
    }

    public boolean isIncluded() {
        return this.isIncluded;
    }

    public Node getNode() {
        return this.node;
    }

    public void setNode(Node node) {
        this.node = node;
    }

    public String getDiagramId() {
        return this.diagramId;
    }

    public String getName() {
        if (this.name == null) {
            String type;
            switch (type = this.dmnElement.getTYPE_NAME()) {
                case "DMN12.TBusinessKnowledgeModel": 
                case "DMN12.TDecision": 
                case "DMN12.TDecisionService": 
                case "DMN12.TInputData": 
                case "DMN12.TKnowledgeSource": {
                    JSITNamedElement drgElement = (JSITNamedElement)Js.uncheckedCast((Object)this.dmnElement);
                    this.name = drgElement.getName();
                    break;
                }
                case "DMN12.TTextAnnotation": {
                    JSITTextAnnotation textAnnotation = (JSITTextAnnotation)Js.uncheckedCast((Object)this.dmnElement);
                    this.name = textAnnotation.getText();
                }
            }
        }
        return this.name;
    }
}

