/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.marshaller.unmarshall.nodes;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import jsinterop.base.Js;
import org.kie.workbench.common.dmn.api.definition.model.BusinessKnowledgeModel;
import org.kie.workbench.common.dmn.api.definition.model.DRGElement;
import org.kie.workbench.common.dmn.api.definition.model.Decision;
import org.kie.workbench.common.dmn.api.definition.model.DecisionService;
import org.kie.workbench.common.dmn.api.definition.model.InputData;
import org.kie.workbench.common.dmn.api.definition.model.KnowledgeSource;
import org.kie.workbench.common.dmn.api.definition.model.TextAnnotation;
import org.kie.workbench.common.dmn.api.property.background.BackgroundSet;
import org.kie.workbench.common.dmn.api.property.background.BgColour;
import org.kie.workbench.common.dmn.api.property.background.BorderColour;
import org.kie.workbench.common.dmn.api.property.dimensions.Height;
import org.kie.workbench.common.dmn.api.property.dimensions.RectangleDimensionsSet;
import org.kie.workbench.common.dmn.api.property.dimensions.Width;
import org.kie.workbench.common.dmn.api.property.dmn.DecisionServiceDividerLineY;
import org.kie.workbench.common.dmn.api.property.font.FontSet;
import org.kie.workbench.common.dmn.client.marshaller.converters.BusinessKnowledgeModelConverter;
import org.kie.workbench.common.dmn.client.marshaller.converters.DecisionConverter;
import org.kie.workbench.common.dmn.client.marshaller.converters.DecisionServiceConverter;
import org.kie.workbench.common.dmn.client.marshaller.converters.InputDataConverter;
import org.kie.workbench.common.dmn.client.marshaller.converters.KnowledgeSourceConverter;
import org.kie.workbench.common.dmn.client.marshaller.converters.NodeConverter;
import org.kie.workbench.common.dmn.client.marshaller.converters.TextAnnotationConverter;
import org.kie.workbench.common.dmn.client.marshaller.converters.dd.ColorUtils;
import org.kie.workbench.common.dmn.client.marshaller.converters.dd.FontSetPropertyConverter;
import org.kie.workbench.common.dmn.client.marshaller.converters.dd.PointUtils;
import org.kie.workbench.common.dmn.client.marshaller.unmarshall.nodes.NodeEntry;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dc.JSIPoint;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.di.JSIStyle;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmndi12.JSIDMNDecisionServiceDividerLine;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmndi12.JSIDMNShape;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmndi12.JSIDMNStyle;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.mapper.JsUtils;
import org.kie.workbench.common.stunner.core.api.FactoryManager;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.Bound;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;

@Dependent
public class StunnerConverter {
    private BusinessKnowledgeModelConverter bkmConverter;
    private DecisionConverter decisionConverter;
    private DecisionServiceConverter decisionServiceConverter;
    private InputDataConverter inputDataConverter;
    private KnowledgeSourceConverter knowledgeSourceConverter;
    private TextAnnotationConverter textAnnotationConverter;

    @Inject
    public StunnerConverter(FactoryManager factoryManager) {
        this.bkmConverter = new BusinessKnowledgeModelConverter(factoryManager);
        this.decisionConverter = new DecisionConverter(factoryManager);
        this.decisionServiceConverter = new DecisionServiceConverter(factoryManager);
        this.inputDataConverter = new InputDataConverter(factoryManager);
        this.knowledgeSourceConverter = new KnowledgeSourceConverter(factoryManager);
        this.textAnnotationConverter = new TextAnnotationConverter(factoryManager);
    }

    Node make(NodeEntry nodeEntry) {
        Node<View<?>, ?> node = this.getConverter(nodeEntry).nodeFromDMN(nodeEntry);
        this.ddExtAugmentStunner(node, nodeEntry.getDmnShape());
        this.setAllowOnlyVisualChange(node, nodeEntry.isIncluded());
        return node;
    }

    private void setAllowOnlyVisualChange(Node node, boolean included) {
        this.getDRGElement(node).ifPresent(drgElement -> drgElement.setAllowOnlyVisualChange(included));
    }

    private Optional<DRGElement> getDRGElement(Node node) {
        Object objectDefinition = DefinitionUtils.getElementDefinition((Element)node);
        if (objectDefinition instanceof DRGElement) {
            return Optional.of((DRGElement)objectDefinition);
        }
        return Optional.empty();
    }

    private NodeConverter<?, ?> getConverter(NodeEntry nodeEntry) {
        String type;
        switch (type = nodeEntry.getDmnElement().getTYPE_NAME()) {
            case "DMN12.TBusinessKnowledgeModel": {
                return this.bkmConverter;
            }
            case "DMN12.TDecision": {
                return this.decisionConverter;
            }
            case "DMN12.TDecisionService": {
                return this.decisionServiceConverter;
            }
            case "DMN12.TInputData": {
                return this.inputDataConverter;
            }
            case "DMN12.TKnowledgeSource": {
                return this.knowledgeSourceConverter;
            }
            case "DMN12.TTextAnnotation": {
                return this.textAnnotationConverter;
            }
        }
        throw new UnsupportedOperationException("Unsupported DRGElement type [" + type + "]");
    }

    private void ddExtAugmentStunner(Node currentNode, JSIDMNShape shape) {
        View content = (View)currentNode.getContent();
        Bound ulBound = PointUtils.upperLeftBound(content);
        Bound lrBound = PointUtils.lowerRightBound(content);
        Object definition = content.getDefinition();
        if (definition instanceof Decision) {
            Decision decision = (Decision)definition;
            this.internalAugment(shape, ulBound, (RectangleDimensionsSet)decision.getDimensionsSet(), lrBound, decision.getBackgroundSet(), arg_0 -> ((Decision)decision).setFontSet(arg_0), line -> {});
        } else if (definition instanceof InputData) {
            InputData inputData = (InputData)definition;
            this.internalAugment(shape, ulBound, (RectangleDimensionsSet)inputData.getDimensionsSet(), lrBound, inputData.getBackgroundSet(), arg_0 -> ((InputData)inputData).setFontSet(arg_0), line -> {});
        } else if (definition instanceof BusinessKnowledgeModel) {
            BusinessKnowledgeModel businessKnowledgeModel = (BusinessKnowledgeModel)definition;
            this.internalAugment(shape, ulBound, (RectangleDimensionsSet)businessKnowledgeModel.getDimensionsSet(), lrBound, businessKnowledgeModel.getBackgroundSet(), arg_0 -> ((BusinessKnowledgeModel)businessKnowledgeModel).setFontSet(arg_0), line -> {});
        } else if (definition instanceof KnowledgeSource) {
            KnowledgeSource knowledgeSource = (KnowledgeSource)definition;
            this.internalAugment(shape, ulBound, (RectangleDimensionsSet)knowledgeSource.getDimensionsSet(), lrBound, knowledgeSource.getBackgroundSet(), arg_0 -> ((KnowledgeSource)knowledgeSource).setFontSet(arg_0), line -> {});
        } else if (definition instanceof TextAnnotation) {
            TextAnnotation textAnnotation = (TextAnnotation)definition;
            this.internalAugment(shape, ulBound, (RectangleDimensionsSet)textAnnotation.getDimensionsSet(), lrBound, textAnnotation.getBackgroundSet(), arg_0 -> ((TextAnnotation)textAnnotation).setFontSet(arg_0), line -> {});
        } else if (definition instanceof DecisionService) {
            DecisionService decisionService = (DecisionService)definition;
            this.internalAugment(shape, ulBound, (RectangleDimensionsSet)decisionService.getDimensionsSet(), lrBound, decisionService.getBackgroundSet(), arg_0 -> ((DecisionService)decisionService).setFontSet(arg_0), dividerLineY -> decisionService.setDividerLineY(new DecisionServiceDividerLineY(Double.valueOf(dividerLineY - ulBound.getY()))));
        }
    }

    private void internalAugment(JSIDMNShape drgShape, Bound ulBound, RectangleDimensionsSet dimensionsSet, Bound lrBound, BackgroundSet bgset, Consumer<FontSet> fontSetSetter, Consumer<Double> decisionServiceDividerLineYSetter) {
        if (Objects.nonNull(ulBound)) {
            ulBound.setX(Double.valueOf(PointUtils.xOfShape(drgShape)));
            ulBound.setY(Double.valueOf(PointUtils.yOfShape(drgShape)));
        }
        dimensionsSet.setWidth(new Width(Double.valueOf(PointUtils.widthOfShape(drgShape))));
        dimensionsSet.setHeight(new Height(Double.valueOf(PointUtils.heightOfShape(drgShape))));
        if (Objects.nonNull(lrBound)) {
            lrBound.setX(Double.valueOf(PointUtils.xOfShape(drgShape) + PointUtils.widthOfShape(drgShape)));
            lrBound.setY(Double.valueOf(PointUtils.yOfShape(drgShape) + PointUtils.heightOfShape(drgShape)));
        }
        this.internalAugmentStyles(drgShape, bgset, fontSetSetter);
        if (Objects.nonNull(drgShape.getDMNDecisionServiceDividerLine())) {
            JSIDMNDecisionServiceDividerLine divider = (JSIDMNDecisionServiceDividerLine)Js.uncheckedCast((Object)drgShape.getDMNDecisionServiceDividerLine());
            List dividerPoints = divider.getWaypoint();
            JSIPoint dividerY = (JSIPoint)Js.uncheckedCast(dividerPoints.get(0));
            decisionServiceDividerLineYSetter.accept(dividerY.getY());
        }
    }

    private void internalAugmentStyles(JSIDMNShape drgShape, BackgroundSet bgset, Consumer<FontSet> fontSetSetter) {
        JSIDMNStyle dmnStyleOfDrgShape;
        JSIStyle jsiStyle = drgShape.getStyle();
        if (Objects.isNull(jsiStyle)) {
            return;
        }
        JSIStyle drgStyle = (JSIStyle)Js.uncheckedCast((Object)JsUtils.getUnwrappedElement((Object)jsiStyle));
        JSIDMNStyle jSIDMNStyle = dmnStyleOfDrgShape = JSIDMNStyle.instanceOf((Object)drgStyle) ? (JSIDMNStyle)Js.uncheckedCast((Object)drgStyle) : null;
        if (Objects.nonNull(dmnStyleOfDrgShape)) {
            if (Objects.nonNull(dmnStyleOfDrgShape.getFillColor())) {
                bgset.setBgColour(new BgColour(ColorUtils.wbFromDMN(dmnStyleOfDrgShape.getFillColor())));
            }
            if (Objects.nonNull(dmnStyleOfDrgShape.getStrokeColor())) {
                bgset.setBorderColour(new BorderColour(ColorUtils.wbFromDMN(dmnStyleOfDrgShape.getStrokeColor())));
            }
        }
        FontSet fontSet = new FontSet();
        if (Objects.nonNull(dmnStyleOfDrgShape)) {
            this.mergeFontSet(fontSet, FontSetPropertyConverter.wbFromDMN(dmnStyleOfDrgShape));
        }
        if (Objects.nonNull(drgShape.getDMNLabel())) {
            JSIDMNShape jsiLabel = (JSIDMNShape)Js.uncheckedCast((Object)drgShape.getDMNLabel());
            JSIStyle jsiLabelStyle = jsiLabel.getStyle();
            Object jsiLabelSharedStyle = Js.uncheckedCast((Object)jsiLabel.getSharedStyle());
            if (Objects.nonNull(jsiLabelSharedStyle) && JSIDMNStyle.instanceOf((Object)jsiLabelSharedStyle)) {
                this.mergeFontSet(fontSet, FontSetPropertyConverter.wbFromDMN((JSIDMNStyle)Js.uncheckedCast((Object)jsiLabelSharedStyle)));
            }
            if (Objects.nonNull(jsiLabelStyle) && JSIDMNStyle.instanceOf((Object)jsiLabelStyle)) {
                this.mergeFontSet(fontSet, FontSetPropertyConverter.wbFromDMN((JSIDMNStyle)Js.uncheckedCast((Object)jsiLabelStyle)));
            }
        }
        fontSetSetter.accept(fontSet);
    }

    private void mergeFontSet(FontSet fontSet, FontSet additional) {
        if (Objects.nonNull(additional.getFontFamily())) {
            fontSet.setFontFamily(additional.getFontFamily());
        }
        if (Objects.nonNull(additional.getFontSize())) {
            fontSet.setFontSize(additional.getFontSize());
        }
        if (Objects.nonNull(additional.getFontColour())) {
            fontSet.setFontColour(additional.getFontColour());
        }
    }
}

