/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.property.dmn;

import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.Objects;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.TextBox;
import org.jboss.errai.databinding.client.api.Converter;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.api.property.dmn.NameFieldType;
import org.kie.workbench.common.dmn.client.editors.expressions.util.NameUtils;
import org.kie.workbench.common.dmn.client.property.dmn.NameFieldDefinition;
import org.kie.workbench.common.forms.adf.rendering.Renderer;
import org.kie.workbench.common.forms.dynamic.client.rendering.FieldRenderer;
import org.kie.workbench.common.forms.dynamic.client.rendering.formGroups.FormGroup;
import org.kie.workbench.common.forms.dynamic.client.rendering.formGroups.impl.def.DefaultFormGroup;
import org.kie.workbench.common.forms.dynamic.client.rendering.renderers.RequiresValueConverter;
import org.kie.workbench.common.forms.dynamic.service.shared.RenderMode;

@Dependent
@Renderer(type=NameFieldType.class)
public class NameFieldRenderer
extends FieldRenderer<NameFieldDefinition, DefaultFormGroup>
implements RequiresValueConverter {
    private static final NameToStringConverter CONVERTER = new NameToStringConverter();
    protected TextBox textBox;

    @Inject
    public NameFieldRenderer(TextBox textBox) {
        this.textBox = textBox;
        this.textBox.addChangeHandler(e -> {
            String name = textBox.getValue();
            String normalisedName = NameUtils.normaliseName(name);
            if (!Objects.equals(normalisedName, name)) {
                textBox.setValue((Object)normalisedName);
            }
        });
    }

    public String getName() {
        return NameFieldDefinition.FIELD_TYPE.getTypeName();
    }

    protected FormGroup getFormGroup(RenderMode renderMode) {
        DefaultFormGroup formGroup = (DefaultFormGroup)this.formGroupsInstance.get();
        if (renderMode.equals((Object)RenderMode.PRETTY_MODE)) {
            HTML html = new HTML();
            formGroup.render((Widget)html, this.field);
        } else {
            String inputId = this.generateUniqueId();
            this.textBox.setName(this.fieldNS);
            this.textBox.setId(inputId);
            this.textBox.setEnabled(((NameFieldDefinition)this.field).getReadOnly() == false);
            this.registerFieldRendererPart((IsWidget)this.textBox);
            formGroup.render(inputId, (Widget)this.textBox, this.field);
        }
        return formGroup;
    }

    protected void setReadOnly(boolean readOnly) {
        this.textBox.setEnabled(!readOnly);
    }

    public Converter getConverter() {
        return CONVERTER;
    }

    private static final class NameToStringConverter
    implements Converter<Name, String> {
        private NameToStringConverter() {
        }

        public Class<Name> getModelType() {
            return Name.class;
        }

        public Class<String> getComponentType() {
            return String.class;
        }

        public Name toModelValue(String componentValue) {
            return new Name(componentValue);
        }

        public String toWidgetValue(Name modelValue) {
            return modelValue.getValue();
        }
    }
}

