/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.session;

import com.google.common.base.Strings;
import java.util.Objects;
import java.util.Optional;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.kie.workbench.common.dmn.api.qualifiers.DMNEditor;
import org.kie.workbench.common.dmn.client.graph.DMNElementsSynchronizer;
import org.kie.workbench.common.stunner.core.client.api.ClientDefinitionManager;
import org.kie.workbench.common.stunner.core.client.api.ShapeManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvas;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandlerImpl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.actions.TextPropertyProviderFactory;
import org.kie.workbench.common.stunner.core.client.canvas.event.registration.CanvasElementAddedEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.registration.CanvasElementRemovedEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.registration.CanvasElementUpdatedEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.registration.CanvasElementsClearEvent;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandFactory;
import org.kie.workbench.common.stunner.core.client.shape.Shape;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.GraphsProvider;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.HasContentDefinitionId;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.graph.processing.index.GraphIndexBuilder;
import org.kie.workbench.common.stunner.core.graph.processing.index.MutableIndex;
import org.kie.workbench.common.stunner.core.graph.util.GraphUtils;
import org.kie.workbench.common.stunner.core.rule.RuleManager;

@DMNEditor
@Dependent
public class DMNCanvasHandler<D extends Diagram, C extends AbstractCanvas>
extends CanvasHandlerImpl<D, C> {
    private final DMNElementsSynchronizer dmnElementsSynchronizer;
    private final GraphsProvider graphsProvider;

    @Inject
    public DMNCanvasHandler(ClientDefinitionManager clientDefinitionManager, CanvasCommandFactory<AbstractCanvasHandler> commandFactory, RuleManager ruleManager, GraphUtils graphUtils, GraphIndexBuilder<? extends MutableIndex<Node, Edge>> indexBuilder, ShapeManager shapeManager, TextPropertyProviderFactory textPropertyProviderFactory, Event<CanvasElementAddedEvent> canvasElementAddedEvent, Event<CanvasElementRemovedEvent> canvasElementRemovedEvent, Event<CanvasElementUpdatedEvent> canvasElementUpdatedEvent, Event<CanvasElementsClearEvent> canvasElementsClearEvent, DMNElementsSynchronizer dmnElementsSynchronizer, GraphsProvider graphsProvider) {
        super(clientDefinitionManager, commandFactory, ruleManager, graphUtils, indexBuilder, shapeManager, textPropertyProviderFactory, canvasElementAddedEvent, canvasElementRemovedEvent, canvasElementUpdatedEvent, canvasElementsClearEvent);
        this.dmnElementsSynchronizer = dmnElementsSynchronizer;
        this.graphsProvider = graphsProvider;
    }

    protected void beforeElementUpdated(Element element, Shape shape) {
        super.beforeElementUpdated(element, shape);
        if (element instanceof Node) {
            this.dmnElementsSynchronizer.synchronizeFromNode(Optional.of((Node)element));
            this.updateDiagramId(element);
        }
    }

    void updateDiagramId(Element element) {
        HasContentDefinitionId hasContentDefinitionId;
        Object definition;
        Object content = element.getContent();
        if (content instanceof Definition && (definition = ((Definition)content).getDefinition()) instanceof HasContentDefinitionId && Strings.isNullOrEmpty((String)(hasContentDefinitionId = (HasContentDefinitionId)definition).getDiagramId())) {
            hasContentDefinitionId.setDiagramId(this.getGraphsProvider().getCurrentDiagramId());
        }
    }

    GraphsProvider getGraphsProvider() {
        return this.graphsProvider;
    }

    public void addChild(Element parent, Element child) {
        Shape parentShape;
        if (!this.isCanvasRoot(parent) && Objects.isNull(parentShape = this.getCanvas().getShape(parent.getUUID()))) {
            return;
        }
        this.superAddChild(parent, child);
    }

    void superAddChild(Element parent, Element child) {
        super.addChild(parent, child);
    }
}

